Program Example01;
{ Example program demonstrating the basic loading of a 3d object and }
{ spinning it on the screen.                                         }

Uses
  Types,   { Inertia type declarations     }
  Inertia, { the 3d engine                 }
  Mode13h, { Basic Mode 13h graphics unit  }
  Crt;

Var
  View : ViewObject;   { The View System }
  Obj  : VectorObject; { A vector object }

Begin
  If (LoadPalette('COPPRENV.PAL', 0) <> I_OK)       { load the palette }
    Then Begin
      Writeln('Error loading Palette.');
      Halt(0);
    End;
  If (LoadIntensityTable('COPPRENV.IT', 0) <> I_OK) { load intensity table }
    Then Begin
      Writeln('Error loading Intensity table.');
      Halt(0);
    End;
  If (LoadGVO(Obj, 'TORUS.GVO', 0) <> I_OK)         { load the vector object }
    Then Begin
      Writeln('Error loading TORUS object.');
      Halt(0);
    End;
  If (InitView(View, Obj.Num_Polygons Div 2) <> I_OK) { init the view }
    Then Begin
      Writeln('Error Initializing view.');
      Halt(0);
    End;
  SetMode($13);              { Set graphics mode }
  SetPalette(GlobalPalette); { Set the palette }

  SetAbsoluteLocation(Obj, 0, 0, Obj.Radius * 5); { Set the object's location }
  PushLightSource(View, 0, 0, -1);  { Add a light source }

  SetSurface(Obj, SMOOTH);    { set smooth surface }
  SetShading(Obj, LAMBERT);   { set lambert rendering for object }

  SetBaseColor(Obj, 36);      { set the object's color }

  Repeat
    SetDeltaRotation(Obj, 1, 2, 3);  { rotate the object  }
    AddtoRenderList(View, Obj);      { add it to the view }
    Render(View, VirtualPage);       { render to the virtual page }
    Flip;                            { Copy the page over }
  Until KeyPressed;

  FreeView(View);         { Free the view's allocated memory }
  FreeVectorObject(Obj);  { free the vector object's allocated memory }
  FreeIntensityTable;     { free the intensity table from memory }

  SetMode($03);           { return to text mode }
End.
