p386
ideal
locals
largestack

;

o equ offset
b equ byte
w equ word
d equ dword
s equ short
n equ near
f equ far

;

include "..\pmode\pmode.inc"
include "..\argc\argc.inc"
include "..\fmath\fmath.inc"
include "..\routines\routines.inc"
include "..\include\strucs.inc"
include "video.inc"

include "..\include\macros.inc"

;

segment code32 page public use32
        assume cs:code32, ds:code32

;

align 4
clip_left       dd ?
clip_right      dd ?
clip_top        dd ?
clip_bottom     dd ?

video_ptr       dd ?
buffer_ptr      dd ?

mode_x          dd ?
mode_bx         dd ?
mode_y          dd ?
page_bytes      dd ?

svga_buffer     dd 0

scr_muls:
dd 480 dup ( ? )

light_ptr       dd ?
tex_ptr         dd ?

palette         db 768 dup ( ? )

inited          db 0
dpmi            db 0
svga_mode       db 0

;

align 32
proc    init_video n

        cmp     [inited], 1
        je      @@done

        pushad
if HIGH_COLOUR
        call    init_hicolour
        jc      @@error
ELSE
        mov     al, 's'
        call    checkswitchnc
        jc      @@no_svga

        mov     [svga_mode], 1

@@no_svga:
        cmp     [svga_mode], 1
        je      @@svga

        call    init_13h
        jc      @@error
        jmp     @@ok

@@svga:
        call    init_svga
        jc      @@error

@@ok:
endif
        mov     [inited], 1
        popad

@@done:
        clc
        ret

@@error:
        popad
        stc
        ret

endp
 
;

align 32
proc    init_13h n

        mov     ecx, 64000
        mov     eax, [_himembase]
        add     [_himembase], ecx
        mov     [buffer_ptr], eax
        mov     edi, eax
        mov     ecx, 16000
        xor     eax, eax
        rep stosd

        mode13

        call    init_vnwait

        mov     [page_bytes], 64000

        mov     [mode_x], 320
        mov     [mode_bx], 320
        mov     [mode_y], 200

        mov     [clip_left], 0
        mov     [clip_top], 0
        mov     [clip_right], 320
        mov     [clip_bottom], 200

        mov     eax, 0a0000h
        sub     eax, [_code32a]
        mov     [video_ptr], eax

        xor     eax, eax
        mov     ecx, [mode_y]
        mov     edi, o scr_muls

@@make_muls:
        mov     [edi], eax
        add     eax, [mode_bx]
        add     edi, 4
        dec     ecx
        jnz     @@make_muls

@@done:
        clc
        ret

@@error:
        stc
        ret

endp

;

align 32
proc    init_svga n

        mov     ecx, 640*480
        mov     eax, [_himembase]
        add     [_himembase], ecx
        mov     [buffer_ptr], eax
        mov     edi, eax
        mov     ecx, 640*480/4
        xor     eax, eax
        rep stosd

        mov     eax, [_lomembase]
        add     eax, [_code32a]
        mov     ebx, eax
        and     eax, 0fh
        shr     ebx, 4
        mov     [v86r_es], bx
        mov     [v86r_di], ax

        mov     ebx, [_lomembase]
        mov     [d ebx], '2EBV'
        mov     [v86r_ax], 4f01h
        mov     [v86r_cx], 101h
        mov     al, 10h
        int     33h

        mov     eax, [ebx + modeinfo.physptr]
        test    eax, eax
        jz      @@error
        
        mov     [svga_buffer], eax

        mov     [v86r_ax], 4f02h
        mov     [v86r_bx], 4101h
        mov     eax, 10h
        int     33h
        cmp     [v86r_ax], 4fh
        jne     @@error

        call    init_vnwait

        mov     [page_bytes], 640*480

        mov     [mode_x], 640
        mov     [mode_bx], 640
        mov     [mode_y], 480

        mov     [clip_left], 0
        mov     [clip_top], 0
        mov     [clip_right], 640
        mov     [clip_bottom], 480

        sub     esp, 4
        mov     [d esp], 512
        fild    [d esp]
        fst     [x_scale]
        fstp    [y_scale]
        mov     [d esp], 320
        fild    [d esp]
        fst     [x_middle]
        mov     [d esp], 240
        fild    [d esp]
        fst     [y_middle]
        add     esp, 4

        mov     eax, [svga_buffer]
        sub     eax, [_code32a]
        mov     [video_ptr], eax

        cmp     [_sysbyte0], 3
        jne     @@no_dpmi

        mov     [dpmi], 1
        mov     bx, [w video_ptr + 2]
        mov     cx, [w video_ptr]
        mov     si, 1024 / 64
        mov     di, 0
        mov     eax, 800h
        int     31h
        jc      @@no_dpmi

        shl     ebx, 16
        mov     bx, cx
        mov     [video_ptr], ebx
        
@@no_dpmi:
        xor     eax, eax
        mov     ecx, [mode_y]
        mov     edi, o scr_muls

@@make_muls:
        mov     [edi], eax
        add     eax, [mode_bx]
        add     edi, 4
        dec     ecx
        jnz     @@make_muls

@@done:
        clc
        ret

@@error:
        stc
        ret

endp

;

align 32
proc    init_hicolour n

        mov     ecx, 640*480*2
        mov     eax, [_himembase]
        add     [_himembase], ecx
        mov     [buffer_ptr], eax
        mov     edi, eax
        mov     ecx, 640*480*2/4
        xor     eax, eax
        rep stosd

        mov     eax, [_lomembase]
        add     eax, [_code32a]
        mov     ebx, eax
        and     eax, 0fh
        shr     ebx, 4
        mov     [v86r_es], bx
        mov     [v86r_di], ax

        mov     ebx, [_lomembase]
        mov     [d ebx], '2EBV'
        mov     [v86r_ax], 4f01h
        mov     [v86r_cx], 111h
        mov     al, 10h
        int     33h

        mov     eax, [ebx + modeinfo.physptr]
        test    eax, eax
        jz      @@error
        
        mov     [svga_buffer], eax

        mov     [v86r_ax], 4f02h
        mov     [v86r_bx], 4111h
        mov     eax, 10h
        int     33h
        cmp     [v86r_ax], 4fh
        jne     @@error

        call    init_vnwait

        mov     [page_bytes], 640*480*2

        mov     [mode_x], 640
        mov     [mode_bx], 640*2
        mov     [mode_y], 480

        mov     [clip_left], 0
        mov     [clip_top], 0
        mov     [clip_right], 640
        mov     [clip_bottom], 480

        sub     esp, 4
        mov     [d esp], 512
        fild    [d esp]
        fst     [x_scale]
        fstp    [y_scale]
        mov     [d esp], 320
        fild    [d esp]
        fst     [x_middle]
        mov     [d esp], 240
        fild    [d esp]
        fst     [y_middle]
        add     esp, 4

        mov     eax, [svga_buffer]
        sub     eax, [_code32a]
        mov     [video_ptr], eax

        cmp     [_sysbyte0], 3
        jne     @@no_dpmi

        mov     [dpmi], 1
        mov     bx, [w video_ptr + 2]
        mov     cx, [w video_ptr]
        mov     si, 1024 / 64
        mov     di, 0
        mov     eax, 800h
        int     31h
        jc      @@no_dpmi

        shl     ebx, 16
        mov     bx, cx
        mov     [video_ptr], ebx
        
@@no_dpmi:
        xor     eax, eax
        mov     ecx, [mode_y]
        mov     edi, o scr_muls

@@make_muls:
        mov     [edi], eax
        add     eax, [mode_bx]
        add     edi, 4
        dec     ecx
        jnz     @@make_muls

@@done:
        clc
        ret

@@error:
        stc
        ret

endp

;

align 32
proc    reset_video n

        cmp     [inited], 1
        jne     @@done

        push    eax

        mode3

        cmp     [dpmi], 1
        jne     @@no_dpmi

        mov     bx, [w video_ptr + 2]
        mov     cx, [w video_ptr]
        mov     eax, 801h
        int     31h

@@no_dpmi:
        mov     [inited], 0
        pop     eax

@@done:
        ret

endp

;

align 32
proc    init_vnwait n

        mov     edx, 3dah

l101:
        in      al, dx
        test    al, 8
        jz      l101

        mov     ecx, -1

l102:
        in      al, dx
        test    al, 1
        jnz     l102

        cli

l103:
        in      al, dx
        test    al, 1
        jz      l103

l104:
        in      al, dx
        test    al, 1
        loopnz  l104

        sti
        neg     ecx
        add     ecx, ecx
        mov     [max_loop], ecx

        ret

endp

max_loop dd 1

;

align 32
proc    vnwait n

        push    eax ecx edx
        mov     edx, 3dah

@@l201:
        in      al, dx
        test    al, 1
        jnz     @@l201

@@l202:
        mov     ecx, [max_loop]

@@l203:
        in      al, dx
        test    al, 1
        jz      @@l203

@@l204:
        in      al, dx
        test    al, 1
        loopnz  @@l204
        jz      @@l202

        pop     edx ecx eax
        ret

endp

;

ends    code32

;

end


