p486
p487
ideal
locals
largestack

;

o equ offset
b equ byte
w equ word
d equ dword
s equ short
n equ near
f equ far

;

segment code32 page public use32
        assume cs:code32, ds:code32

include "..\include\macros.inc"
include "..\pmode\pmode.inc"
include "..\video\video.inc"
include "..\include\strucs.inc"
include "..\fmath\fmath.inc"

include "scan.inc"
include "scan_lll.inc"

;

struc   edge_struc
X               dd ?
XStep           dd ?
Y               dd ?
Height          dd ?
U               dd ?
UStep           dd ?
V               dd ?
VStep           dd ?
ends

;

macro   sort_vertices  

        fld     [d ebx + 4]
        fcomp   [d ecx + 4]
        fnstsw  ax
        and     ah, 41h
        jz      @@0_not_top

        fld     [d ebx + 4]
        fcomp   [d edx + 4]
        fnstsw  ax
        and     ah, 41h
        jz      @@0_not_top

@@0_top:
        ;get texel coords
        mov     eax, [esi + polygon.u1]
        mov     ebp, [esi + polygon.u2]
        mov     edi, [esi + polygon.u3]
        mov     [U], eax
        mov     [U + 4], ebp
        mov     [U + 8], edi
        mov     eax, [esi + polygon.v1]
        mov     ebp, [esi + polygon.v2]
        mov     edi, [esi + polygon.v3]
        mov     [V], eax
        mov     [V + 4], ebp
        mov     [V + 8], edi

        jmp     @@sorted

@@0_not_top:
        fld     [d ecx + 4]
        fcomp   [d ebx + 4]
        fnstsw  ax
        and     ah, 41h
        jz      @@1_not_top

        fld     [d ecx + 4]
        fcomp   [d edx + 4]
        fnstsw  ax
        and     ah, 41h
        jz      @@1_not_top

@@1_top:
        mov     eax, ebx
        mov     ebx, ecx
        mov     ecx, edx
        mov     edx, eax

        ;get texel coords
        mov     eax, [esi + polygon.u2]
        mov     ebp, [esi + polygon.u3]
        mov     edi, [esi + polygon.u1]
        mov     [U], eax
        mov     [U + 4], ebp
        mov     [U + 8], edi
        mov     eax, [esi + polygon.v2]
        mov     ebp, [esi + polygon.v3]
        mov     edi, [esi + polygon.v1]
        mov     [V], eax
        mov     [V + 4], ebp
        mov     [V + 8], edi

        jmp     @@sorted

@@1_not_top:
@@2_top:
        mov     eax, ebx
        mov     ebx, edx
        mov     edx, ecx
        mov     ecx, eax

        ;get texel coords
        mov     eax, [esi + polygon.u3]
        mov     ebp, [esi + polygon.u1]
        mov     edi, [esi + polygon.u2]
        mov     [U], eax
        mov     [U + 4], ebp
        mov     [U + 8], edi
        mov     eax, [esi + polygon.v3]
        mov     ebp, [esi + polygon.v1]
        mov     edi, [esi + polygon.v2]
        mov     [V], eax
        mov     [V + 4], ebp
        mov     [V + 8], edi

@@sorted:

endm

;

macro   copy_vertices  

        mov     eax, [ebx]
        mov     ebp, [ebx + 4]
        mov     [X], eax
        mov     [Y], ebp

        mov     eax, [ecx]
        mov     ebp, [ecx + 4]
        mov     [X + 4], eax
        mov     [Y + 4], ebp

        mov     eax, [edx]
        mov     ebp, [edx + 4]
        mov     [X + 8], eax
        mov     [Y + 8], ebp

endm

;

macro   gradients  

        ;calculate common x-product terms
        fld     [X]
        fsub    [X + 8]                 
        fld     [X + 4]
        fsub    [X + 8]
        fld     [Y]
        fsub    [Y + 8]
        fld     [Y + 4]                 
        fsub    [Y + 8]                 ;y2, y1, x2, x1
        fxch    st(3)                   ;x1, y1, x2, y2
        fstp    [Ax_Cx]                 ;y1, x2, y2
        fxch    st(1)                   ;x2, y1, y2
        fstp    [Bx_Cx]                 ;y1, y2
        fstp    [Ay_Cy]                 ;y2
        fstp    [By_Cy]

        fld     [U]
        fsub    [U + 8]
        fld     [U + 4]
        fsub    [U + 8]
        fld     [V]
        fsub    [V + 8]
        fld     [V + 4]
        fsub    [V + 8]                 ;v2, v1, u2, u1
        fxch    st(3)                   ;u1, v1, u2, v2
        fstp    [Au_Cu]                 ;v1, u2, v2
        fxch    st(1)                   ;u2, v1, v2
        fstp    [Bu_Cu]
        fstp    [Av_Cv]
        fstp    [Bv_Cv]

        ;calculate x-products
        fld1
        fld     [Bx_Cx]
        fmul    [Ay_Cy]
        fld     [Ax_Cx]
        fmul    [By_Cy]
        fsub                                    ;aargh
        fdiv                                    ;aargh
        fst     [OneOverdX]
        fstp    [OneOverdY]
        xor     [b OneOverdY + 3], 80h

        fld     [Bu_Cu]
        fmul    [Ay_Cy]
        fld     [Au_Cu]
        fmul    [By_Cy]
        fld     [Au_Cu]
        fmul    [Bx_Cx]                 
        fld     [Bu_Cu]
        fmul    [Ax_Cx]                 ;ax, bx, by, ay
        fxch    st(2)                   ;by, bx, ax, ay
        fsubp   st(3), st               ;bx, ax, ay-by
        fsub                            ;ax-bx, ay-by
        fxch    st(1)
        fmul    [OneOverdX]
        fxch    st(1)
        fmul    [OneOverdY]
        fxch    st(1)
        fist    [dUdX_int]
        fstp    [dUdX]
        fstp    [dUdY]

        fld     [Bv_Cv]
        fmul    [Ay_Cy]
        fld     [Av_Cv]
        fmul    [By_Cy]
        fld     [Av_Cv]
        fmul    [Bx_Cx]                 
        fld     [Bv_Cv]
        fmul    [Ax_Cx]                 ;ax, bx, by, ay
        fxch    st(2)                   ;by, bx, ax, ay
        fsubp   st(3), st               ;bx, ax, ay-by
        fsub                            ;ax-bx, ay-by
        fxch    st(1)
        fmul    [OneOverdX]
        fxch    st(1)
        fmul    [OneOverdY]
        fxch    st(1)
        fist    [dVdX_int]
        fstp    [dVdX]
        fstp    [dVdY]

endm

;

align 32
proc    edge n

        fld     [ebx + Y]
        fadd    [scan_half]
        fld     [esi + Y]
        fadd    [scan_half]
        fxch    st(1)
        fistp   [edi + edge_struc.Y]
        fistp   [YEnd]

        mov     eax, [YEnd]
        sub     eax, [edi + edge_struc.Y]
        mov     [edi + edge_struc.Height], eax

        fild    [edi + edge_struc.Y]
        fsub    [ebx + Y]
        fstp    [YPrestep]

        fld     [esi + X]
        fsub    [ebx + X]
        fld     [esi + Y]
        fsub    [ebx + Y]
        fdiv
        fst     [edi + edge_struc.XStep]
        fmul    [YPrestep]
        fst     [XPrestep]
        fadd    [ebx + X]
        fstp    [edi + edge_struc.X]

        fld     [YPrestep]
        fmul    [dUdY]
        fld     [XPrestep]
        fmul    [dUdX]
        fld     [edi + edge_struc.XStep]
        fmul    [dUdX]                          ;us, u2, u1
        fxch    st(1)                           ;u2, us, u1
        faddp   st(2), st                       ;us, u
        fadd    [dUdY]                          ;us, u
        fxch    st(1)                           ;u, us
        fadd    [ebx + U]                       ;u, us
        fxch    st(1)                           ;us, u
        fstp    [edi + edge_struc.UStep]        ;u
        fstp    [edi + edge_struc.U]

        fld     [YPrestep]
        fmul    [dVdY]
        fld     [XPrestep]
        fmul    [dVdX]
        fld     [edi + edge_struc.XStep]
        fmul    [dVdX]                          ;us, u2, u1
        fxch    st(1)                           ;u2, us, u1
        faddp   st(2), st                       ;us, u
        fadd    [dVdY]                          ;us, u
        fxch    st(1)                           ;u, us
        fadd    [ebx + V]                       ;u, us
        fxch    st(1)                           ;us, u
        fstp    [edi + edge_struc.VStep]        ;u
        fstp    [edi + edge_struc.V]
        ret

endp

;

macro   get_toptomiddle
local   rightismiddle, done

        cmp     [leftismiddle], 1
        jne     rightismiddle

        mov     esi, o TopToMiddle
        mov     edi, o L_X
        mov     ecx, 8
        rep movsd
        mov     esi, o TopToBottom
        mov     edi, o R_X
        mov     ecx, 8
        rep movsd
        jmp     done

rightismiddle:
        mov     esi, o TopToMiddle
        mov     edi, o R_X
        mov     ecx, 8
        rep movsd
        mov     esi, o TopToBottom
        mov     edi, o L_X
        mov     ecx, 8
        rep movsd

done:

endm

;

macro   get_middletobottom
local   rightismiddle, done

        mov     ecx, 8
        mov     esi, o MiddleToBottom
        push    edi

        cmp     [leftismiddle], 1
        jne     rightismiddle

        mov     edi, o L_X
        rep movsd
        jmp     done

rightismiddle:
        mov     edi, o R_X
        rep movsd
        mov     eax, [YPrestepL2]
        mov     ebx, [YPrestepR2]
        mov     [YPrestepR2], eax
        mov     [YPrestepL2], ebx

done:
        pop     edi

endm

;

align 32
proc    edge_step n

        fld     [L_X]
        fadd    [L_XStep]
        fld     [L_U]
        fadd    [L_UStep]
        fld     [L_V]                   ;v, u, x
        fadd    [L_VStep]               ;v, u, x
        fxch    st(2)                   ;x, u, v    
        fstp    [L_X]                   ;u, v     
        fstp    [L_U]                   ;v
        fstp    [L_V]

        fld     [R_X]
        fadd    [R_XStep]
        fld     [R_U]
        fadd    [R_UStep]
        fld     [R_V]                   ;v, u, x
        fadd    [R_VStep]               ;v, u, x
        fxch    st(2)                   ;x, u, v    
        fstp    [R_X]                   ;u, v     
        fstp    [R_U]                   ;v
        fstp    [R_V]
        ret

endp

;

align 32
proc    edge_multi_step n

        cmp     [YPrestepL1], 0
        je      @@done_l

        fild    [YPrestepL1]            
        ;fstp    [YPrestepL1]            

        fld     [L_XStep]                     
        fmul    st, st(1) ;[YPrestepL1]
        fld     [L_UStep]
        fmul    st, st(2) ;[YPrestepL1]
        fld     [L_VStep]                   
        fmulp   st(3), st ;[YPrestepL1] ;u, x, v

        fxch    st(1)                   ;x, u, v     
        fadd    [L_X]                    
        fxch    st(1)                   ;u, x, v      
        fadd    [L_U]
        fxch    st(2)                   ;v, x, u     
        fadd    [L_V]          

        fxch    st(1)                   ;x, v, u    
        fstp    [L_X]                   ;v, u     
        fxch    st(1)                   ;u, v    
        fstp    [L_U]                   ;v
        fstp    [L_V]                   

@@done_l:
        cmp     [YPrestepR1], 0
        je      @@done_r

        fild    [YPrestepR1]            ;1-3
        ;fstp    [YPrestepR1]            ;4-5

        fld     [R_XStep]                     
        fmul    st, st(1) ;[YPrestepR1]
        fld     [R_UStep]
        fmul    st, st(2) ;[YPrestepR1]
        fld     [R_VStep]                   ;v, u, x
        fmulp   st(3), st ;[YPrestepR1]

        fxch    st(1)                   ;x, u, v     
        fadd    [R_X]                    
        fxch    st(1)                   ;u, x, v      
        fadd    [R_U]
        fxch    st(2)                   ;v, x, u     
        fadd    [R_V]          

        fxch    st(1)                   ;x, v, u    
        fstp    [R_X]                   ;v, u     
        fxch    st(1)                   ;u, v    
        fstp    [R_U]                   ;v
        fstp    [R_V]                   

@@done_r:
        ret

endp

;

align 32
proc    draw_scanline n

        fld     [L_X]
        fadd    [scan_half]
        fld     [R_X]
        fadd    [scan_half]
        fxch    st(1)
        fistp   [@@XStart]
        fistp   [@@XEnd]

        fild    [@@XStart]
        fsub    [L_X]
        fstp    [@@XPrestep]

        mov     ebx, [@@XStart]
        mov     ebp, [@@XEnd]
        mov     esi, ebp

if HIGH_COLOUR
        lea     edi, [edi + ebx*2]
else
        add     edi, ebx
endif
        sub     ebp, ebx
        jle     @@done

        cmp     ebx, [clip_right]
        jg      @@done
        sub     ebx, [clip_left]
        jge     @@leftok

        neg     ebx
        sub     ebp, ebx
        jle     @@done

if HIGH_COLOUR
        lea     edi, [edi + ebx*2]
else
        add     edi, ebx
endif
        fld     [@@XPrestep]
        mov     [@@XPrestep], ebx
        fild    [@@XPrestep]
        fadd
        fstp    [@@XPrestep]

@@leftok:
        cmp     esi, [clip_left]
        jl      @@done
        sub     esi, [clip_right] 
        jle     @@rightok
        
        sub     ebp, esi
        jle     @@done

@@rightok:
        fld     [dUdX]             
        fmul    [@@XPrestep]       
        fld     [dVdX]             
        fmul    [@@XPrestep]       
        fxch    st(1)              ;u, v, i
        fadd    [L_U]              
        fxch    st(1)              ;v, u, i
        fadd    [L_V]              
        fxch    st(1)              ;u, i, v
        fistp   [@@U_int]         ;i, v
        fistp   [@@V_int]         ;i

        mov     edx, [@@U_int]
        mov     eax, [@@V_int]
        shl     edx, 16
        shl     eax, 16

        mov     ebx, [dUdX_int]
        mov     esi, ebx
        sar     ebx, 16
        shl     esi, 16
        mov     dl, bl

        mov     ebx, [dVdX_int]
        mov     ecx, ebx
        sar     ebx, 16
        shl     ecx, 16
        mov     dh, bl

        mov     ebx, [tex_ptr]
if HIGH_COLOUR
        shr     ebx, 1
endif
        mov     bl, [b @@U_int + 2]
        mov     bh, [b @@V_int + 2]

if HIGH_COLOUR
        lea     edi, [edi + ebp*2]
else
        add     edi, ebp
endif
        neg     ebp

@@texture_n_loop:
if HIGH_COLOUR
        mov     ax, [ebx*2]
else
        mov     al, [ebx]
endif
        add     edx, esi

        adc     bl, dl
        add     eax, ecx

        adc     bh, dh

if HIGH_COLOUR
        mov     [edi + ebp*2], ax
else
        mov     [edi + ebp], al
endif

        inc     ebp
        jnz     @@texture_n_loop

@@done:
        ret

align 4
@@XStart        dd ?
@@XPrestep      dd ?
@@XEnd          dd ?
@@U             dd ?
@@V             dd ?
@@U_int         dd ?
@@V_int         dd ?

endp

;
;In:
;       esi: polygon

align 32
proc    scan_lll n

        mov     ebx, [esi + polygon.connect1]
        mov     ecx, [esi + polygon.connect2]
        mov     edx, [esi + polygon.connect3]
        add     ebx, [scan_pts]
        add     ecx, [scan_pts]
        add     edx, [scan_pts]

        sort_vertices
        copy_vertices

        gradients

        get_middle
        make_edges

        get_toptomiddle
        topbottom_clip
        mov     edi, [edi*4 + o scr_muls]
        add     edi, [scan_dest]
        draw_toptomiddle

        get_middletobottom
        draw_middletobottom

done_scan:
        ret

endp

;

align 4
TopToBottom     edge_struc <>
TopToMiddle     edge_struc <>
MiddleToBottom  edge_struc <>

L_X             dd ?
L_XStep         dd ?
L_Y             dd ?
L_Height        dd ?
L_U             dd ?
L_UStep         dd ?
L_V             dd ?
L_VStep         dd ?

R_X             dd ?
R_XStep         dd ?
R_Y             dd ?
R_Height        dd ?
R_U             dd ?
R_UStep         dd ?
R_V             dd ?
R_VStep         dd ?

;

ends    code32

;
;

end
