p486
p487
ideal
locals
largestack

;

o equ offset
b equ byte
w equ word
d equ dword
s equ short
n equ near
f equ far

;

segment code32 page public use32
        assume cs:code32, ds:code32

include "..\pmode\pmode.inc"
include "routines.inc"
include "..\include\macros.inc"

;
; put '$' terminated message to dos
; in:
;   edx -> message in low mem
;

align 32
putdosmsg:
        push    eax edx
        add     edx, [_code32a]
        mov     al, dl
        and     ax, 0fh
        shr     edx, 4
        mov     [v86r_ds], dx
        mov     [v86r_dx], ax
        mov     [v86r_ah], 9
        mov     al, 21h
        int     33h
        pop     edx eax
        ret

;

align 32
proc printnum near

        push    ecx edx esi edi

        mov     edi, offset numbuffer
        call    bin2ascii

        mov     ecx, ebp
        dec     ecx
        jz      doneflush

        mov     esi, offset numbuffer + 10
        sub     esi, ebp

flushzeroes:
        cmp     [b esi], '0'
        jne     doneflush

        mov     [b esi], ' '
        inc     esi
        dec     ecx
        jnz     flushzeroes

doneflush:
        mov     edx, offset numbuffer + 10
        sub     edx, ebp
        call    putdosmsg

        pop     edi esi edx ecx
        ret

endp

numbuffer       db 10 dup ( ? ), '$'

;

align 32
proc printpnum near

        push    edx edi
        mov     edi, offset pnumbuffer
        call    pbin2ascii

        push    ecx esi
        mov     ecx, ebp
        dec     ecx
        jz      pdoneflush

        mov     ecx, 9
        mov     esi, offset pnumbuffer

pflushzeroes:
        cmp     [b esi], '.'
        jne     pf_nopoint

        mov     [b esi-1], '0'
        jmp     pdoneflush

pf_nopoint:
        cmp     [b esi], '0'
        jne     pdoneflush

        mov     [b esi], ' '
        inc     esi
        dec     ecx
        jnz     pflushzeroes

pdoneflush:
        pop     esi ecx

        mov     edx, offset pnumbuffer
        call    putdosmsg
        pop     edi edx 
        ret

endp

pnumbuffer       db 11 dup ( ? ), '$'

;
;From Future Crew's Mental Surgery (so I guess Psi)

align 32
proc    rnd n

        push    ebx ecx edx
        mov     eax, [seed1]
        mov     ebx, [seed2]
        mov     ecx, [seed3]
        mov     edx, [seed4]

        add     ax, bx
        rol     ax, cl
        xor     ax, dx
        xchg    cl, ch
        add     bx, cx
        add     dx, bx
        add     cx, ax
        ror     bx, 1
        sbb     ax, dx
        and     eax, 0ffffh

        mov     [seed4], edx
        mov     [seed3], edx
        mov     [seed2], edx
        mov     [seed1], eax

        pop     edx ecx ebx
        ret

endp

seed1   dd 1234h
seed2   dd 5678h
seed3   dd 1234
seed4   dd 5678

;
; In:
;       eax: number
;       edi: ascii buffer
;       ebp: num digits to print

align 32
proc    bin2ascii near

        pushad
        mov     ecx,10
        mov     ebx,10

b2a_dlnum:
        xor     edx, edx
        div     ebx
        add     edx, '0'
        push    edx
        dec     ecx
        jnz     b2a_dlnum

        mov     ecx, 10

b2a_dlnum2:
        pop     eax

        stosb

b2a_dontprintthisyet:
        dec     ecx
        jnz     b2a_dlnum2

        popad    
        ret

endp

;
; In:
;       eax: number
;       esi: decimal places
;       edi: ascii buffer
;       ebp: num digits to print

align 32
proc    pbin2ascii near

        pushad
        mov     ecx,10
        mov     ebx,10

pb2a_dlnum:
        xor     edx, edx
        div     ebx
        add     edx, '0'
        push    edx      ;push the result
        dec     ecx
        jnz     pb2a_dlnum

        mov     ecx, 10

pb2a_dlnum2:
        cmp     ecx, esi
        jne     pnop

        mov     eax, '.'
        stosb

pnop:
        pop     eax
        cmp     ecx, ebp
        ja      pb2a_dontprintthisyet

        stosb

pb2a_dontprintthisyet:
        dec     ecx
        jnz     pb2a_dlnum2

        popad    
        ret

endp

;

align 32
proc    init_elapse n

        cmp     [_sysbyte0], 3
        jne     @@no_dpmi

        ;This is for windows - which counts in divide-by-2 mode
        mov     al, 00110100b
        out     43h, al

@@no_dpmi:
        mov     [midnight_add], 0
        mov     [midnight_add + 4], 0

        xor     edx, edx
        mov     eax, 1800b0h
        shld    edx, eax, 16
        shl     eax, 16
        mov     [midnight_inc], eax
        mov     [midnight_inc + 4], edx

        xor     ebx, ebx
        readtimer
        readclock
        shld    ebx, eax, 16
        shl     eax, 16
        add     eax, edx
        mov     [el_start], eax
        mov     [el_start + 4], ebx
        ret

endp

el_start        dd ?, ?
midnight_inc    dd ?, ?
midnight_add    dd ?, ?

;
;Out:
;       edx:eax: time in ticks since last init_elapse

align 32
proc    elapse n

        xor     ebx, ebx
        readtimer
        readclock
        shld    ebx, eax, 16
        shl     eax, 16
        add     eax, edx
        sub     eax, [el_start]
        sbb     ebx, [el_start + 4]
        mov     edx, ebx
        jnc     @@ok

        add     eax, [midnight_add]
        adc     edx, [midnight_add + 4]

        mov     ebx, [midnight_inc]
        add     [midnight_add], ebx
        mov     ebx, [midnight_inc + 4]
        adc     [midnight_add + 4], ebx

@@ok:
        ret

endp

;

ends    code32

;
;

end
