;

;Spheremapping routines 
include "sp_map.inc"

;

align 32
proc    get_time n

        ;Get the time in ticks since we started
        call    elapse

        ;Get the time in ticks since we last got the time (last frame)
        push    eax edx
        sub     eax, [last]
        sbb     edx, [last + 4]

        ;Alloc some local storage
        sub     esp, 12
        mov     [d esp], eax
        mov     [d esp + 4], edx
        mov     [d esp + 8], 1234ddh

        ;Time in seconds = time in ticks / 1234ddh (ticks per second)
        fild    [q esp]
        fild    [d esp + 8]
        fdiv
        fstp    [seconds]
        add     esp, 12

        pop     edx eax
        mov     [last], eax
        mov     [last + 4], edx
        ret

endp

;

align 32
proc    update_frame n

        ;Get the last frame duration in seconds
        call    get_time

;

        ;x = x(0) + v * t
        ;Update the angle (heading) of the dragon
        fld     [seconds]
        fmul    [ang_vel]
        fiadd   [angle]
        fistp   [angle]

;

        ;Update the angle2 (pitch) of the dragon
        ;This makes it look like it is falling (I think so anyway)
        mov     eax, [angle]
        call    fld_sin
        fld1
        fadd
        fmul    [@@32768]
        fistp   [angle2]

;

        ;Move the camera in and out a bit for some variety
        ;v = v(0) + a * t
        fld     [dist_acc]
        fmul    [seconds]
        fadd    [dist_vel]
        fst     [dist_vel]
        ;x = x(0) + v * t
        fmul    [seconds]
        fadd    [dist]
        fstp    [dist]

        ;Are we too close?
        fld     [dist]
        fcomp   [min_dist]
        fnstsw  ax
        and     ah, 41h
        jz      @@dist_greaterthan_min

        ;We are too close, start accelerating away at random rate
        call    rnd
        mov     [dist_acc], eax
        fild    [dist_acc]
        fdiv    [dist_accdiv]
        fadd    [dist_accadd]
        fstp    [dist_acc]

        ;Make sure we don't get too close (looks very bad - no volume clipping)
        mov     eax, [min_dist]
        mov     [dist], eax

@@dist_greaterthan_min:
        ;Are we too far?
        fld     [dist]
        fcomp   [max_dist]
        fnstsw  ax
        and     ah, 41h
        jnz     @@dist_lessthan_max

        ;We have already got a new acceleration
        cmp     [dist_acc], 80000000h
        jae     @@dist_lessthan_max

        ;We are too far, start accelerating toward at random rate
        call    rnd
        neg     eax
        mov     [dist_acc], eax
        fild    [dist_acc]
        fdiv    [dist_accdiv]
        fsub    [dist_accadd]
        fstp    [dist_acc]

        ;Doesn't matter if we're a bit too far away

@@dist_lessthan_max:
        ;Set the camera distance
        mov     eax, [dist]
        mov     [z_add], eax

;

        ;Update the dragon animation
        fld     [seconds]
        fmul    [anim_vel]
        fadd    [anim]
        fst     [animd]
        fstp    [anim]

        fild    [num_shape_frames]
        fstp    [anim_max]

;

        ;Wrap around to the first frame if overflow
        mov     eax, [anim_max]
        cmp     eax, [animd]
        ja      @@no_wrap

        fld     [anim]
        fsub    [anim_max]
        fstp    [anim]

@@no_wrap:
        cmp     [animd], 80000000h
        jb      @@sign_ok

        mov     [d anim], 0
        mov     [d anim + 4], 0
        mov     [animd], 0

@@sign_ok:
        ;Get the morphed points for this animation frame
        fld     [anim]
        call    get_morph

;
        ret

@@32768 dd 32768.0

endp

ang_vel         dd 15000.0
angle           dd 0
angle2          dd 0

min_dist        dd 3500.0
max_dist        dd 4500.0 ;7500.0
dist            dd 3500.0
dist_vel        dd 0.0
dist_acc        dd 1024.0
dist_accdiv     dd 64.0
dist_accadd     dd 512.0

anim_vel        dd 4.0
anim            dq 0.0
animd           dd 0.0
anim_max        dd ?

;
;In:
;       st(0): parameter for morph in range [0, num_of_frames]
;
;Morphs between two frames, putting the result into temp_pts

align 32
proc    get_morph n

        ;Extract whole part into @@which, and fractional part into @@parm.
        ;@@which designates which frame to morph.
        ;@@parm is the parameter for the morph, if @@parm = 0.5 we get
        ;a new frame halfway between frame @@which and frame @@which + 1
        roundmode 3             ;Chop
        fld     st
        frndint
        fist    [@@which]
        fsub
        fstp    [@@parm]
        roundmode 0             ;Nearest

        ;Turn the @@which index into a pointer to the morph data
        mov     ebx, [@@which]
        mov     ebx, [ebx*4 + o shape_pts]
        mov     ecx, [shape_numpts]
        mov     esi, [@@which]
        imul    esi, [morph_size]
        add     esi, [morph_mem]
        mov     edi, [temp_pts]

@@morph:
        ;p = p1 + t * (p2 - p1)
        fld     [d esi]
        fmul    [@@parm]
        fld     [d esi + 4]
        fmul    [@@parm]
        fld     [d esi + 8]
        fmul    [@@parm]        ;z, y, x
        fxch    st(2)           ;x, y, z
        fadd    [d ebx]         
        fxch    st(1)           ;y, x, z
        fadd    [d ebx + 4]     
        fxch    st(2)           ;z, x, y
        fadd    [d ebx + 8]     
        fxch    st(1)           ;x, z, y
        fstp    [d edi]         ;z, y
        fxch    st(1)           ;y, z
        fstp    [d edi + 4]     ;z
        fstp    [d edi + 8]

        add     ebx, 16
        add     esi, 16
        add     edi, 16
        dec     ecx
        jnz     @@morph

        ret

align 4
@@parm  dq ?
@@which dd ?

endp

;

align 32
proc    draw_frame n

        ;Spheremap the sky
        ;The angle of the camera is directly the u, v offset of the spheremap
        ;because of how we set up the equations - u, v are spherical coords
        mov     ebx, [sky_ptr]
        xor     ecx, ecx
        mov     eax, [angle]
        neg     eax             ;The camera looking up is the same as the
        shr     eax, 6          ;backdrop tilting down, so neg the angle
        and     eax, 0ffh
        mov     cl, al
        mov     eax, [angle2]
        neg     eax
        shr     eax, 6
        and     eax, 0ffh
        mov     ch, al
        mov     edi, [buffer_ptr]
        mov     ebp, [mode_x]
        imul    ebp, [mode_y]
if HIGH_COLOUR
        call    spheremap_hi
else
        call    spheremap
endif

        ;Generate a matrix for the dragon's rotation
        fld1
        mov     ebx, [angle]
        mov     ecx, [angle2]
        mov     edx, 0
        mov     edi, o f_objmatrix
        call    f_gen_matrix

        ;Project the morphed points with the matrix
        mov     ebx, o f_objmatrix
        mov     ecx, [shape_numpts]
        mov     edx, [rot_pts]
        mov     esi, [temp_pts]
        mov     edi, [proj_pts]
        call    f_matrix_project

        ;Setup the btree for sorting this frame
        ;btree is an abbreviation for binary tree, its not an actual Btree
        mov     edi, [btree_start]
        call    btree_firstnode
        mov     [btree_end], edx

        ;Backface cull and add each poly to the tree
        mov     ecx, [shape_numpolys]
        mov     esi, [shape_polys]

@@sort_polys:
        push    ecx esi
        call    triv
        pop     esi ecx
        add     esi, size polygon
        dec     ecx
        jnz     @@sort_polys

        ;Draw the polys
        mov     edi, [btree_start]
        call    btree_traverse_ascend
        ret

endp

;

macro   farthest_in_eax
local   ok1, ok2

        mov     ecx, [proj_pts]   
        mov     ebx, [esi + polygon.connect1]
        mov     eax, [ebx + ecx + 8]

        mov     ebx, [esi + polygon.connect2]
        cmp     eax, [ebx + ecx + 8]
        jle     ok1

        mov     eax, [ebx + ecx + 8]

ok1:
        mov     ebx, [esi + polygon.connect3]
        cmp     eax, [ebx + ecx + 8]
        jle     ok2

        mov     eax, [ebx + ecx + 8]

ok2:

endm

align 32
proc    triv n

        ;Backface cull
        push    esi
        mov     eax, esi
        mov     ebx, [eax + polygon.connect1]
        mov     esi, [eax + polygon.connect2]
        mov     edi, [eax + polygon.connect3]
        mov     eax, [proj_pts]
        add     ebx, eax
        add     esi, eax
        add     edi, eax
        call    f_checkfront
        cmp     [cf], 0
        pop     esi
        jg      @@visible

@@invisible:
        mov     ebp, o flip_scan
        test    [esi + polygon.flags], 16
        jnz     @@two_sided

@@one_sided:
        ret

@@visible:
        mov     ebp, o scan_lll

@@two_sided:
        farthest_in_eax
        mov     edi, [btree_start]
        mov     edx, [btree_end]
        call    btree_addnode
        mov     [btree_end], edx
        ret

endp

;
;Draw a double-sided poly that is backfacing

align 32
proc    flip_scan n

        ;Flip it around the right way
        mov     eax, [esi + polygon.connect1]
        mov     ebx, [esi + polygon.connect3]
        mov     [esi + polygon.connect3], eax
        mov     [esi + polygon.connect1], ebx

        ;Draw it
        push    esi
        call    scan_lll
        pop     esi

        ;Restore it to normal
        mov     eax, [esi + polygon.connect1]
        mov     ebx, [esi + polygon.connect3]
        mov     [esi + polygon.connect3], eax
        mov     [esi + polygon.connect1], ebx
        ret

endp

;
;Copy the virtual screen to the screen

align 32
proc    blt_frame n

        cmp     [sync], 0
        je      @@no_sync

        call    vnwait

@@no_sync:
        mov     ecx, [page_bytes]
        shr     ecx, 2
        mov     esi, [buffer_ptr]
        mov     edi, [video_ptr]
        rep movsd
        ret

endp

;
