;
;In:
;       edi: tree start
;Out:
;       edx: tree end
;       edi: tree start

align 32
proc    btree_firstnode

        push    eax

        xor     eax, eax
        mov     [edi + btree_node.data], eax
        mov     [edi + btree_node.callback], eax
        mov     [edi + btree_node.sort_key], eax
        mov     [edi + btree_node.front], eax
        mov     [edi + btree_node.back], eax

        lea     edx, [edi + size btree_node]

        pop     eax
        ret

endp

;
;In:
;       eax: sort key
;       esi: data
;       ebp: callback
;       edx: tree end
;       edi: tree start
;Out:
;       edx: new tree end

align 32
proc    btree_addnode

@@cmpbit:
        cmp     eax, [edi + btree_node.sort_key]
        jg      @@goto_back 

@@goto_front:
        mov     ebx, [edi + btree_node.front]
        test    ebx, ebx
        jz      @@add_front 

        mov     edi, ebx
        jmp     @@cmpbit

@@add_front:
        mov     [edi + btree_node.front], edx

        mov     [edx + btree_node.sort_key], eax
        mov     [edx + btree_node.callback], ebp
        mov     [edx + btree_node.data], esi
        mov     [edx + btree_node.back], ebx
        mov     [edx + btree_node.front], ebx

        add     edx, size btree_node
        ret

@@goto_back:
        mov     ebx, [edi + btree_node.back]
        test    ebx, ebx
        jz      @@add_back

        mov     edi, ebx
        jmp     @@cmpbit

@@add_back:
        mov     [edi + btree_node.back], edx

        mov     [edx + btree_node.sort_key], eax
        mov     [edx + btree_node.callback], ebp
        mov     [edx + btree_node.data], esi
        mov     [edx + btree_node.back], ebx
        mov     [edx + btree_node.front], ebx

        add     edx, size btree_node
        ret

endp

;
;In:
;       edi: btree start

align 32
proc    btree_traverse_ascend n

        push    edi

        cmp     [edi + btree_node.front], 0
        je      @@no_front

        mov     edi, [edi + btree_node.front]
        call    btree_traverse_ascend
        mov     edi, [esp]

@@no_front:
        cmp     [edi + btree_node.callback], 0
        je      @@no_call

        mov     esi, [edi + btree_node.data]
        call    [edi + btree_node.callback]
        mov     edi, [esp]

@@no_call:
        cmp     [edi + btree_node.back], 0
        je      @@no_back

        mov     edi, [edi + btree_node.back]
        call    btree_traverse_ascend

@@no_back:
        pop     edi
        ret

endp

;
;In:
;       edi: btree start

align 32
proc    btree_traverse_descend n

        push    edi

        cmp     [edi + btree_node.back], 0
        je      @@no_back

        mov     edi, [edi + btree_node.back]
        call    btree_traverse_descend
        mov     edi, [esp]

@@no_back:
        cmp     [edi + btree_node.callback], 0
        je      @@no_call

        mov     esi, [edi + btree_node.data]
        call    [edi + btree_node.callback]
        mov     edi, [esp]

@@no_call:
        cmp     [edi + btree_node.front], 0
        je      @@no_front

        mov     edi, [edi + btree_node.front]
        call    btree_traverse_descend

@@no_front:
        pop     edi
        ret

endp

;
