p386
ideal
locals
largestack

;

o equ offset
b equ byte
w equ word
d equ dword
s equ short
n equ near
f equ far

;

include "..\pmode\pmode.inc"
include "..\include\macros.inc"
include "file.inc"

;

segment code32 page public use32
        assume cs:code32, ds:code32

;

align 4
filebufloc      dd 1 shl 30
filebuflen      dd 0 
inited          db 0

old_lomemtop    dd ?

;

align 32
proc    init_file n

        push    eax ebx
        cmp     [inited], 1
        je      @@done

        mov     eax, [_lomemtop]
        mov     ebx, eax

        sub     eax, 32768
        and     eax, not 15
        cmp     eax, [_lomembase]
        jb      @@err

        mov     [old_lomemtop], ebx

        mov     [filebufloc], eax
        mov     [filebuflen], 32768

@@done:
        pop     ebx eax
        clc
        ret

@@err:
        pop     eax
        stc
        ret

endp

;

align 32
proc    reset_file n

        cmp     [inited], 1
        jne     @@done

        push    eax
        mov     eax, [old_lomemtop]
        mov     [_lomemtop], eax

        mov     [filebuflen], 0
        pop     eax

@@done:
        ret

endp

;
;In:
;       edx: filename
;Out:
;       [v86r_bx]: file handle
;       cf=1: error

align 32
proc    openfile n

        push    eax edx

        add     edx, [_code32a]
        mov     eax, edx
        shr     edx, 4
        and     eax, 0fh
        mov     [v86r_dx], ax
        mov     [v86r_ds], dx
        mov     [v86r_ax], 3d02h

        mov     al, 21h
        int     33h

        mov     ax, [v86r_ax]
        mov     [v86r_bx], ax

        pop     edx eax
        ret

endp

;
;In:
;       [v86r_bx]: file handle
;Out:
;       cf=1: error

align 32
proc    closefile n

        push    eax
        mov     [v86r_ax], 3e00h
        mov     al,21h
        int     33h
        pop     eax
        ret

endp

;

align 32
proc    filesize n

        xor     eax, eax
        mov     [v86r_ax], 4201h
        mov     [v86r_cx], ax
        mov     [v86r_dx], ax
        mov     al, 21h
        int     33h

        push    [v86r_dx]
        push    [v86r_ax]

        xor     eax, eax
        mov     [v86r_ax], 4202h
        mov     [v86r_cx], ax
        mov     [v86r_dx], ax
        mov     al, 21h
        int     33h

        mov     ax, [v86r_dx]
        shl     eax, 16
        mov     ax, [v86r_ax]

        pop     [v86r_dx]
        pop     [v86r_cx]

        push    eax
        mov     [v86r_ax], 4200h
        mov     al, 21h
        int     33h
        pop     eax
        ret

endp

;

align 32
proc    readfile n

        pushad

        xor     ebp, ebp
        add     edx, [_code32a]
        lea     ebx, [ecx + edx]
        cmp     ebx, 100000h
        ja      @@read_himem

        mov     eax, edx
        shr     eax, 4
        and     edx, 0fh
        mov     [v86r_ds], ax
        mov     [v86r_dx], dx

@@read_lomem:
        mov     eax, 0fff0h
        cmp     eax, ecx
        jbe     @@long_lomem

        mov     eax, ecx

@@long_lomem:
        mov     [v86r_cx], ax
        mov     [v86r_ax], 3f00h
        mov     al, 21h
        int     33h
        jc      @@err

        xor     ebx, ebx
        mov     bx, [v86r_ax]
        add     ebp, ebx
        sub     ecx, ebx
        jbe     @@done

        test    ebx, ebx
        jz      @@done

        add     [v86r_ds], 0fffh
        jmp     @@read_lomem

@@read_himem:
        mov     edi, edx
        sub     edi, [_code32a]
        mov     edx, ecx
        mov     eax, [filebufloc]
        add     eax, [_code32a]
        mov     ebx, eax
        shr     eax, 4
        and     ebx, 0fh
        mov     [v86r_ds], ax
        mov     [v86r_dx], bx
        mov     ebx, [filebuflen]

@@himem_loop:
        mov     eax, ebx
        cmp     eax, edx
        jbe     @@long_himem

        mov     eax, edx

@@long_himem:
        mov     [v86r_cx], ax
        mov     [v86r_ax], 3f00h
        mov     al, 21h
        int     33h
        jc      @@err

        xor     ecx, ecx
        mov     cx, [v86r_ax]
        add     ebp, ecx
        mov     eax, ecx
        or      eax, eax
        jz      @@done

        mov     esi, [filebufloc]

        push    ecx
        shr     ecx, 2
        rep     movsd
        pop     ecx
        and     ecx, 3
        rep movsb

        sub     edx, eax
        ja      @@himem_loop

@@done:
        clc

@@err:
        mov     [esp + 28], ebp
        popad
        ret

endp

;

ends
end

