program Tutorial3; {to get the basics take a look at TUT1.PAS and TUT2.PAS}
{AnyObject Rotation Interactive
 Made by fh94.3 (C) 12/24/1995
 Mail: fh@viktoria.drp.fmph.uniba.sk

 Based on explanation by Synergist (rhr0982@grace.rit.edu).
}
uses tutunit,crt;

var xt,yt,zt:real; {temp points}
    ch:char; {for key you want to press}
    xan,yan,zan:real; {angles for axis X,Y,Z}
    sx,sy,sx1,sy1,p,zoom,p1: integer; {Screen coords X,Y}
    points,lines:byte; {nr. of points and lines of the object}
    obj: array[0..511] of real; {object to rotate (max 512 points}
    lobj: array[0..1023] of integer; {line index of object (max 1024}

procedure readdata; {reads the datafile}
var f:text;
begin
if ParamCount <> 1 then begin writeln('Usage: TUT3 datafile'); halt(0); end;
assign(F,Paramstr(1));
reset(F);
readln(F,points,lines);
p1:=0;
for p:=1 to points do begin readln(F,obj[p1],obj[p1+1],obj[p1+2]); p1:=p1+3; end;
{reads the coords of points 0 to points}
p1:=0;
for p:=1 to lines do begin readln(F,lobj[p1],lobj[p1+1]); p1:=p1+2; end;
{reads the index of lines 0 to lines}
close(F);
end;

procedure draw(color:byte); {procedure to draw a cube}
begin
 for p:=0 to lines-1 do begin {loops for all lines}
  sx:=round(zoom*obj[lobj[p*2]*3])+160; {x coord for point1}
  sy:=round(zoom*obj[lobj[p*2]*3+1])+100; {y coord for point1}
  sx1:=round(zoom*obj[lobj[p*2+1]*3])+160; {x coord for point2}
  sy1:=round(zoom*obj[lobj[p*2+1]*3+1])+100; {y coord for point2}
  drawline(SX,SY,sx1,sy1,color); {draw line between points 1&2 in current color}
 end;
end;

procedure calc; {calculates new values after rotate step}
begin
for p:=0 to points-1 do begin {repeats for all points}
Yt := obj[p*3+1] * COS(Xan) - obj[p*3+2] * SIN(Xan); {read old values from the table of coord,}
Zt := obj[p*3+1] * SIN(Xan) + obj[p*3+2] * COS(Xan); {rotating about x axis}
obj[p*3+1] := Yt; {writes the new values back to the table}
obj[p*3+2] := Zt;

Xt := obj[p*3] * COS(Yan) - obj[p*3+2] * SIN(Yan); {same as above, for Y axis}
Zt := obj[p*3] * SIN(Yan) + obj[p*3+2] * COS(Yan);
obj[p*3] := Xt;
obj[p*3+2] := Zt;

Xt := obj[p*3] * COS(Zan) - obj[p*3+1] * SIN(Zan); {about Z axis}
Yt := obj[p*3] * SIN(Zan) + obj[p*3+1] * COS(Zan);
obj[p*3] := Xt;
obj[p*3+1] := Yt;
end;
end;

begin
readdata;
Mcgaon;       {sets the 13h (320x200x256) mode}
Zan :=  0.0;  {rotation about Z axis by this angle}
Yan :=  0.0;  {rotation about Y axis by this angle}
Xan :=  0.0;  {rotation about X axis by this angle}
zoom:=30;     {size of the object}

{check;}
draw(15);     {draws the cube}
repeat        {loops ...}
 ch:=readkey;
 clearscreen;      {guess...:>}
  case ch of
   #72 : xan:=+0.05; {increases angle x}
   #75 : yan:=-0.05; {decreases angle y}
   'Z' : zan:=+0.05; {...}
   #80 : xan:=-0.05; {...}
   #77 : yan:=+0.05;
   'z' : zan:=-0.05;
   '+' : zoom:=zoom+5;
   '-' : zoom:=zoom-5;
  end;
calc;         {calculates the new coords}
draw(15);     {draws it again}
delay(30);    {wait a sec!}
until ch=#27; {... 'till you press ESC}
mcgaoff;      {jump back to text mode}
end.

