/*************************************************************************************************
*
*	Title:	WinCode 2
*
*	Desc:	Simple GDI Frame buffer
*	
*	Note:	1) this just displays a gradual black to white color change in the display
*			2) Now uses the Virtual Video interface
*			
**************************************************************************************************/

#include <Windows.h>
#include "GDI.h"
#include "VVideo.h"

/*************************************************************************************************/
// Defines
/*************************************************************************************************/

/*************************************************************************************************/
// Globals
/*************************************************************************************************/

HWND			g_hWnd;
HINSTANCE		g_hInstance;

/*************************************************************************************************/
// Module Data
/*************************************************************************************************/

// window placement
static int				m_WindowWidth;
static int				m_WindowHeight;
static int				m_WindowPosX;
static int				m_WindowPosY;

// class description
static char				*m_AppName	= "WinCode2";
static char				*m_AppTitle	= "WinCode2 Title";

// virtual page
static Color32_t		*m_VPage = NULL;

// fill color
static unsigned char	m_FillColor = 0;

/*************************************************************************************************/
// Functions
/*************************************************************************************************/

// windowing functions
static void Window_Destroy( void );
static HWND Window_Create( int PosX, int PosY, int Width, int Height);

// Update
static void UpdateFrame( void );

/*************************************************************************************************
*
*	Function:	WinMain();
*
*	Desc:		Execution entry point
*
*	Notes:		1) Think of this as main()
*
***************************************************************************************************/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	// save our instance
	g_hInstance = hInstance;

	// set the dimentions of out windows. these are the sizes on the desktop and in pixels
	m_WindowPosX = 0;
	m_WindowPosY = 0;
	m_WindowWidth = 320;
	m_WindowHeight = 240;

	// create a window
	g_hWnd = Window_Create( m_WindowPosX, m_WindowPosY, m_WindowWidth, m_WindowHeight );

	// did we successed
	if (g_hWnd != NULL)
	{
		// Init Virtual Video Page
		VV_Init();
		
		// select GDI Device
		VV_SetDriver( 0 );

		// get Virtaul Page address
		m_VPage = VV_GetAddress();
	
		// the main message loop
		do
		{
			// Windows shit
			if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			} 

			// Do our 1 frame of our effect
			UpdateFrame();

			// Flip the video page
			VV_Flip();

		} while(msg.message!=WM_QUIT);

		// the application is exiting

		// close Virtual Video Page
		VV_Kill();
	
		// close the window
		Window_Destroy();
	}

	// return value of our program
	return 0;
}

/*************************************************************************************************
*
*	Function:	WndProc()
*
*	Desc:		Our windows message loop
*
*	Notes:		1) This is message loop. we'll only process keyboard input here
*
***************************************************************************************************/
static long CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{

	// work out which message this is
	switch(msg)
	{
		// this is called when DestroyWindow() is called or when the User Closes the window
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
        
		// called when the user resizes the windows dimentions
		case WM_SIZE:
			break;
        
		// called when a key is pressed
		case WM_KEYDOWN:

			// which key was it
			switch( wParam )
			{
				// the Esc key
				case VK_ESCAPE:
					// we want to quit the application
					PostQuitMessage(0);
					break;
			}
			break;

		// called when the key is released
		case WM_KEYUP:
			break;
	}

	// let whoever else is interested in our messages process them
	return DefWindowProc(hWnd, msg, wParam, lParam);
}

/*************************************************************************************************
*
*	Function:	Window_Create()
*
*	Desc:		Creates a standard window at the position and dimentions specified
*
*	Notes:		1) Will return NULL if window creating failed
*
***************************************************************************************************/
static HWND Window_Create( int PosX, int PosY, int Width, int Height)
{
	WNDCLASS	wc;
	HWND		hWnd;

	// assume we fail
	hWnd = NULL;
	
	// create the Window Class for our window
	memset( &wc, 0, sizeof(wc) );
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = g_hInstance;
	wc.hIcon = NULL;
	wc.hCursor = NULL;
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = m_AppName;

	// attempt to create it
	if(RegisterClass( &wc ))
	{
		// class has been created now create a window with it
		hWnd = CreateWindow(	m_AppName, 
								m_AppTitle,
								WS_OVERLAPPEDWINDOW, 
								PosX, PosY,
								Width, Height,
								NULL,
								NULL,
								g_hInstance, 
								NULL);

		// did we succed in creating the window
		if (hWnd)
		{
			// show it to the world
			ShowWindow(hWnd, SW_SHOW);
			UpdateWindow(hWnd);
		}
	}

	return hWnd;
}

/*************************************************************************************************
*
*	Function:	Window_Destroy()
*
*	Desc:		Closes and cleans up our window
*
*	Notes:		1) this dosent do anything as we assume this is being called after the
*				WM_QUIT message has been passed and the window has already been
*				destroyed.
*
***************************************************************************************************/
static void Window_Destroy( void )
{
	/*
	I've put this here so we can abstract Window Creating/Destroying above
	the plain Win32 API. What we will do in the next tute is buildon this 
	frame work and extend this Window structure to GDI and DDraw
	*/
}


/*************************************************************************************************
*
*	Function:	UpdateFrame()
*
*	Desc:		Updates 1 frame of our frame buffer
*
*	Notes:		
*
***************************************************************************************************/
static void UpdateFrame( void )
{
	int i;

	for (i=0; i < 320*240; i++)
	{
		// fill with a constant color
		m_VPage[i].a = 0x00;
		m_VPage[i].r = m_FillColor;;
		m_VPage[i].g = 0;
		m_VPage[i].b = 0;
	}

	// move to the next shade of grey
	m_FillColor++;
}