;*****************************************************************************
; Filename: MEMMOVE.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.April.28
;  Updated: -
;*****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;*****************************************************************************
; Function: VOID @memmove(PVOID *dest,PVOID *src,ULONG length);
;  Comment: Moves a memory block and will always correctly copy even if
;           source and destination overlap.
;    Input: Eax - pointer to destination
;           Edx - pointer to source
;           Ecx - length to copy
;  Returns: pointer of detination (Eax)
;*****************************************************************************

        Include STDDEF.INC

        Codeseg                 ; Change memory model in the STDDEF.INC

Proc    memmove  ,3
                Push    Ebx,Eax
                jecxz   @@Exit01
                Cmp     Eax,Edx
                je      @@Exit01
                Ja      @@BackwardCopy
                Call    @memcpy
@@Exit01:       Pop     Eax,Ebx
                Ret

@@BackwardCopy:
                Add     Eax,Ecx             ; Do Backward copy
                Add     Edx,Ecx
                Jmp     @@Next01
        Align   4
@@Loop01:       Add     Edx,-16
                Add     Eax,-16
                Mov     Ebx,[Edx+12]                       ; Copy the first
                Mov     [Eax+12],Ebx                       ; large part
                Mov     Ebx,[Edx+8]
                Mov     [Eax+8],Ebx
                Mov     Ebx,[Edx+4]
                Mov     [Eax+4],Ebx
                Mov     Ebx,[Edx]
                Mov     [Eax],Ebx
@@Next01:       Sub     Ecx,16
                Jge     @@Loop01
                Add     Cl,16
                Jz      @@Exit02
                Sub     Cl,4
                Jb      @@Next02
                Add     Edx,-4
                Add     Eax,-4
                Mov     Ebx,[Edx]
                Mov     [Eax],Ebx
                Sub     Cl,4
                Jb      @@Next02
                Add     Edx,-4
                Add     Eax,-4
                Mov     Ebx,[Edx]
                Mov     [Eax],Ebx
                Sub     Cl,4
                Jb      @@Next02
                Add     Edx,-4
                Add     Eax,-4
                Mov     Ebx,[Edx]
                Mov     [Eax],Ebx
@@Next02:       Cmp     Cl,-4
                Je      @@Exit02
                Mov     Bl,[Edx-1]
                Mov     [Eax-1],Bl
                Cmp     Cl,-3
                Je      @@Exit02
                Mov     Bl,[Edx-2]
                Mov     [Eax-2],Bl
                Cmp     Cl,-2
                Je      @@Exit02
                Mov     Bl,[Edx-3]
                Mov     [Eax-3],Bl
@@Exit02:       Pop     Eax,Ebx
                Ret


Endp

        End

                Jmp     CopyTable


