;****************************************************************************
; Filename: FCLOSEAL.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.Aug.13
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int fcloseall(void);
;  Comment: Closes all opened file streams.
;    Input: Nothing.
;   Output: 0 if successful, otherwise EOF;
;****************************************************************************

        Include STDDEF.INC

Extrn _findiop          :Near
Extrn _opened_streams   :FILE

        Codeseg

Proc       fcloseall
        Push    Edi
        Clear   Edi
@@loop01:
        Test    [ Edi + _opened_streams._mode],10h
        Jz      Skip
        call    @fclose
        Cmp     Eax,EOF
        je      @@EOF
Skip:   Add     Edi, Size FILE
        Cmp     Edi,FOPEN_MAX * (Size FILE)
        jb      @@loop01
        Clear   Eax
@@EOF:  Pop    Edi
        Ret
Endp

        End

