
#ifndef  __MATH_H
#define  __MATH_H


#ifdef __cplusplus
extern "C" {
#endif
double   acos  (double __x);
double   asin  (double __x);
double   atan  (double __x);
double   atan2 (double __y, double __x);
double   ceil  (double __x);
double   cos   (double __x);
double   cosh  (double __x);
double   exp   (double __x);
double   fabs  (double __x);
double   floor (double __x);
double   fmod  (double __x, double __y);
double   frexp (double __x, int *__exponent);
double   ldexp (double __x, int __exponent);
double   log   (double __x);
double   log10 (double __x);
double   modf  (double __x, double *__ipart);
double   pow   (double __x, double __y);
double   sin   (double __x);
double   sinh  (double __x);
double   sqrt  (double __x);
double   tan   (double __x);
double   tanh  (double __x);


/* Constants rounded for 21 decimals. */
#define M_E         2.71828182845904523536
#define M_LOG2E     1.44269504088896340736
#define M_LOG10E    0.434294481903251827651
#define M_LN2       0.693147180559945309417
#define M_LN10      2.30258509299404568402
#define M_PI        3.14159265358979323846
#define M_PI_2      1.57079632679489661923
#define M_PI_4      0.785398163397448309616
#define M_1_PI      0.318309886183790671538
#define M_2_PI      0.636619772367581343076
#define M_1_SQRTPI  0.564189583547756286948
#define M_2_SQRTPI  1.12837916709551257390
#define M_SQRT2     1.41421356237309504880
#define M_SQRT_2    0.707106781186547524401



typedef enum
{
    DOMAIN = 1,    /* argument domain error -- log (-1)        */
    SING,          /* argument singularity  -- pow (0,-2))     */
    OVERFLOW,      /* overflow range error  -- exp (1000)      */
    UNDERFLOW,     /* underflow range error -- exp (-1000)     */
    TLOSS,         /* total loss of significance -- sin(10e70) */
    PLOSS,         /* partial loss of signif. -- not used      */
    STACKFAULT     /* floating point unit stack overflow       */
}   _mexcep;


#ifdef __cplusplus
 }
#endif


struct  exception
{
    int type;
    char   *name;
    double  arg1, arg2, retval;
};


int     matherr (struct exception *__e);



#endif
