;****************************************************************************
; Filename: MAXAVAIL.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.12.25
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: ULONG maxavail(VOID);
;    Input: nothing
;   Output: largest free block on the heap.
;  Comment: PALmaxavail returns the size of the largest free block on the heap.
;           OBSERVE: This has nothing to do with how much memory your system
;           has available.
;****************************************************************************

        Include STDDEF.INC
        Include "MEMORY.INC"

        Codeseg

Proc    maxavail
                Mov     Edx,Offset BlockTableEnd-Size FreeBlock                 ; Get the last block list pointer
                Clear   Eax                                                     ; Clear the largest available variable
                Push    Ebx
        Align   4
@@Loop01:       Mov     Ebx,[Edx+FreeBlock.NextFree]                            ; Get next available FreeBlock
        Align   4
@@Loop02:       Mov     Ecx,[Ebx+FreeBlock.BlockSize]                           ; Get the block size
                Jecxz   @@Next01                                                ; If it's zero, exit
                Cmp     Eax,Ecx                                                 ; Compare the size
                Mov     Ebx,[Ebx+FreeBlock.NextFree]                            ; Get the next memory block
                Jae     @@Loop02
                Mov     Eax,Ecx                                                 ; Get larger block size
                Jmp     @@Loop02
        Align   4
@@Next01:       TestZ   Eax                                                     ; If it isn't zero then exit
                Jnz     @@Exit01
                Sub     Edx,Size FreeBlock                                      ; Get next block size
                Cmp     Edx,Offset BlockTable                                   ; If it's above the first block then do another lap
                Jae     @@Loop01
                Pop     Ebx
                Clear   Eax                                                     ; Return with no memory available (0)
                Ret
        Align   4
@@Exit01:       Pop     Ebx
                Sub     Eax,Size AllocBlock                                     ; Return with the largest block available
                Ret
Endp

        End
