comment ~
****************************************************************************
DLLTEST.ASM
                A basic example of using a DOS32 Loadable Library

Notes: As explained in the DOS32 documentaion, the use of the Library's
global public symbol can be used in many differnet ways for the
application to interfacing to/from the dynamic library. This example program
will load the library file named A_DLL.DLL which contains a single
two functions. The public in A_DLL.DLL will point to two pointer that
refrence these two functions. See A_DLL.ASM (source of A_DLL.DLL).


to compile:

 tasm dlltest
 dlink dlltest

****************************************************************************
~
.386
.model flat ,C
.stack
.code

; varibles holding pointers to each function in A_DLL.DLL
;
print_string    dd ?
wait_for_key    dd ?


message_1 db 'This message was printed from a procedure',13,10
          db 'in the loadable library, A_DLL.DLL',13,10,36
message_2 db 'press any key...',13,10,36


dll_FileName db 'a_dll.dll',0

start:

  ;
  ; Function EE10h to setup a DOS32 Dynamic Linkable Library file.
  ;
  ; Expects CS:EDX -> pointing to file name.
  ;            EBX = seek position from beginning of file.
  ;
  ;
    mov  ax,0EE10h
    mov  edx, Offset dll_FileName
    mov  ebx,0
    int  31h
    jnc  Ok
    cmp  al,1                   ; if carry set then get error code from AL
    je   error1                 ; 1 = file not found
    cmp  al,2                   ; 2 = bad format
    je   error2
Ok:

  ; Returns EAX with number of bytes required to load the library.
  ;         EBX = DLL file size


  ;
  ; Allocate memory for the loadable program.
  ;
    mov edx,eax
    mov ax,0EE42h
    int 31h
    jc error


  ;
  ; Load the DLL
  ;
  ;      Expects CS:EDX -> pointing to memory block to holding
  ;                         the DLL program.
  ;
    mov  ax,0EE11h
    int  31h
    jc error1

    ;
    ; Returns CS:EDX -> pointing to the DLL public symbol.
    ;
    ; TEST.DLL is written so that the public symbol ('DOS32_DLL') points
    ; to an array of pointers to each procedure.
    ;

    mov     eax,[edx]             ; get first function pointer
    mov     [print_string],eax
    mov     eax,[edx+4]           ; get second function pointer
    mov     [wait_for_key],eax


   ; Use these two functions
   ;

    mov     edx,Offset message_1
    call    print_string

    mov     edx,Offset message_2
    call    print_string

    call    wait_for_key


exit:
    mov ax,4c00h
    int 21h


;---------------------------------------------------------------------
error:
    mov edx, offset error_mesg
    mov ah,9
    int 21h
    jmp exit
error_mesg db 'mot enough memory to load DLL',13,10,36

;---------------------------------------------------------------------
error1:
    mov edx, offset error1_mesg
    mov ah,9
    int 21h
    jmp exit
error1_mesg db 'Error opening loadable library, TEST.DLL',13,10,36

;-------------------------------------------------------------------
error2:
    mov edx, offset error2_mesg
    mov ah,9
    int 21h
    jmp exit
error2_mesg db 'Bad DOS32 Lodabale Library format',13,10,36


end start