; ***************************************************************************
; * Stubloader                                                              *
; *                                                                         *
; * loads Pharlap REX files linked as overlays with wlink                   *
; ***************************************************************************
.386p

public start32                                      ; Public startingpoint

extrn rex_getinfo:near                              ; misc loading code
extrn rex_start:near                                ; starting overlay
extrn install_ext21:near                            ; installing extended
                                                    ; int21h functions

extrn stubsize:dword

CODE32 segment public use32 'code'
assume cs:code32,ds:code32

 start32:                                          ; Startingpoint
  call install_ext21                               ; Adding extended int21h func

  mov edx,offset starttext
  mov ah,9
  int 21h                                          ; Startup message

  mov ax,0ee02h
  int 31h
  mov exename,ecx                                  ; Getting name of itself

  mov edx,exename
  mov ax,3d00h
  mov ecx,0
  int 21h                                          ; Open itself

  mov exenum,ax                                    ; store filehandle

  mov bx,exenum
  mov edx,0
  mov ax,4200h
  int 21h                                          ; search to 0
  
  mov edx,offset mz_header
  mov ecx,6
  mov ah,3fh
  mov bx,exenum
  int 21h                                          ; load in MZ header to get
                                                   ; stubsize

  mov ax,4202h
  mov bx,exenum
  mov edx,0
  int 21h                                          ; get total lenght of file

  mov edx,eax
  mov realtotal,eax

  movzx eax,mz_header+4
  movzx ebx,mz_header+2
  dec eax
  shl eax,9
  add eax,ebx                                      ; Calculate stubsize
  cmp eax,edx                                      
  je error_nostub                                  ; if stubsize=total size
                                                   ; then no overlay,exit
  mov rexoffset,eax

  pushad
   mov ax,4200h
   mov bx,exenum
   mov edx,rexoffset
   int 21h                                         ; Search to start of overlay
  popad

  mov ah,3fh
  mov ecx,01eh
  mov edx,offset rexheader
  mov bx,exenum
  int 21h                                          ; Load REX header

  cmp word ptr[rexheader],'QM'                     ; Right kind of stub?
  jne error_errstub                                ; nope, exit
                                                   ; yes , continue

  movzx edx,word ptr[rexheader+8]
  shl edx,4
  mov rexsize,edx                                  ; get size of header

  pushad
    movzx ebx,word ptr[rexheader+4]
    dec ebx
    shl ebx,9
    movzx eax,word ptr[rexheader+2]                ; Recalc headersize
    add eax,ebx                                    ; (to prevent crash if
    sub eax,realtotal                              ;  the exec is packed)
    add eax,rexoffset
    mov stubsize,eax                               
  popad

  sub edx,stubsize
  mov rexsize,edx

  ; edx=size of stub
  pushad
   mov ax,4200h
   mov bx,exenum
   mov edx,rexoffset                               ; Search to start
   int 21h                                         ; of overlay again
  popad

  push edx
   mov ax,0ee42h
   int 31h                                         ; Allocate mem for header
  pop ecx
  ; ecx=size of stub
  ; edx=pointer to allocated memory

  push edx
   mov ah,3fh
   mov bx,exenum
   int 21h                                         ; Read header
  pop esi

  call rex_getinfo                                 ; Do misc stuff
  ; Return:
  ;  ecx=bytes to load
  ;  edi=destination for data

  mov edx,edi
  pushad
   mov ax,4200h
   mov bx,exenum
   mov edx,rexoffset
   add edx,rexsize
   int 21h                                         ; Seek to data
  popad
  mov ah,3fh
  mov bx,exenum
  int 21h                                          ; Load execdata

  mov ah,3eh
  mov bx,exenum
  int 21h                                          ; Close file

  call rex_start                                   ; Start overlay

error_nostub:                                      ; Error, nostub
  mov edx,offset error_nostub_string
  jmp err_exit
 
error_errstub:                                     ; Error, wrong stub
  mov edx,offset error_errstub_string
  jmp err_exit

err_exit:                                          ; Common exit
  mov ah,9
  int 21h

  mov ah,3eh
  mov bx,exenum
  int 21h

  mov ax,4c01h
  int 21h


error_nostub_string db 'Error: no overlay$'
error_errstub_string db 'Error: overlay is not a REX file$'

starttext db 'WexT Watcom stubloader v1.0',13,10,'$'

exename   dd 0

exenum    dw 0

mz_header dw 0,0,0

rexoffset dd 0
rexsize   dd 0

realtotal dd 0

rexheader db 01eh dup (0)

CODE32 ends
end
