; sys.asm
; part of the woorlic Truecolor lib

; ******************** If system defined as dos32 *************************
ifdef DOS32                       ; dos32 specific code

sys_temp dd 0

rm_registers:             ; Label
rm_edi         dd 0
rm_esi         dd 0
rm_ebp         dd 0
rm_res1        dd 0
rm_ebx         dd 0
rm_edx         dd 0
rm_ecx         dd 0
rm_eax         dd 0
rm_flags       dw 0
rm_es          dw 0
rm_ds          dw 0
rm_fs          dw 0
rm_gs          dw 0
rm_ip          dw 0
rm_cs          dw 0
rm_sp          dw 0
rm_ss          dw 0

sys_ls dd 0
sys_rm dd 0

; Called at start of lib
i_init:
 pushad
  mov ax,0ee02h
  int 31h
  neg ebx
  mov sys_ls,ebx
  movzx eax,ax
  mov sys_rm,eax
 popad
ret

; in:
;  x
; out:
;  eax=linear start
i_getls:
 mov eax,sys_ls
ret

; in:
;  x
; out:
;  eax=Segment for Realmode memory
i_getrm:                          ; Get realmode buffer
 mov eax,sys_rm
ret


; in:
;  eax=intnum
; out:
;  x
i_callrm:
 pushad
  mov ecx,0
  movzx ebx,al
  mov ax,0300h
  mov edi,offset rm_registers
  int 31h
 popad
ret

; in:
;  eax=amount of mem
; out:
;  eax=ptr to mem
i_alloc:
 pushad
  mov edx,eax
  mov ax,0ee42h
  int 31h
  mov sys_temp,edx
 popad
 mov eax,sys_temp
ret

; in:
;  eax=memory block to free
; out:
;  x
i_free:
 pushad
  mov ax,0ee40h
  int 31h
 popad
ret

; in:
;  x
; out:
;  eax=0 if no key
i_poll_key:
 pushad
  mov ah,1
  int 16h
  jnz i_poll_key_ok
   mov al,0
  i_poll_key_ok:
  movzx eax,al
  mov sys_temp,eax
 popad
 mov eax,sys_temp
ret

; in:
;  x
; out:
;  eax=key
i_get_key:
 pushad
  mov ah,0
  int 16h
  movzx eax,al
  mov sys_temp,eax
 popad
 mov eax,sys_temp
ret

; in:
;  esi=area to map
;  ecx=size to map
; out:
;  eax=mapped area
i_mapmem:                         ; map memory
 pushad
  xchg esi,ecx
  mov ebx,ecx
  shr ebx,16                       ; high part in bx, low in cx
  mov edi,esi
  shr esi,16                       ; high part in si, low in di
  mov ax,0800h                     ; dpmi func 800h, map memory
  int 31h                          ; actual call
  mov ax,bx
  shl eax,16
  mov ax,cx                        ; eax=ptr to mapped area
  mov sys_temp,eax
 popad
 mov eax,sys_temp
ret
; ******************** If system defined as dos32 *************************
endif

ifdef WATCOM
; ******************** If system defined as watcom *************************

sys_temp dd 0

rm_registers:             ; Label
rm_edi         dd 0
rm_esi         dd 0
rm_ebp         dd 0
rm_res1        dd 0
rm_ebx         dd 0
rm_edx         dd 0
rm_ecx         dd 0
rm_eax         dd 0
rm_flags       dw 0
rm_es          dw 0
rm_ds          dw 0
rm_fs          dw 0
rm_gs          dw 0
rm_ip          dw 0
rm_cs          dw 0
rm_sp          dw 0
rm_ss          dw 0

sys_ls dd 0
sys_rm dd 0


; in:
;  esi=area to map
;  ecx=size to map
; out:
;  eax=mapped area
i_mapmem:                         ; map memory
 pushad
  xchg esi,ecx
  mov ebx,ecx
  shr ebx,16                       ; high part in bx, low in cx
  mov edi,esi
  shr esi,16                       ; high part in si, low in di
  mov ax,0800h                     ; dpmi func 800h, map memory
  int 31h                          ; actual call
  mov ax,bx
  shl eax,16
  mov ax,cx                        ; eax=ptr to mapped area
  mov sys_temp,eax
 popad
 mov eax,sys_temp
ret

; in:
;  x
; out:
;  eax=0 if no key
i_poll_key:
 pushad
  mov ah,1
  int 16h
  jnz i_poll_key_ok
   mov al,0
  i_poll_key_ok:
  movzx eax,al
  mov sys_temp,eax
 popad
 mov eax,sys_temp
ret

; in:
;  x
; out:
;  eax=key
i_get_key:
 pushad
  mov ah,0
  int 16h
  movzx eax,al
  mov sys_temp,eax
 popad
 mov eax,sys_temp
ret

; Called at start of lib
i_init:
 pushad
  mov ax,100h
  mov bx,64
  int 31h
  movzx eax,ax
  mov sys_rm,eax
  mov sys_ls,0
 popad
ret

; in:
;  x
; out:
;  eax=linear start
i_getls:
 mov eax,sys_ls
ret

; in:
;  x
; out:
;  eax=Segment for Realmode memory
i_getrm:                          ; Get realmode buffer
 mov eax,sys_rm
ret

; in:
;  eax=intnum
; out:
;  x
i_callrm:
 pushad
  mov ecx,0
  movzx ebx,al
  mov ax,0300h
  mov edi,offset rm_registers
  int 31h
 popad
ret

; extrn malloc_
; in:
;  eax=amount of mem
; out:
;  eax=ptr to mem
i_alloc:
 pushad
  mov ebx,eax
  mov ecx,eax
  shr ebx,16

  mov eax,501h
  int 31h
;  push eax
;  call malloc_
;  add esp,4
  mov ax,bx
  shl eax,16
  mov ax,cx

  mov sys_temp,eax
 popad
 mov eax,sys_temp
ret

; in:
;  eax=memory block to free
; out:
;  x
i_free:
 pushad
  mov di,ax
  shr eax,16
  mov si,ax
  mov ax,0502h
  int 31h
 popad
ret


; ******************** If system defined as watcom *************************
endif
