.386p
.model flat
.stack 1234h

include tclib.inc
.data

start_string db 'Woorlic Truecolor Assembly example',13,10,'$'

result_string db 'Number of ticks(18.2hz) spent on copying 200 screens',13,10
              db 'from Buffer to Screen - $'

tt dd 0

.code
start:
 mov edx,offset start_string
 call string                     ; Print starting string

 call init_tc                    ; Init the Truecolor lib
                                 ; This is where you select the mode

 call start_tc                   ; Go into the first working mode

 mov edi,tcono                   ; Clearing screen by filling with 0
 mov ecx,64000
 mov eax,0ffffffffh
 rep stosd                       

 mov edi,tcono                   ; Write the shade test
 mov eax,0ff0000h
 mov ebx, 200
l2:
 mov ecx,256
l:
  mov al,cl
  mov ah,bl
  stosd
 loop l
  add edi,64*4
 dec ebx
 jnz l2


 call get_tick                   ; Get start time

 mov ebx,eax                     ; Do 200 copy2screen
 mov ecx,200
cp:
  call blit_tc
 loop cp

 call get_tick                   ; Get end time

 sub eax,ebx                     ; Calculate lenght of time
 mov tt,eax

 mov ax,0                        ; Wait for keypress
 int 16h

 call kill_tc                    ; Shutdown Truecolor lib

 mov ax,3h                       ; Goto text mode
 int 10h

 mov edx,offset result_string   
 call string                     ; Print results text

 mov eax,tt                      ; Load lenght of time again
 call decp                       ; Print it

 mov ax,4c00h                    ; Terminate
 int 21h

; Get_tick , procedure to get the current tick
get_tick:
 pushad
  mov ax,0ee02h
  int 31h
  neg ebx
  add ebx,046ch
  movzx eax,word ptr[ebx]
  mov tt,eax
 popad
 mov eax,tt
ret

include misc.asm

end start
