(*
 * WATER.PAS
 *
 * Written by Bayger, 1997.
 * Ten plik jest zacznikiem do artikla pt "EFEKT KAUY".
 *
 * Plik zawiera procki skadajce si na efekt kauy lub jak kto woli
 * wody. Przy okazji chc podkreli, e kod jest cakowicie
 * niezoptymalizowany, gdy utraciby swoj przejrzysto. Oczywicie
 * jeli kto chce tego uywa we wasnych produkcjach to bardzo prosz,
 * ale pomijajc fakt lamerskiego zachowania (przepisanie procek) to
 * nie wr takiemu osobnikowi wielkich owacji z powodu szybkoci
 * tego kodu. No ale, rbta co chceta! To wszystko jest PUBLIC DOMAIN.
 *
 * update [6-08-98]: jizzu, ale to jest cholernie wolne... ale tak,
 * eby was podenerwowa to pod pmode'm zrobilem ten efekt - tyle ze
 * dziala o wiele, wiele, wiele szybciej (na moim p200 wyrabia sie w
 * JEDNYM frejmie i ma jeszcze niezly zapas, bo 1/3 klatki!, ofcoz
 * efekt fullscreen 320x200)
 *)

program Water;
uses Crt;

(*
 * TYPY:
 *)

type
(* definicja koloru RGB *)
  TColor = record
    R,G,B : byte;
  end;

(* def. penej palety kolorw *)
  TVgaPalette = array [0..255] of TColor;

(* def. ekranu 320x200x8b *)
  PVgaBuffer = ^TVgaBuffer;
  TVgaBuffer = array [0..199,0..319] of byte;

(* def. paszczyzny wody *)
  PWaterBuffer = ^TWaterBuffer;
  TWaterBuffer = array [0..199,0..319] of shortint;


(*
 * STAE I ZMIENNE GLOBALNE:
 *)

const
(* rozmiary efektu (jeli bardzo wolno dziaa to sprbuj go zmniejszy) *)
  MAX_X = 320;
  MAX_Y = 200;
(* ilo rzucanych w czasie jednego cyklu kropel *)
  NUMBER_DROPS = 2;
(* moc pojedynczej kropli *)
  DROP_POWER = 127;

var
  Curr, Prev : PWaterBuffer;            { tablice wysokoci }
  Texture : TVgaBuffer;                 { tekstura ta (powierzchni) }
  Screen : TVgaBuffer absolute $a000:0; { bufor VGA }

(*
 * PROCEDURY I FUNKCJE POMOCNICZE:
 *)

(*
 * SwapWaterBuffers
 * Zamienia miejscami wskaniki do TVgaBuffer
 *
 * PtrA,PtrB - wskaniki
 *)

procedure SwapWaterBuffers(var PtrA:PWaterBuffer;var PtrB:PWaterBuffer);
var
  tmptr : pointer;
begin
  tmptr := PtrA;
  PtrA := PtrB;
  PtrB := tmptr;
end;

(*
 * SetVMode
 * Ustawia zadany tryb video
 *
 * VMode - numer trybu
 *)

procedure SetVMode(VMode:word); assembler;
asm
  mov ax,VMode
  int 10h
end;

(*
 * GrayScale
 * Ustawia palet kolorw VGA na skal szaroci (od ciemnego do jasnego)
 *)

procedure GrayScale; assembler;
asm
  mov dx,3c8h
  xor al,al
  out dx,al
  inc dx
@@1:
  mov cx,12
@@2:
  out dx,al
  loop @@2
  inc al
  cmp al,40h
  jne @@1
end;


(*
 * PROCEDURY I FUNKCJE DOTYCZCE EFEKTU:
 *)

(*
 * InitWater
 * Alokuje pami na tablice wysokoci (inicjuje zerami)
 * i ekran wirtualny oraz tekstur.
 *)

procedure InitWater;
var
  txtr : file;
begin
  New(Curr);
  FillChar(Curr^,SizeOf(TVgaBuffer),0);
  New(Prev);
  FillChar(Prev^,SizeOf(TVgaBuffer),0);
  Assign(txtr,'TEXTURE.RAW');
  Reset(txtr,1);
  BlockRead(txtr,Texture,SizeOf(Texture));
  Close(txtr);
  SetVMode($13);
  GrayScale;
end;

(*
 * DoneWater
 * Dealokuje przydzielon efektowi pami
 *)

procedure DoneWater;
begin
  Dispose(Curr);
  Dispose(Prev);
  SetVMode($03);
end;

(*
 * Drops
 * Po prostu rzuca kilka kropelek (na klatk)
 *)

procedure Drops;
var
  n,x,y : word;
begin
  for n := 1 to NUMBER_DROPS do
  begin
    y := Random(MAX_Y);
    x := Random(MAX_X);
    curr^[y,x-1] := DROP_POWER div 2;
    curr^[y,x+1] := DROP_POWER div 2;
    curr^[y-1,x] := DROP_POWER div 2;
    curr^[y+1,x] := DROP_POWER div 2;
    curr^[y,x] := DROP_POWER;
  end;
end;

(*
 * Watering
 * Oblicza 1 klatk efektu kauy.
 *)

procedure Watering;
var
  x,y : word;
  pix : integer;
begin
  for y := 1 to MAX_Y-2 do
    for x := 1 to MAX_X-2 do
    begin
      pix := (prev^[y-1,x-1]+prev^[y-1,x]+prev^[y-1,x+1]+
              prev^[y,  x-1]+             prev^[y,  x+1]+
              prev^[y+1,x-1]+prev^[y+1,x]+prev^[y+1,x+1]-
              curr^[y,x] shl 2) shr 2;
      curr^[y,x] := pix - (pix shr 4);
    end;
end;

(*
 * ShowWater
 * Generuje obraz kauy na podstawie tablicy wysokoci (Curr^).
 *)

procedure ShowWater;
var
  x,y,pix : integer;
  u,v : integer;
begin
  for y := 1 to MAX_Y-2 do
    for x := 1 to MAX_X-2 do
    begin
      u := (curr^[y,x+1]-curr^[y,x-1]) div 2;   {u,v - wektory pseudonormalne}
      v := (curr^[y+1,x]-curr^[y-1,x]) div 2;
      pix := Texture[y+v,x+u] + u + v;
      if (pix < 256) and (pix >= 0) then Screen[y,x] := pix
      else if pix > 255 then Screen[y,x] := 255
      else Screen[y,x] := 0;
    end;
end;

(*
 * ENTRY POINT:
 *)

begin
  InitWater;
  repeat
    Drops;
    Watering;
    ShowWater;
    SwapWaterBuffers(curr,prev);
  until Keypressed;
  DoneWater;
end.