Unit AF_ISADM;     { Network Administrator }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
 5|     Years of internetwork administration experience : [...]
 6|        Can you provide hosting for your own servers : [.]
 7|      Available bandwidth, diskspace, CPU power, etc : [......................]
 8|                                                       [......................]
 9|        OS and network enviroments you specialize in : [......................]
10|                                                       [......................]
11| Internet services you can provide (dns, ftp, other) : [......................]
12|
13|Please list any relevant technical certifications you have :
14|[.............................................................................]
15|
16|Please list any servers you are currently hosting or administrating :
17|[.............................................................................]
18|
19|Additional Comments :
20|[.............................................................................]
21|[.............................................................................]
22|[.............................................................................]
23|[.............................................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE  FormType = RECORD
                Years      : PictureIOOBJ;
                Hosting    : PictureIOOBJ;
                System1    : LateralIOOBJ;
                System2    : LateralIOOBJ;
                OS_Network1: LateralIOOBJ;
                OS_Network2: LateralIOOBJ;
                Services   : LateralIOOBJ;
                TechCertif : LateralIOOBJ;
                Servers    : LateralIOOBJ;
                Comments1  : LateralIOOBJ;
                Comments2  : LateralIOOBJ;
                Comments3  : LateralIOOBJ;
                Comments4  : LateralIOOBJ;
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_ADM.OBJ}
PROCEDURE APP_ADM; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_ADM, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Years);
     AddItem(Form^.Hosting);
     AddItem(Form^.System1);
     AddItem(Form^.System2);
     AddItem(Form^.OS_Network1);
     AddItem(Form^.OS_Network2);
     AddItem(Form^.Services);
     AddItem(Form^.TechCertif);
     AddItem(Form^.Servers);
     AddItem(Form^.Comments1);
     AddItem(Form^.Comments2);
     AddItem(Form^.Comments3);
     AddItem(Form^.Comments4);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_ADM^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,-----------------------------.');
    Writeln(Out, ',-'' Internetwork Administrator  `------------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Years of adminiatration    : ', Years.GetValue);
    Writeln(Out, 'Can you provide hosting?   : ', Hosting.GetValue);
    Writeln(Out, 'Available bandwidth, Diskspace, CPU power?        : ', System1.GetValue);
    Writeln(Out, '                                                  : ', System2.GetValue);
    Writeln(Out, 'OS and network environments you specialize in?    : ', OS_Network1.GetValue);
    Writeln(Out, '                                                  : ', OS_Network2.GetValue);
    Writeln(Out, 'Internet services you can provide?                : ', Services.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Relevant technical certifications you have:');
    Writeln(Out, TechCertif.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Servers you are currently hosting or administrating?:');
    Writeln(Out, Servers.GetValue);
    WRiteln(Out, '');
    Writeln(Out, 'Additional Comments:');
    Writeln(Out, Comments1.GetValue);
    Writeln(Out, Comments2.GetValue);
    Writeln(Out, Comments3.GetValue);
    Writeln(Out, Comments4.GetValue);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Years.Done;
     Hosting.Done;
     System1.Done;
     System2.Done;
     OS_Network1.Done;
     OS_Network2.Done;
     Services.Done;
     TechCertif.Done;
     Servers.Done;
     Comments1.Done;
     Comments2.Done;
     Comments3.Done;
     Comments4.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Years.Init(57, 5, '###');
     Years.SetPadChar('.');

     Hosting.Init(57, 6, '!');
     Hosting.SetAllowChar('ynYN');
     Hosting.SetPadChar('.');
     Hosting.SetValue('N');

     System1.Init(57, 7, 22, 50);
     System1.SetPadChar('.');

     System2.Init(57, 8, 22, 50);
     System2.SetPadChar('.');

     OS_Network1.Init(57, 9, 22, 50);
     OS_Network1.SetPadChar('.');

     OS_Network2.Init(57, 10, 22, 50);
     OS_Network2.SetPadChar('.');

     Services.Init(57, 11, 22, 50);
     Services.SetPadChar('.');

     TechCertif.Init(2, 14, 77, 77);
     TechCertif.SetPadChar('.');

     Servers.Init(2, 17, 77, 77);
     Servers.SetPadChar('.');

     Comments1.Init(2, 20, 77, 77);
     Comments1.SetPadChar('.');

     Comments2.Init(2, 21, 77, 77);
     Comments2.SetPadChar('.');

     Comments3.Init(2, 22, 77, 77);
     Comments3.SetPadChar('.');

     Comments4.Init(2, 23, 77, 77);
     Comments4.SetPadChar('.');
  END;
END.
