Unit AF_ESSAY;     { Essay }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE  FormType = RECORD
                Essay      : WWArrayIOOBJ;
                EssayList  : ARRAY [1..15] OF String[78];
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;

{$L APP_ESSAY.OBJ}
PROCEDURE APP_ESSAY; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      PgDnKey,
      PgUpKey,
      F10Key,
      EscKey      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);
  EscKey.Init     (KEY_Esc,     Escaped);

  { Show Form Screen }
  SlideForm(@APP_ESSAY, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);

     AddItem(EscKey); { Aparently special requirement for WWArrayIOOBJ }
     { Input items }
     AddItem(Form^.Essay);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;
  EscKey.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_ESSAY^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
VAR I : Integer;
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,-----------------.');
    Writeln(Out, ',-'' Essay Section   `-------------------------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    FOR I := 1 TO 15 DO
      IF EssayList[I] <> '' THEN Writeln(Out, EssayList[I]);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Essay.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Essay.Init(2, 8, 78, 15, '');
     Essay.AssignList(EssayList, 15, 78);
     Essay.WrapFull;
  END;
END.
