Unit AF_3D;     { 3D Artist information }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
 5|                           Years designing 3D models : [...]
 6|                 Number of models produced (approx.) : [....]
 7|  How much time does it take you to complete a model : [......................]
 8|  How many models can you produce per month for ACiD : [....]
 9|                          Favorite rendering program : [......................]
10|                        Preferred modeling technique
11|             (nurbs, spline/patch, polygonal, other) : [......................]
12|
13|What are you best at (organic, architectural, mechanical, other) :
14|[.............................................................................]
15|
16|Favorite 3D Artists :
17|[.............................................................................]
18|
19|Additional Comments :
20|[.............................................................................]
21|[.............................................................................]
22|[.............................................................................]
23|[.............................................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE  FormType = RECORD
                Years      : PictureIOOBJ;
                TotModels  : PictureIOOBJ;
                Time       : LateralIOOBJ;
                MonthModel : PictureIOOBJ;
                Renderer   : LateralIOOBJ;
                FavTech    : LateralIOOBJ;
                BestAt     : LateralIOOBJ;
                FavArtists : LateralIOOBJ;
                Comments1  : LateralIOOBJ;
                Comments2  : LateralIOOBJ;
                Comments3  : LateralIOOBJ;
                Comments4  : LateralIOOBJ;
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_3D.OBJ}
PROCEDURE APP_3D; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_3D, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Years);
     AddItem(Form^.TotModels);
     AddItem(Form^.Time);
     AddItem(Form^.MonthModel);
     AddItem(Form^.Renderer);
     AddItem(Form^.FavTech);
     AddItem(Form^.BestAt);
     AddItem(Form^.FavArtists);
     AddItem(Form^.Comments1);
     AddItem(Form^.Comments2);
     AddItem(Form^.Comments3);
     AddItem(Form^.Comments4);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_3D^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,---------------.');
    Writeln(Out, ',-'' 3D Artist     `---------------------------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Years designing 3D models  : ', Years.GetValue);
    Writeln(Out, 'Number of models produced  : ', TotModels.GetValue);
    Writeln(Out, 'How much time does it take to complete one model? : ', Time.GetValue);
    Writeln(Out, 'How many models can you produce in one month?     : ', MonthModel.GetValue);
    Writeln(Out, 'What are your favorite rendering program?         : ', Renderer.GetValue);
    Writeln(Out, 'Preferred modeling technique?                     : ', FavTech.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What are you best at (Organic, architectural, mechanical, other):');
    Writeln(Out, BestAt.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Who are your favorite 3D Artists?:');
    Writeln(Out, FavArtists.GetValue);
    WRiteln(Out, '');
    Writeln(Out, 'Additional Comments:');
    Writeln(Out, Comments1.GetValue);
    Writeln(Out, Comments2.GetValue);
    Writeln(Out, Comments3.GetValue);
    Writeln(Out, Comments4.GetValue);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Years.Done;
     TotModels.Done;
     Time.Done;
     MonthModel.Done;
     Renderer.Done;
     FavTech.Done;
     BestAt.Done;
     FavArtists.Done;
     Comments1.Done;
     Comments2.Done;
     Comments3.Done;
     Comments4.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Years.Init(57, 5, '###');
     Years.SetPadChar('.');

     TotModels.Init(57, 6, '####');
     TotModels.SetPadChar('.');

     Time.Init(57, 7, 22, 50);
     Time.SetPadChar('.');

     MonthModel.Init(57, 8, '####');
     MonthModel.SetPadChar('.');

     Renderer.Init(57, 9, 22, 50);
     Renderer.SetPadChar('.');

     FavTech.Init(57, 11, 22, 50);
     FavTech.SetPadChar('.');

     BestAt.Init(2, 14, 77, 77);
     BestAt.SetPadChar('.');

     FavArtists.Init(2, 17, 77, 77);
     FavArtists.SetPadChar('.');

     Comments1.Init(2, 20, 77, 77);
     Comments1.SetPadChar('.');

     Comments2.Init(2, 21, 77, 77);
     Comments2.SetPadChar('.');

     Comments3.Init(2, 22, 77, 77);
     Comments3.SetPadChar('.');

     Comments4.Init(2, 23, 77, 77);
     Comments4.SetPadChar('.');
  END;
END.
