{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,P-,Q+,R+,S+,T-,V-,X+,Y+}
{$M 8192,78096,78096}
                                                                                (*
  
     ACiDApp  Coding by Jazz and The Hit Man of ACiD Productions(tm)    
        Created for the ACiD Aquisition Packs - December 5th, 1995       
    Source Commented for ACiD Senior Staff only!  Do not release Source! 
               Copyright 1994-1995 to ACiD Productions (tm)              
  
   Extensive rewrite of most of the code to make it more easier to       
   understand and modify.  Januari 1999 by Tasmaniac of ACiD Productions 
        *)

{$V-}

{$DEFINE DoFancy}

USES Crt, CRTVGA,
     TotFAST,
     TotStr,
     SUPPORT,
     AF_GENER, { General information }
     AF_3D,    { 3D Artist }
     AF_ANSI,  { ANSI Artist }
     AF_XBIN,  { XBIN Artist }
     AF_ASCII, { ASCII Artist }
     AF_HiRez, { HiRez artist }
     AF_ISAdm, { Network Administrator }
     AF_ISWeb, { Web developer }
     AF_ISWri, { Writer/editor }
     AF_Music, { Musicion }
     AF_PDemo, { Demo/Loader programmer }
     AF_PApps, { Apps/Utils programmer }
     AF_PMods, { BBS Mods programmer }
     AF_Essay; { Essay }

{ ===== Definition of the forms ============================================ }
TYPE  Application = (Any, Artist, Information, Music, Programmer, Disabled);

TYPE  FormRec       = RECORD
                        Entry_Func : FUNCTION (Page, NumPages, Direction : Integer) : Integer;
                        Store_Proc : PROCEDURE (VAR Out: Text);
                        IsActive   : Boolean;
                        Applic     : Application;
                        Title      : String;
                      END;
CONST Forms         : ARRAY[1..14] OF FormRec =
                      (
                        (Entry_Func : AF_GENER.Entry;
                         Store_Proc : AF_GENER.Store;
                         IsActive   : FALSE;
                         Applic     : Any;
                         Title      : 'General'),
                        (Entry_Func : AF_3D.Entry;
                         Store_Proc : AF_3D.Store;
                         IsActive   : FALSE;
                         Applic     : Artist;
                         Title      : '3D Artist'),
                        (Entry_Func : AF_ANSI.Entry;
                         Store_Proc : AF_ANSI.Store;
                         IsActive   : FALSE;
                         Applic     : Disabled;  { Disabled, should be Artist, maybe enabled again later }
                         Title      : 'ANSI Artist'),
                        (Entry_Func : AF_ASCII.Entry;
                         Store_Proc : AF_ASCII.Store;
                         IsActive   : FALSE;
                         Applic     : Artist;
                         Title      : 'ASCII Artist'),
                        (Entry_Func : AF_HIREZ.Entry;
                         Store_Proc : AF_HIREZ.Store;
                         IsActive   : FALSE;
                         Applic     : Artist;
                         Title      : 'HiRez Artist'),
                        (Entry_Func : AF_XBIN.Entry;
                         Store_Proc : AF_XBIN.Store;
                         IsActive   : FALSE;
                         Applic     : Artist;
                         Title      : 'XBIN Artist'),
                        (Entry_Func : AF_ISADM.Entry;
                         Store_Proc : AF_ISADM.Store;
                         IsActive   : FALSE;
                         Applic     : Information;
                         Title      : 'Network Admin'),
                        (Entry_Func : AF_ISWEB.Entry;
                         Store_Proc : AF_ISWEB.Store;
                         IsActive   : FALSE;
                         Applic     : Information;
                         Title      : 'Web Developer'),
                        (Entry_Func : AF_ISWRI.Entry;
                         Store_Proc : AF_ISWRI.Store;
                         IsActive   : FALSE;
                         Applic     : Information;
                         Title      : 'Writer/Editor'),
                        (Entry_Func : AF_MUSIC.Entry;
                         Store_Proc : AF_MUSIC.Store;
                         IsActive   : FALSE;
                         Applic     : Music;
                         Title      : 'Musician'),
                        (Entry_Func : AF_PDEMO.Entry;
                         Store_Proc : AF_PDEMO.Store;
                         IsActive   : FALSE;
                         Applic     : Programmer;
                         Title      : 'Demos/Loaders'),
                        (Entry_Func : AF_PAPPS.Entry;
                         Store_Proc : AF_PAPPS.Store;
                         IsActive   : FALSE;
                         Applic     : Programmer;
                         Title      : 'Apps/Utils'),
                        (Entry_Func : AF_PMODS.Entry;
                         Store_Proc : AF_PMODS.Store;
                         IsActive   : FALSE;
                         Applic     : Disabled;   { Disabled, should be Programmer, maybe enabled again later }
                         Title      : 'BBS Mods (ACiDiC)'),
                        (Entry_Func : AF_ESSAY.Entry;
                         Store_Proc : AF_ESSAY.Store;
                         IsActive   : FALSE;
                         Applic     : Any;
                         Title      : 'Essay')
                      );

{ ========================================================================== }

{$L ACiDASC.OBJ}
PROCEDURE ACiDASC; EXTERNAL;
{$L ACiDLOGO.OBJ}
PROCEDURE ACiDLOGO; EXTERNAL;
{$L ACiDMENU.OBJ}
PROCEDURE ACiDMENU; EXTERNAL;
{$L CLOSING.OBJ}
PROCEDURE CLOSING; EXTERNAL;
{$L THANKS.OBJ}
PROCEDURE THANKS; EXTERNAL;
{$L THANKSM.OBJ}
PROCEDURE THANKSM; EXTERNAL;


PROCEDURE Fancy_Startup;        { show a little animated stuff }
TYPE Screen   = ARRAY [0..3999] OF BYTE;
VAR  Line     : WORD;
     Delay    : WORD;
     Pixel    : INTEGER;
     Increm   : INTEGER;
     I        : INTEGER;
     Pal      : ARRAY[1..63*3] of WORD;
BEGIN
   { Setup }
   TextMode(Co80);
   VGA_Set8PixelFont;

{$IFDEF DoFancy}
   FillChar(VGA_Memory, sizeof(VGA_Memory), 0);
   ASM
      MOV AH,02h        { Set cursorposition            }
      MOV DX,0C80h      { DH=Row (200) DL= Column)      }
      XOR BX,BX         { Page 0                        }
      INT 10h
   END;

   { Set VGA to a width of 320 characters (4 consecutive screens) }
   Port[VGA_CRTC]  := $13;   Port[VGA_CRTC+1]:= 320 DIV 2;
   { Activate 2nd screen }
   VGA_PixelPan(640 DIV 8, 640 AND 7);
   { Fill screens with [menu][logo][blank][blank] }
   FOR Line:=0 to 24 DO BEGIN
      Move(Screen(@AcidLogo^)[Line*160], VGA_Memory[0  + Line*640], 160);
      Move(Screen(@ACidAsc^) [Line*160], VGA_Memory[160+ Line*640], 160);
   END;

   { Roughly 1,5 second wait (90 screen refreshes) Required because we changed scanning rate with VGA_Set8PixelFont }
   FOR Delay:=0 to 89 DO VGA_VSync;

   { Bounce away ASCII-logo to show ansi logo }
   Pixel    := 640;  { 80*8, start of 2nd screen }
   Increm   := 50;
   Repeat
      VGA_PixelPan(Pixel DIV 8, Pixel AND 7);
      Inc(Pixel,Increm DIV 2);
      Dec(Increm);
   Until Pixel<0;
   VGA_PixelPan(0,0);

   { Roughly 1/2 second wait (30 screen refreshes) }
   FOR Delay:=0 to 29 DO VGA_VSync;

   { Get current palette }
   Port[VGA_PEL_READ]:=0;
   FOR I:=1 TO 63*3 DO
       Pal[i] := Port[VGA_PEL_DATA];

   FOR Delay:=63 DOWNTO 0 DO BEGIN
      VGA_VSync;
      Port[VGA_PEL_WRITE]:=0;
      FOR I:=1 TO 63*3 DO BEGIN
          IF (Pal[i]>Delay) THEN
             Port[VGA_PEL_DATA] := Pal[i]
          ELSE
             Port[VGA_PEL_DATA] := Delay;
      END;

      IF Delay=63 THEN BEGIN
         { While everything is White anyway. reset screen to 80 wide and load Menu  }
         Port[VGA_CRTC]  := $13;   Port[VGA_CRTC+1]:= 80 DIV 2;
         Move(@AcidMenu^, VGA_Memory, 4000);
      END;
   END;
{$ELSE} { Non-fancy, makes debugging a whole lotta easier }
   Move(@AcidMenu^, VGA_Memory, 4000);
{$ENDIF}
END;


FUNCTION PopUpMenu(Applic : Application) : Integer;
CONST Normal      = $0A;
      Selected    = $3A;
VAR   Key         : Integer;
      Choice      : Integer;
      Checks      : Integer;
      NumChoices  : Integer;
      SavedScreen : Pointer;
      ChoiceToForm: ARRAY[0..High(Forms)+1] OF BYTE;
      MenuTop     : Integer;
      I           : Integer;
type x=array[1..4000] of char;
     xp=^x;

BEGIN
  GetMem(SavedScreen, 4000);
  Move (VGA_Memory, SavedScreen^, 4000);

  { Determine NumChoices, and translate table }
  Choice    := 0;
  Checks    := 0;
  NumChoices:= 0;
  FOR I:=Low(Forms) TO High(Forms) DO BEGIN
     IF (Forms[I].Applic=Applic) THEN BEGIN
        ChoiceToForm[NumChoices]:=I;
        Inc(NumChoices);
        Forms[I].IsActive:=FALSE;
     END;
  END;

  MenuTop:=(25-NumChoices-4) DIV 2;
  Screen.FillBox(20,MenuTop,60,MenuTop+NumChoices+3, $08, 1);
  FOR I:=0 TO NumChoices-1 DO BEGIN
    Screen.WriteAT(23,MenuTop+I+1,Normal,Forms[ChoiceToForm[I]].Title);
    Screen.WriteAT(42,MenuTop+I+1,$08,   '..............[ ]');
  END;
  Screen.WriteAT(20, MenuTop+NumChoices+1, $08, ''+replicate(39,'')+'');
  WriteAT_Piped(22, MenuTop+NumChoices+2, '|08[|07|08], [|07Space|08] selects, [|07'#17'|08] applies.');

  REPEAT
    Screen.Attrib(22, MenuTop+1+Choice, 40, MenuTop+1+Choice, Selected);
    Key := ScanKey;
    Screen.Attrib(22, MenuTop+1+Choice, 40, MenuTop+1+Choice, Normal);

    CASE Key OF
       KEY_Up   : Choice := (Choice+NumChoices-1) MOD NumChoices;
       KEY_Down : Choice := (Choice+NumChoices+1) MOD NumChoices;
       KEY_Home : Choice := 0;
       KEY_End  : Choice := NumChoices-1;
       KEY_Space: BEGIN
                    Forms[ChoiceToForm[Choice]].IsActive := NOT Forms[ChoiceToForm[Choice]].IsActive;
                    IF Forms[ChoiceToForm[Choice]].IsActive THEN BEGIN
                       Inc(Checks);
                       Screen.WriteAT(57, MenuTop+Choice+1, $07, 'X');
                    END
                    ELSE BEGIN
                       Dec(Checks);
                       Screen.WriteAT(57, MenuTop+Choice+1, $07, ' ');
                    END;
                  END;
    END;
  UNTIL (Key=KEY_Esc) OR (Key=KEY_Enter);

  IF (Key=KEY_Esc) THEN
     PopUpMenu:=0
  ELSE
     PopUpMenu:=Checks;

  Move (SavedScreen^, VGA_Memory, 4000);
  FreeMem(SavedScreen, 4000);
END;


PROCEDURE DoForms(Applic : Application);
VAR  Num_Any    : INTEGER;  { Number of screens for any type of application }
     Num_Applic : INTEGER;  { Number of screens for specific type of application (eg. Music) }
     I          : INTEGER;
     CurForm    : INTEGER;
     Page       : INTEGER;
     Direction  : INTEGER;
     Stop       : BOOLEAN;
     Out        : TEXT;
     FileName   : String;
BEGIN
  { Setup }
  Num_Any:=0;
  Num_Applic:=0;

  { Count number of items, and set items active) }
  FOR I:=Low(Forms) TO High(Forms) DO BEGIN
     IF Forms[I].Applic=Any THEN BEGIN
        Inc(Num_Any);
        Forms[I].IsActive:=TRUE;
     END
     ELSE IF Forms[I].Applic=Applic THEN BEGIN
        Inc(Num_Applic);
        Forms[I].IsActive:=TRUE;
     END
     ELSE
        Forms[I].IsActive:=FALSE;
  END;

  { If there's more than 1 specific application screen.  Then show a popup asking user which one(s) they want }
  IF (Num_Applic<>1) THEN BEGIN
     Num_Applic:=PopUpMenu(Applic);
  END;

  { We still have pages left to show ? }
  IF (Num_Applic<>0) THEN BEGIN
    { Now... Walk user through all of the required pages... }
    CurForm:=Low(Forms)-1;
    Page:=0;
    Direction:=1;
    Stop:=FALSE;

    REPEAT
      { Handle PgUp/PgDn's through the forms }
      IF ((Page=1) AND (Direction=-1)) OR
         ((Page=Num_Any+Num_Applic) AND (Direction=1)) THEN BEGIN
         { When on First or Last active page, PgUp/PgDn does nothing. }
      END
      ELSE BEGIN
         Inc(Page, Direction);
         REPEAT
           Inc(CurForm, Direction);
         UNTIL Forms[CurForm].IsActive;
      END;

      { And handle the active form }
      Direction := Forms[CurForm].Entry_Func(Page, Num_Any+Num_Applic, Direction);

      { Handle Escape and F10 }
      IF (Direction=0) THEN BEGIN { Escape }
         Stop:=TRUE;
      END
      ELSE IF (Direction=10) THEN BEGIN { F10 }
         { Write forms to file }
         FileName:=Strip('A', ' ', AF_GENER.GetAbbv);
         IF Length(FileName) = 0 THEN
            FileName:='!!!';
         FileName:=FileName+'-ACID.APP';

         Assign(Out, FileName);
         Rewrite(Out);
         Writeln(Out, '');
         Writeln(Out, '     ,---------------------------------------------------------------------.');
         Writeln(Out, '  ,--''                                                                     `--.');
         Writeln(Out, '  |                  ACiD Productions (tm) Application Form                   |');
         Writeln(Out, '  |                Generated by ACiD Application Generator by                 |');
         Writeln(Out, '  |                     The Hit Man, Jazz and Tasmaniac.                      |');
         Writeln(Out, '  `--.                                                                     ,--''');
         Writeln(Out, '     `---------------------------------------------------------------------''');
         Writeln(Out, '');
         Writeln(Out, '');

         FOR I:=Low(Forms) TO High(Forms) DO BEGIN
           IF Forms[I].IsActive THEN
              Forms[I].Store_Proc(Out);
         END;

         Writeln(Out, '');
         Writeln(Out, '                   ,---------------------------------------.');
         Writeln(Out, ' ,---------------- |  Thank you for applying to ACiD (tm). | ----------------.');
         Writeln(Out, ' |                 `---------------------------------------''                 |');
         Writeln(Out, ' |                                                                            |');
         IF Applic=Music THEN BEGIN
           Writeln(Out, ' |  Along with your application file, please include samples of your music.  |');
           Writeln(Out, ' |                                                                           |');
           Writeln(Out, ' |  Send this application archive directly to Pinion via email at the        |');
           Writeln(Out, ' |  address pinion@netcom.com.  Be sure to send some recent work via MIME    |');
           Writeln(Out, ' |  encryption.');
         END
         ELSE BEGIN
           Writeln(Out, ' |  Along with this application file, please include samples of your work,   |');
           Writeln(Out, ' |  if you are a coder or artist.                                            |');
           Writeln(Out, ' |                                                                           |');
           Writeln(Out, ' |  Upload this application to the Agora, respective Advisor or ACiD member  |');
           Writeln(Out, ' |  nearest you, requesting that it be forwarded to the appropriate senior   |');
           Writeln(Out, ' |  member.  (Archived in the .ZIP format.)                                  |');
         END;
         Writeln(Out, ' |                                                                           |');
         Writeln(Out, ' `---------------------------------------------------------------------------''');
         Writeln(Out, '');

         Close(Out);

         Stop:=TRUE;

         { Show Thanks screen, and wait for keypress }
         IF Applic=Music THEN
            SlideUP(@ThanksM,17,16,'I have created '+FileName+' in the current directory.')
         ELSE
            SlideUP(@Thanks,17,16,'I have created '+FileName+' in the current directory.');
         ScanKey;
      END
    UNTIL Stop;

    SlideUp(@ACiDMenu, 0, 0, '');
  END;
END;

{================================================================================}

Const Menu_Selected = $3A;
      Menu_Clear    = $0A;
      Menu_Size     = 4;        { number of items in menu }
      Menu_Line     = 20;
CONST Menu          : ARRAY[0..Menu_Size-1,1..2] of Byte = ((10,10),(21,24),(46,12),(59,14));
VAR   Menu_Choice   : Integer;
      Menu_Key      : Integer;

BEGIN
  WriteLn('ACiDApp V2.2.  (C) Copyright 1994-1999 ACiD Productions.');

  { ===== Bail out if no VGA is present ===== }
  IF NOT VGA_IsPresent THEN BEGIN
     WriteLn('ACiDApp requires a VGA card');
     Halt;
  END;

  { ===== Show fancy startup screen, and finish of with displaying menu ===== }
  Fancy_Startup;

  { ===== Main menu navigation ===== }
  Menu_Choice := 0;

  REPEAT
    Screen.CursOff;
    { Select menu item }
    Screen.Attrib(Menu[Menu_Choice][1], Menu_Line,
                  Menu[Menu_Choice][1]+Menu[Menu_Choice][2], Menu_Line,
                  Menu_Selected);
    { Wait for keyboard input }
    Menu_Key := ScanKey;
    { Unselect menu item }
    Screen.Attrib(Menu[Menu_Choice][1], Menu_Line,
                  Menu[Menu_Choice][1]+Menu[Menu_Choice][2], Menu_Line,
                  Menu_Clear);

    CASE Menu_Key OF
       KEY_Left  : Menu_Choice := (Menu_Choice+Menu_Size-1) MOD Menu_Size;
       KEY_Right : Menu_Choice := (Menu_Choice+Menu_Size+1) MOD Menu_Size;
       KEY_Home  : Menu_Choice := 0;
       KEY_End   : Menu_Choice := Menu_Size-1;
       KEY_Esc   : Menu_Choice := -1;
       KEY_Enter : CASE Menu_Choice OF
                     0 : DoForms(Artist);
                     1 : DoForms(Information);
                     2 : DoForms(Music);
                     3 : DoForms(Programmer);
                   END;
    END;
  UNTIL Menu_Choice = -1;

  SlideUp(@Closing, 0, 0, '');
  REPEAT
     Menu_Key := ScanKey;
  until (Menu_Key=KEY_Enter) or (Menu_Key=KEY_Esc) or (Menu_Key=Ord(' '));

  SlideDown(@ORG_Memory, 0, 0, '');
  GotoXY(ORG_X, ORG_Y);
  Screen.CursOn;
END.

