 
;         PCX VIEWER IN TEXT MODE 80x50 
;                                       
;             Code & Source by DAKE     

;                JUST A LITTLE EXAMPLE FOR THE TECH CORNER
;           You can use this code if you give me a little greetz.

 .MODEL SMALL                              ;ok - some
 .STACK                                    ;boring parameters for TASM
 CODE SEGMENT PUBLIC USE16 PARA 'CODE'
 MODEL SMALL                               ;SMALL model bcoz we don't
                                           ;use much memory
 ASSUME cs:CODE
 JUMPS
 .386C
 

;               DATA & VALUES 

 buffer dw ?                               ;segment of the buffer 
 handle dw ?                               ;handle of PCX file
 filename db 'punk.pcx',0
        
 map db 126,255,255,255,255,255,255,126   

;         MACROS - Memory Managing 

 BLOCK MACRO size                          ;size contains the number of bytes
 mov   bx,size                             ;we have bytes but we must
 shr   bx,4                                ;convert it to "paragraphs"
                                           ;so, divide by 16
 
 mov   ah,4ah                              ;this is the fonction that
 int   21h                                 ;resize the memory block
 ENDM                                      ;which is used by our programm...
                               


 ALLOC_MEM MACRO number, position          ;number in byte and position
 mov    ah,48h                             ;is the WORD where goes
 mov    bx,number                          ;the segment value
 shr    bx,4                               ;we divide by 16 => paragraphs
 int    21h
 mov    position,ax                        ;let's put it in position
 ENDM

 DEALLOC_MEM MACRO position                ;dealloc the memory
 mov    ah,49h
 mov    bx,position                        ;the segment must be known
 mov    es,bx                              ;for the deallocation
 int    21h
 ENDM

 ;                 PROCEDURES            
 
 OPEN_FILE PROC
 mov    ax,seg filename
 mov    ds,ax
 mov    dx,offset filename                 ;DS:DX=filename (in ASCIIZ !) 
                                           ;position
 mov    al,0                               ;open for read only
 mov    ah,03dh
 int    21h                                ;call the interruption
 jc     problem_file                       ;if there're problems => DOS
 mov    handle, AX                         ;if not, we save the file's handle
 ret
 OPEN_FILE ENDP

 READ_FILE PROC
 mov    ax,buffer                          
 mov    ds,ax                              ;DS is the buffer segment
 mov    dx,0                               ;allocated blocks have always
 mov    ah,03fh                            ;offset at 0 !!!
 mov    bx,handle
 mov    cx,64000                           ;read 64000 bytes
 int    21h
 jc     problem_file                       ;if there's a problem => DOS
 ret
 READ_FILE ENDP

 CLOSE_FILE PROC
 mov    ah,03eh                            ;close the current file
 mov    bx,handle                       
 int    21h
 ret
 CLOSE_FILE ENDP

 TEXT_MODE PROC                            
 mov    bx,0                               ;BX=0 bcoz there could happened
 mov    ax,03h                             ;problems during the init. 
 int    10h                                ;text mode 80x25
 xor    ax,1111h                           ;AX=01112h
 int    10h                                ;8x8 ROM double dot character
 push   0b800h                             ;text memory at 0B800h:0000
 pop    es                                 ;in ES:DI
 ret
 TEXT_MODE ENDP

 EXTEND_COLORS PROC                        ;you could not change the last
                                           ;eight colors of the text mode
                                           ;so, you must modify some   
                                           ;values in the ATC
 
 mov    dx,03c0h                           ;the ATC (attribute controler)
 xor    ah,ah                              ;is at port 03c0h
                          
 Next0:                                 
 mov    al,ah                              ;we'll change registers 0-f
 out    dx,al                              ;we extend 16 colors
 out    dx,al
 inc    ah
 cmp    ah,010h                            
 jb     Next0                              ;now, you can change 16 colors !
 ret
 EXTEND_COLORS ENDP                       
 
 MAKE_CHAR PROC                            ;we'll change one character
 push   es                                
 mov    ah,011h                            ;video fonction 011h
 mov    al,0                               ;load character to table 0 
 mov    bh,8                               ;number of line in one character
 mov    bl,0                               ;character table we're modifying
 mov    cx,1                               ;number of character to modify
 mov    dx,seg map 
 mov    es,dx
 mov    bp,offset map                      ;ES:BP=character data
 mov    dx,'P'                             ;ASCII number of the character
 int    10h                                ;ok, let's change it 
 pop    es
 ret
 MAKE_CHAR ENDP

 CHECK_PCX PROC                            ;this proc checks if we have
 mov    ax,buffer                          ;a PCX file in 80x50 - 256 c
 mov    ds,ax
 mov    al,ds:[3]                          ;check byte 3 - depth
 cmp    al,8                               ;8=256 colors => ok
 jnz    Not_Good_Size
 mov    al,ds:[8]
 cmp    al,04fh                            ;check width - must be 79
 jnz    Not_Good_Size
 mov    al,ds:[10]
 cmp    al,031h                            ;check height - must be 49
 jnz    Not_Good_Size
 ret
 CHECK_PCX ENDP

 DECODE_PCX PROC
 xor    bp,bp                              ;BP is a counter
 mov    ax,buffer
 mov    ds,ax                              
 mov    si,0                               ;DS:SI (DS:0) = PCX data
 xor    di,di                              ;we start at the first position
                                           ;on screen ES:DI (ES:0)

 Affiche_2:                                ;the header has got 128 bytes
 add    si,128                             ;we leave it and begin with 
                                           ;the useful datas...
  
 Affiche_3:                    
 mov    al,byte ptr ds:[si]           ;one byte in AL
 cmp    al,0c0h                       ;AL < 0C = No Run Length Compression
 jnbe   RLE                           ;go to RLE if we don't have AL < 0C
                           
 SINGLE:                              ;if we have AL < 0C
 mov    es:[di+1],al                  ;we put  the color in the text mem.

                                      ;don't forget that in text memory
                                      ;one word is : charcolor

 mov    bl,'P'                         ;and we put the ASCII value 
 mov    es:[di],bl                    ;we have the char BL
                                      ;of color AL

 add    di,2                          ;next chara. (next word)
 add    bp,1                          ;we increase the counter
 inc    si                            ;and next byte in the PCX file
 jmp    Fin_Decode                    ;don't do the RLE decompression
                   

 RLE:                                 ;a compressed pixel looks like 
                                      ;number of repet.color

 sub    al,0c0h                       ;find the number of repetitions
 mov    bl,byte ptr ds:[si+1]         ;BL=color

 Rle_1:              
 mov    es:[di+1],bl                    ;put the color in text mem.
 
 ;if you like to have differents characters, so "decomment" these lines
 ;mov    cl,'A'                         
 ;add    cl,bl                         
                                        
 mov    cl,'P'
 mov    es:[di],cl                      ;.. on screen

 dec    al                              ;we decrease the number of repet.
 add    di,2                            ;next chara on screen
 add    bp,1                            ;increase the pixel's counter
 cmp    al,0                            ;if we have finished then we stop
 jnz    Rle_1         
 add    si,2                          ;we increase the file pointer by 2 !
                                      ;because we have the repet & color
                                      ;they make one word !!!

 Fin_Decode:                              
 cmp    bp,4000                       ;are we at the end of the screen ?
 jna    Affiche_3                     ;no ! so continue....

 xor   ax,ax                          ;768 bytes behind the End of the file
 xor   bx,bx
 xor   bp,bp
 Palette1:
 mov   ah,ds:[si]                     ;take the red
 mov   bx,ds:[si+1]                   ;green+blue
 shr   ah,2                           ;divide them by 4 bcoz VGA card
 shr   bl,2                           ;accept only 6 bits values
 shr   bh,2

 push  ax
 push  bx
 mov   dx,3c8h                        ;DAC  
 out   dx,al                        
 mov   dx,3c9h                        ;and the values of Red, Green and Blue
 mov   al,ah
 out   dx,al                          ;RED
 mov   al,bl
 out   dx,al                          ;GREEN
 mov   al,bh
 out   dx,al                          ;BLUE
 pop   bx
 pop   ax   

 inc   al                             ;next index
 add   si,3
 cmp   al,16
 jna   Palette1                       ;if we've done the 16 colors then stop

 ret                 
 DECODE_PCX ENDP

 HIDE_CURSOR PROC   
 mov   ax,0100h
 mov   cx,02000h           
 int   10h
 ret
 HIDE_CURSOR ENDP


;                Main Programm    

 Start:
 
 BLOCK 64000                      ;our programm has a max size of 64000 bytes
 ALLOC_MEM 64000,buffer           ;we alloc our buffer which will contain
                                  ;the PCX data

 call OPEN_FILE                  
 call READ_FILE                   ;we put the PCX into memory    
 call CLOSE_FILE

 call TEXT_MODE
 call HIDE_CURSOR
 call EXTEND_COLORS           
 call MAKE_CHAR

 call CHECK_PCX
 call DECODE_PCX
 
 xor  ax,ax                       ;wait for a keypress
 int  16h


 DEALLOC_MEM buffer               ;dealloc the buffer 
 mov  ax,4c00h                    ;return to DOS
 int  21h

 problem_file:
 
 DEALLOC_MEM buffer               ;dealloc the buffer 
 mov ax,03h
 int 10h
 mov dx,offset message
 mov ax,seg message
 mov ds,ax
 mov ah,09h
 int 21h
 mov  ax,4c00h                    ;return to DOS
 int  21h

 not_good_size:
 DEALLOC_MEM buffer               ;dealloc the buffer 
 mov ax,03h
 int 10h
 mov dx,offset message2
 mov ax,seg message2
 mov ds,ax
 mov ah,09h
 int 21h
 mov  ax,4c00h                    ;return to DOS
 int  21h

 message db 'Error - File Not Found$'
 message2 db 'Error - Not a valid 80x50 PCX file$'

 CODE ENDS
 End Start

