#include "main.h"
#include "engine.h"
#include "loadlwo.h"
#include "util.h"

static scene_s *scene;

static int startframe, textpos;
static void DoText(int y, int fak);

int Part4Init(int frame)
{
#ifdef DEBUG
  printf("part 4 init.\n");
#endif
  startframe=frame;
  scene=new scene_s;
#ifdef DEBUG
  printf("initializing scene 3\n");
#endif
  extern char M_04bck1[], M_04msk1[];
  LoadTIM(M_04bck1);
  LoadTIM(M_04msk1);
  object_s *n=new object_s;
  n->Initialize();
  n->child=new object_s*[4];
  extern char LWO_Thing2_1[], LWO_Thing2_2[], LWO_Thing2_3[];
  n->child[0]=LoadLWO(LWO_Thing2_1);
  n->child[1]=LoadLWO(LWO_Thing2_2);
  n->child[2]=LoadLWO(LWO_Thing2_3);
  n->child[3]=0;
  scene->root=n;
  n->child[0]->scene=scene;
  n->child[1]->scene=scene;
  n->child[2]->scene=scene;
  n->child[0]->parent=n;
  n->child[1]->parent=n;
  n->child[2]->parent=n;
  textpos=128*1000;
  return 0;
}

int Part4Frame(int frame)
{
  frame-=startframe;

  textpos*=4000;
  textpos/=4096;

  int fak=4096;

  if (frame>500)
    fak=4096-(frame-500)*20;
  if (fak<0)
    return 1;
  DoText(60-(textpos/100), fak);
                                 // setup light sources
  scene->l_dir.m[0][0]=2896*fak/4096;
  scene->l_dir.m[0][1]=2896*fak/4096;
  scene->l_dir.m[0][2]=0;

  scene->l_dir.m[1][0]=0;
  scene->l_dir.m[1][1]=0;
  scene->l_dir.m[1][2]=-4096;

  scene->l_dir.m[2][0]=0;
  scene->l_dir.m[2][1]=0;
  scene->l_dir.m[2][2]=0;
                                  // setup light colors
  scene->l_color.m[0][0]=4096*fak/4096;
  scene->l_color.m[1][0]=4096*fak/4096;
  scene->l_color.m[2][0]=4096*fak/4096;

  scene->l_color.m[0][1]=4096*fak/4096;
  scene->l_color.m[1][1]=4096*fak/4096;
  scene->l_color.m[2][1]=4096*fak/4096;

  scene->l_color.m[0][2]=4096*fak/4096;
  scene->l_color.m[1][2]=4096*fak/4096;
  scene->l_color.m[2][2]=4096*fak/4096;
                                  // setup ambient
  scene->l_color.t[0]=1024*fak/4096;
  scene->l_color.t[1]=1024*fak/4096;
  scene->l_color.t[2]=1024*fak/4096;
                                  // camera position
  scene->camera.pos.v.vx=0;
  scene->camera.pos.v.vy=0;
  scene->camera.pos.v.vz=-10000;
                                  // camera direction
  scene->camera.pos.r.vx=0;
  scene->camera.pos.r.vy=0;
  scene->camera.pos.r.vz=0;
  scene->camera.matval=0;
                                  // object position
  scene->root->matval=0;
  scene->root->pos.r.vx=0;
  scene->root->pos.r.vy=0;
  scene->root->pos.r.vz=rsin(frame*10)/10;

  scene->root->pos.v.vx=0;
  scene->root->pos.v.vy=-(4096-fak)*3;
  scene->root->pos.v.vz=0;

  scene->root->child[0]->pos.r.vx-=10;
  scene->root->child[0]->pos.r.vz=1024;
  scene->root->child[0]->matval=0;

  scene->root->child[1]->pos.r.vz=1024;
  scene->root->child[1]->pos.r.vx+=10;              // rote kltze
  scene->root->child[1]->matval=0;

  scene->root->child[2]->pos.r.vx=rsin(frame*64)/64;
  scene->root->child[2]->pos.r.vz=1024;           // festes, grosses objekt
  scene->root->child[2]->matval=0;

  int r, g, b;

  r=g=b=fak>>6;

  int rgb=r | (g<<8) | (b<<16);

  engineRender(scene);
  introShowPicture(640, 0, getClut(0, 480), 1, rgb);
    
  return 0;
}

int Part4Close()
{
#ifdef DEBUG
  printf("closing Part4 ... SHOULD delete objects here.\n");
#endif
  scene->root->Free();
  delete scene->root;
  delete scene;
  return 0;
}

static void DoText(int y, int fak)
{
  int clut=getClut(0, 481); // 315x53
  int tpage=getTPage(0, 0, 0, 256);

  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

  setPolyFT4(pft4);

  pft4->r0=128*fak/4096;
  pft4->g0=128*fak/4096;
  pft4->b0=128*fak/4096;

  pft4->clut=clut;

  pft4->tpage=tpage;

  pft4->x0=2;
  pft4->y0=y;

  pft4->x1=2+256;
  pft4->y1=y;

  pft4->x2=2;
  pft4->y2=y+53;

  pft4->x3=2+256;
  pft4->y3=y+53;

  pft4->u0=0;
  pft4->v0=0;

  pft4->u1=255;
  pft4->v1=0;

  pft4->u2=0;
  pft4->v2=53;

  pft4->u3=255;
  pft4->v3=53;
  addPrim(ot+OTSIZE-1, pft4);
  pft4++;

  setPolyFT4(pft4);

  pft4->r0=128*fak/4096;
  pft4->g0=128*fak/4096;
  pft4->b0=128*fak/4096;

  pft4->clut=clut;
  pft4->tpage=getTPage(0, 0, 64, 256);

  pft4->x0=2+256;
  pft4->y0=y;

  pft4->x1=2+256+59;
  pft4->y1=y;

  pft4->x2=2+256;
  pft4->y2=y+53;

  pft4->x3=2+256+59;
  pft4->y3=y+53;

  pft4->u0=0;
  pft4->v0=0;

  pft4->u1=59;
  pft4->v1=0;

  pft4->u2=0;
  pft4->v2=53;

  pft4->u3=59;
  pft4->v3=53;
  addPrim(ot+OTSIZE-1, pft4);
  pft4++;

  _curdisplayp->wspacepos += (char *)pft4 - startp;
  
}
