#define   SCALE     1
#define BIG_ENDIAN

#include "main.h"
#include "loadlwo.h"
#define   POINTS_PER_POINT    1
#define   FACES_PER_FACE    1

inline u_short swaplb2(u_short v) { return (v<<8)|(v>>8); }
inline u_long swaplb4(u_long v) { return ((v&0xFF)<<24)|((v&0xFF00)<<8)|((v>>8)&0xFF00)|((v>>24)&0xFF); }

class LoadLWO_c
{
  char *lwo;
  int eread(void *dst, int bytes);
  void seekcur(int v)
  {
    lwo+=v;
  }
  int ReadChunk();
  inline u_short getss()
  {
    u_short x;
    eread(&x, 2);
#ifdef BIG_ENDIAN
    return swaplb2(x);
#else
    return x;
#endif
  }
  inline u_long getsl()
  {
    u_long x;
    eread(&x, 4);
#ifdef BIG_ENDIAN
    return swaplb4(x);
#else
    return x;
#endif
  }
  inline float getsf()
  {
    u_long x;
    eread(&x, 4);
#ifdef BIG_ENDIAN
    x=swaplb4(x);
#endif
    float r=*((float*)&x);
    return r;
  }
  object_s *obj;

  struct surface_t
  {
    char *name;
    int id;

    CVECTOR color;

    int flags;
    int wirecolor;

    surface_t *next;
  } *surface, *surfcurrent;

  surface_t *AddSurface();
  surface_t *LookupSurface(const char *name);
  surface_t *LookupSurface(int id);

  int ProcessSurfaces();

  int AllocateFaceMemory(int faces);
  int AllocateVertexMemory(int vertices);

public:
  object_s *LoadObject(void *mem);
  LoadLWO_c::LoadLWO_c();
};

int LoadLWO_c::AllocateFaceMemory(int faces)
{
  obj->face=new face_s[faces+1];
  obj->face_point=new int[faces*3+1];
  obj->face_surfaceid=new int[faces+1];

  return !0;    // das klappt schon.
}

int LoadLWO_c::AllocateVertexMemory(int vertices)
{
  obj->point=new SVECTOR[vertices+2]+1;

  obj->vnormal=new SVECTOR[vertices+2]+1;
  obj->ovnormal=new SVECTOR[vertices+2]+1;

  return !0;
}

int LoadLWO_c::eread(void *dst, int length)
{
  memcpy(dst, lwo, length);
  lwo+=length;
  return length;
}

LoadLWO_c::surface_t *LoadLWO_c::LookupSurface(int id)
{
  for (surface_t *t=surface; t; t=t->next)
    if (id==t->id)
      return t;
  return 0;
}

LoadLWO_c::surface_t *LoadLWO_c::LookupSurface(const char *name)
{
  for (surface_t *t=surface; t; t=t->next)
    if (!strcmp(t->name, name))
      return t;
  return 0;
}

LoadLWO_c::surface_t *LoadLWO_c::AddSurface()
{
  surface_t *n=new surface_t;
  n->name=0;
  n->next=surface;
  n->color.cd=0x20;
  n->color.r=n->color.g=n->color.b=255;
  n->wirecolor=0;
  n->flags=0;
  surface=n;
  return n;
}


LoadLWO_c::LoadLWO_c()
{
  surface=surfcurrent=0;
}

object_s *LoadLWO(void *mem)
{
  LoadLWO_c x;
  object_s *c=x.LoadObject(mem);
  return c;
}

object_s *LoadLWO_c::LoadObject(void *mem)
{
  lwo=(char*)mem;
#ifdef DEBUG
  printf("loading object.\n");
#endif
  obj=new object_s;
  obj->Initialize();

#ifdef DEBUG
  printf("reading chunk.\n");
#endif
  int lwolen=ReadChunk();
#ifdef DEBUG
  printf("LWO: %d bytes read.\n", lwolen);
#endif

#ifdef DEBUG
  printf("LWO object load done, doing precalculation...\n");
#endif
  obj->CalcNormals();
  obj->TransferPoints();

#ifdef DEBUG
  printf("processing surfaces.\n");
#endif
  if (ProcessSurfaces())
    return 0;

#ifdef DEBUG
  printf("done.\n");
#endif
  return obj;
}

int LoadLWO_c::ReadChunk()
{
  char tag[4];
  if (!eread(tag, 4)) return 0;
#ifdef DEBUG
  printf("TAG: %c%c%c%c\n", tag[0], tag[1], tag[2], tag[3]);
#endif
  int length=getsl();
  int read=8+length;
  if (!memcmp(tag, "FORM", 4))
  {
    char id[4];
    if (!eread(id, 4)) return 0;
    length-=4;
    if (memcmp(id, "LWOB", 4))
    {
#ifdef DEBUG
      printf("not a LWOB (=> %c%c%c%c).\n", id[0], id[1], id[2], id[3]);
#endif
      return 0;
    }
    while (length)
    {
      int g=ReadChunk();
      if (!g) return 0;
      length-=g;
    }
  } else if (!memcmp(tag, "SRFS", 4))
  {
#ifdef DEBUG
    printf("SRFS:\n");
#endif
    int id=1;
    while (length)
    {
#ifdef DEBUG
      printf("len: %d\n", length); 
#endif
      char surfacename[50];
      int s=0;
      while (length)
      {
        length--;
        eread(surfacename+s, 1);
        if (!surfacename[s++]) break;
      }
      if (s&1) { seekcur(1); length--; }
      strcpy((surfcurrent=AddSurface())->name=new char[s+1], surfacename);
#ifdef DEBUG
      printf("  Surface #%d: %s\n", id, surfacename);
#endif
      surfcurrent->id=id++;
    }
    seekcur(length);
  } else if (!memcmp(tag, "PNTS", 4))
  {
#ifdef DEBUG
    printf("PNTS: (%d)\n", length/12);
#endif
    int pnt=0;
    obj->points=length/12;

    if (!AllocateVertexMemory(obj->points))
#ifdef DEBUG
      printf("FATAL: not enough memory for vertices!\n");
#else
      ;
#endif
    while (length)
    {
      float x=getsf();
      float y=getsf();
      float z=getsf();
      obj->point[pnt].vx=(int)(x*SCALE*4096.0);
      obj->point[pnt].vy=(int)(y*SCALE*4096.0);
      obj->point[pnt].vz=(int)(z*SCALE*4096.0);
/*      printf("  point #%d: (", pnt);
      PrintFix(obj->point[pnt].vx);
      printf("|");
      PrintFix(obj->point[pnt].vy);
      printf("|");
      PrintFix(obj->point[pnt].vz);
      printf(")\n"); */
      pnt++;
      length-=12;
    }
  } else if (!memcmp(tag, "POLS", 4))
  {
#ifdef DEBUG
    printf("poly: (%d)\n", length/10);
#endif
    obj->faces=length/10;            // assuming triangles!!

    if (!AllocateFaceMemory(obj->faces))
    {
      printf("FATAL: not enough memory for faces.\n");
      return 0;
    }

    int pol=0;

    while (length)
    {
      int vertexes=getss();
      length-=2;
//      printf("  %deck, ", vertexes);
      if (vertexes!=3)
      {
        printf("NOT a triangle, aborting. (sorry)\n");
        return 0;
      }

      for(int vertex=0; vertex<vertexes; vertex++)
      {
        int pnt=getss();
        length-=2;
        int dv=vertex;
        if (dv==1)
          dv=0;
        else if (dv==0)
          dv=1;
         
        obj->face_point[pol*3+dv]=pnt;
//        printf("%d%c", pnt, (vertex<vertexes-1)?'-':',');
      }
      obj->face_surfaceid[pol]=getss();
      length-=2;
      pol++;
    }
  } else if (!memcmp(tag, "SURF", 4))
  {
    int s=0;
    char surfacename[50];
    while (length)
    {
      length--;
      eread(surfacename+s, 1);
      if (!surfacename[s++])
        break;
    }
    if (s&1) { seekcur(1); length--; }
    surfcurrent=LookupSurface(surfacename);
    if (!surfcurrent)
    {
      printf("unknown surface %s\n", surfacename);
      return 0;
    }
#ifdef DEBUG
    printf("surface: %s\n", surfacename);
#endif
    while (length>0)
    {
      char subchunk[4];
      eread(subchunk, 4);
      int slen=getss();
      length-=6;
      if (!memcmp(subchunk, "COLR", 4))
      {
        char r, g, b;
        eread(&r, 1);
        eread(&g, 1);
        eread(&b, 1);
        seekcur(1);

        surfcurrent->color.cd=0x20;  // assuming flat shading.
        surfcurrent->color.r=r;
        surfcurrent->color.g=g;
        surfcurrent->color.b=b;

        length-=4;
      } else if (!memcmp(subchunk, "FLAG", 4))
      {
        surfcurrent->flags=getss();
        length-=2;
      } else if (!memcmp(subchunk, "LUMI", 4))
      {
        surfcurrent->wirecolor=getss();
        length-=2;
      } else
      {
//        printf("Skipping surface-subchunk %c%c%c%c (len: %d).\n", subchunk[0], subchunk[1], subchunk[2], subchunk[3], slen);
        length-=(slen+1)&~1;
        seekcur((slen+1)&~1);
      }
    }
    seekcur((length+1)&~1);
  } else
  {
#ifdef DEBUG
    printf("Skipping chunk %c%c%c%c.\n", tag[0], tag[1], tag[2], tag[3]);
#endif
    seekcur((length+1)&~1);
  }
  return read;
}

// #define TMAP
 #define WIRE

int LoadLWO_c::ProcessSurfaces()
{
#ifdef TMAP
  int clut=getClut(0, 481);
  int tpage=getTPage(1, 0, 768, 0);
#endif
  int twoface=0;
  for (int i=0; i<obj->faces; i++)
  {
    surface_t *sd=LookupSurface(obj->face_surfaceid[i]);
 
    if (!sd)
    {
      printf("illegal surface in object.\n");
      return -1;
    }
    obj->face[i].col[0]=sd->color;

    obj->face[i].type=1;

    if (sd->flags&4)       // "Smoothing" -> kein flat.
      obj->face[i].type=0;

#ifdef TMAP                   // irgendwie anders handeln... oder... KORREKT!?
    obj->face[i].type=2;

    obj->face[i].clut=clut;
    obj->face[i].tpage=tpage;

    obj->face[i].col[0].cd=0x24;

    obj->face[i].u0=((obj->face[i].pos[0].vx>>8)+(obj->face[i].pos[0].vy>>8))&31;
    obj->face[i].v0=((obj->face[i].pos[0].vz>>8)+(obj->face[i].pos[0].vy>>8))&31;
    obj->face[i].u1=((obj->face[i].pos[1].vx>>8)+(obj->face[i].pos[1].vy>>8))&31;
    obj->face[i].v1=((obj->face[i].pos[1].vz>>8)+(obj->face[i].pos[1].vy>>8))&31;
    obj->face[i].u2=((obj->face[i].pos[2].vx>>8)+(obj->face[i].pos[2].vy>>8))&31;
    obj->face[i].v2=((obj->face[i].pos[2].vz>>8)+(obj->face[i].pos[2].vy>>8))&31;
#endif
    if (sd->flags&2)        // "outline"      - achtung, leicht differentes handling.
    {
      obj->face[i].type|=4;
      obj->face[i].col[3].cd=76;
      obj->face[i].col[3].r=sd->wirecolor*255/256;
      obj->face[i].col[3].g=sd->wirecolor*255/256;
      obj->face[i].col[3].b=sd->wirecolor*255/256;
    }
    if (sd->flags&0x100)
    {
      obj->face[i].type|=8;     // double-sided
      twoface++;
    }
  }
#ifdef DEBUG
  if (twoface)
    printf("%d faces are double-sided. note that this decreases performance.\n", twoface);
#endif
  delete [] obj->face_surfaceid;
  for (surface_t *f=surface; f;)
  {
    delete f->name;
    surface_t *o=f->next;
    delete f;
    f=o;
  }
  return 0;
}
