#include <ctype.h>
#include "main.h"
#include "engine.h"
#include "loadlwo.h"
#include "util.h"

static int startframe;

static void WriteLetter(char c, int x, int y, int rgb=0x7F7F7F);
static void WriteString(int x, int y, const char *string, int rgb=0x7F7F7F);

static char *endscroller[]={"",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            " MONOpHOBiA",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "tmb    syntic",
                            "ronny   magn",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "thanks to",
                            "teklords",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            "vier",
                            "  zweitausend",
                            "",
                            "  witchcraft",

//                             " drei eins drei drei sieben"

/*                            "NAPALMN AND HITMEN RooLZ!",
                            "we greet elitegroup and",
                            "future crew and local zeros", */
                            0};

static void DoEndscroller(int y);

int PartEInit(int frame)
{
#ifdef DEBUG
  printf("part E init - finally.\n");
#endif
  startframe=frame;
  extern char M_0Ebck1[], M_Font[];
  LoadTIM(M_0Ebck1);
  LoadTIM(M_Font);
  return 0;
}

int PartEFrame(int frame)
{
  frame-=startframe;

  int rgb, r, g, b;

  if (frame<128)
    r=g=b=frame>>1;
  else if (frame<1600)
    r=g=b=63;
  else
    r=g=b=(1663-frame);

  if (r<0)
    r=g=b=0;

  rgb=(r)|(g<<8)|(b<<16);

  DoEndscroller(frame);

  introShowPicture(640, 0, getClut(0, 480), 1, rgb);

  return 0;
}

int PartEClose()
{
  return 0;
}

static int skip[][2]={{1, 0},      // a
                      {1, 2},      // b
                      {3, 2},      // c
                      {3, 3},      // d
                      {2, 2},      // e
                      {8, 7},      // f
                      {3, 2},      // g
                      {1, 2},      // h
                      {12, 7},      // i !!
                      {6, 11},      // j
                      {5, 4},      // k
                      {12, 8},      // l !!
                      {3, 3},      // m
                      {2, 2},      // n
                      {3, 2},      // o
                      {3, 2},      // p
                      {3, 2},      // q
                      {1, 0},      // r
                      {3, 2},      // s
                      {8, 5},      // t
                      {3, 2},      // u
                      {3, 3},      // v
                      {2, 2},      // w
                      {2, 1},      // x
                      {3, 2},      // y
                      {3, 2},      // z
                      };



static void WriteLetter(char c, int x, int y, int rgb)
{
  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

  c=toupper(c);
  if (c>'Z')
    return;
  if (c<'A')
    return;

  int lx=c-'A';
  int ly=0;
  while (lx>=9)
  {
    ly++;
    lx-=9;
  }

  setPolyFT4(pft4);

  pft4->r0=rgb&0xFF;
  pft4->g0=(rgb>>8)&0xFF;
  pft4->b0=(rgb>>16)&0xFF;

  pft4->r0=151>>1;
  pft4->g0=151>>1;
  pft4->b0=220>>1;

  ly="\x00\x1b\x39"[ly];

  if (!ly)
    y+=2;

  pft4->x0=x;
  pft4->y0=y;

  pft4->x1=x+28;
  pft4->y1=y;

  pft4->x2=x;
  pft4->y2=y+30;

  pft4->x3=x+28;
  pft4->y3=y+30;

  pft4->u0=lx*27;
  pft4->v0=ly;
  pft4->u1=lx*27+28;
  pft4->v1=ly;
  pft4->u2=lx*27;
  pft4->v2=ly+27;
  pft4->u3=lx*27+28;
  pft4->v3=ly+27;

  pft4->tpage=getTPage(0, 0, 0, 256);
  pft4->clut=getClut(0, 481);

  addPrim(ot+1, pft4);
  pft4++;

  _curdisplayp->wspacepos += (char *)pft4 - startp;
  
}

static void WriteString(int x, int y, const char *string, int rgb)
{
  while (*string)
  {
    int c=*string++;
    int cc=toupper(c)-'A';
    if ((cc<0) || (cc>26))
      cc='X'-'A';
    WriteLetter(c, x-skip[cc][0], y, rgb);
    x+=27-skip[cc][0]-skip[cc][1]+3;
  }
}

static void DoEndscroller(int y)
{
  char **line=endscroller;
  int cury=-y;

  while (cury<-30)
  {
    line++;
    if (!*line)
      return;
    cury+=30;
  }

  while (cury<240)
  {
    if (!*line)
      return;
    WriteString(0, cury, *line);
    line++;
    cury+=30;
  }
}
