#include "maths.h"

// These are needed in order for float<->int casts to work without linking to the C runtime libraries
extern "C"
{
	int _fltused = 1;
	__declspec(naked) void _ftol2()
	{
		__asm
		{
			fistp qword ptr[esp - 8]
			mov   edx, [esp - 4]
			mov   eax, [esp - 8]
			ret
		}
	}
	__declspec(naked) void _ftol2_sse()
	{
		__asm
		{
			fistp dword ptr[esp - 4]
			mov   eax, [esp - 4]
			ret
		}
	}
	void* __cdecl memset(void* ptr, int val, size_t size)
	{
		char* p = (char*)ptr;
		for (size_t i = 0; i < size; ++i)
			p[i] = val;
		return ptr;
	}
	void* __cdecl memcpy(void* dest, const void* source, size_t size)
	{
		char* d = (char*)dest;
		const char* s = (const char*)source;
		for (size_t i = 0; i < size; ++i)
			d[i] = s[i];
		return dest;
	}
}


/*
// not really used anymore, we just hardcoded the matrices that we need :)
void CalcProjectionMatrix(float fovHalfYRadians, float aspect, float nearPlane, float farPlane, float matrix[16])
{
	float cot = mycos(fovHalfYRadians) / mysin(fovHalfYRadians);
	float dz = nearPlane - farPlane;

	matrix[0] = cot / aspect;	matrix[1] = 0;		matrix[2] = 0;	matrix[3] = 0;
	matrix[4] = 0;				matrix[5] = cot;	matrix[6] = 0;	matrix[7] = 0;
	matrix[8] = 0;				matrix[9] = 0;		matrix[10] = (farPlane + nearPlane) / dz; matrix[11] = -1;
	matrix[12] = 0;				matrix[13] = 0;		matrix[14] = 2 * nearPlane * farPlane / dz; matrix[15] = 0;
}

void CalcOrthoMatrix(float width, float height, float znear, float zfar, float matrix[16])
{
	float dx = 2 / width;
	float dy = 2 / height;
	float dz = -2 / (zfar - znear);
	float ox = -dx / 2;
	float oy = -dy / 2;
	float oz = -(zfar + znear) / (zfar - znear);
	matrix[ 0] = dx; matrix[ 1] =  0; matrix[ 2] =  0; matrix[ 3] = 0;
	matrix[ 4] =  0; matrix[ 5] = dy; matrix[ 6] =  0; matrix[ 7] = 0;
	matrix[ 8] =  0; matrix[ 9] =  0; matrix[10] = dz; matrix[11] = 0;
	matrix[12] = ox; matrix[13] = oy; matrix[14] = oz; matrix[15] = 1;
}

void CalcViewMatrix(vec3 from, float matrix[16])
{
	vec3 to = vec3(0, 0, 0);
	vec3 up = vec3(0, 1, 0);
	vec3 forward = normalize(from - to);
	vec3 right = normalize(cross(up, forward));
	up = cross(forward, right);

	matrix[ 0] =   right.x; matrix[ 1] =      up.x; matrix[ 2] = forward.x; matrix[ 3] = 0;
	matrix[ 4] =   right.y; matrix[ 5] =      up.y; matrix[ 6] = forward.y; matrix[ 7] = 0;
	matrix[ 8] =   right.z; matrix[ 9] =      up.z; matrix[10] = forward.z; matrix[11] = 0;
	matrix[12] = -dot3(from,right); matrix[13] = -dot3(from,up); matrix[14] = -dot3(from,forward); matrix[15] = 1;
}
*/