#include <immintrin.h>
#include <windows.h>
#include "maths.h"
#include "physics.h"
#include "glfunctions.h"
#include "rendering.h"
#include "audio.h"
#include "timeline.h"
#include "anim.h"

#if _DEBUG
#include <iostream>
#endif


static const PIXELFORMATDESCRIPTOR pfd =
{
	sizeof(PIXELFORMATDESCRIPTOR), 1, PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER,
	PFD_TYPE_RGBA,
	32, // color bits
	0, 0, 0, 0, 0, 0,
	8, 0, // 8 alpha bits
	0, 0, 0, 0, 0, // no accum buffer
	32, // depth bits
	0, // stencil bits
	0, PFD_MAIN_PLANE, 0, 0, 0, 0
};


// stolen from our competition :^)
#if FINALBUILD
static DEVMODEA devMode =
{
	{ 0 }, // device name
	DM_SPECVERSION, // specification version
	0, // driver version
	sizeof(DEVMODEA), // size
	0, // driver extra
	DM_PELSWIDTH | DM_PELSHEIGHT, // flags
	{ 0 }, // union
	0, // color
	0, // duplex
	0, // y resolution
	0, // truetype font option
	0, // collate
	{ 0 }, // form name
	0, // logical pixels
	0, // bits per pixel
	kResolutionX, // width
	kResolutionY, // height
	{ 0 }, // union
	0, // display frequency
#if (WINVER >= 0x0400)
	0, // icm method
	0, // icm intent
	0, // media type
	0, // dither type
	0, // reserved 1
	0, // reserved 2
#if (WINVER >= 0x0500) || (_WIN32_WINNT >= _WIN32_WINNT_NT4)
	0, // panning width
	0, // panning height
#endif
#endif
};
#endif

static LARGE_INTEGER s_TimerFrequency;

static double GetTime()
{
	LARGE_INTEGER t;
	QueryPerformanceCounter(&t);
	return double(t.QuadPart) / double(s_TimerFrequency.QuadPart);
}


static bool gSimulatePhysics = true;

struct SpawnDesc { signed char x, y, z, halfSize, start, end; };
static SpawnDesc kCubes[] = {
	{ 20, -6, 0, 40, 0, 30},
	{  0, 30,-2, 40, 4, 14},
	{-10, 30,-2, 40, 6, 15},
	{ 10, 30,-2, 39, 6, 15},
	{-15, 30,-2, 39, 8, 15},
	{ -4, 31,-2, 38, 8, 15},
	{  7, 32,-2, 37, 8, 15},
	{ 18, 33,-2, 36, 8, 15},
	{-15, 30,-2, 38,12, 16},
	{ -5, 30,-2, 37,12, 16},
	{  5, 30,-2, 36,12, 16},
	{ 15, 30,-2, 35,12, 16},
	{-10, 40,-2, 34,12, 16},
	{  0, 40,-2, 33,12, 16},
	{ 10, 40,-2, 32,12, 16},
	{ 20, 40,-2, 31,12, 16},
	{ -5, 50,-2, 30,12, 16},
	{  5, 50,-2, 29,12, 16},
	{ 15, 50,-2, 28,12, 16},
	{ 25, 50,-2, 27,12, 16},
	{  0, 60,-2, 26,12, 16},
	{ 10, 60,-2, 25,12, 16},
	{ 20, 60,-2, 24,12, 16},
	{ 30, 60,-2, 23,12, 16},
	{ 10, 30, 1, 40,18, 34},
	{-15, 30, 1, 39,24, 35},
	{ -4, 31, 1, 38,24, 35},
	{  7, 32, 1, 37,24, 35},
	{ 18, 33, 1, 36,24, 35},
};

static SpawnDesc kPersons[] = {
	{  0, 3, 10, 25, 16, 34 },
	{ -2, 3, 11, 25, 20, 34 },
	{  2, 3, 10, 25, 20, 34 },
	{ -2, 3, 11, 25, 28, 35 },
	{  0, 3, 12, 25, 28, 35 },
	{  2, 3, 13, 25, 28, 35 },
	{  4, 3, 14, 25, 28, 35 },
};

static void SetupScene()
{
	for (const auto& c : kCubes)
	{
		TimelineAdd(PhysicsAddCube(c.x*0.1f, c.y*0.1f, c.z, c.halfSize*0.01f, false), c.start, c.end);
	}
	for (int i = 0; i < 16; ++i)
	{
		int x = i & 3;
		int z = i >> 2;
		TimelineAdd(PhysicsAddCube(x-1.5f, -1, -z, 0.125f, true), 30, 36);
	}
	for (const auto& p : kPersons)
	{
		TimelineAdd(PhysicsAddStickPerson(p.x, p.y, p.z * 0.1f, p.halfSize * 0.1f), p.start, p.end);
	}
}

static void SimulateStuff(float t)
{
	PhysicsSim(t);
	TimelineEnableObjects(t);
}

// result of CalcProjectionMatrix(0.523599f, float(kResolutionX) / float(kResolutionY), 0.5f, 20.0f, projMatrix);
static const float kProjMatrix[16] = {
	0.974277973f, 0, 0, 0,
	0, 1.73204970f, 0, 0,
	0, 0, -1.05128205f, -1,
	0, 0, -1.02564108f, 0
};
// result of CalcViewMatrix(vec3(-20, 20, 20), shadowLookMatrix);
static const float kShadowLookMatrix[16] = {
	0.707106769f,
	0.408248246f,
	-0.577350199f,
	0,
	0,
	0.816496491f,
	0.577350199f,
	0,
	0.707106769f,
	-0.408248246f,
	0.577350199f,
	0,
	0,
	0,
	-34.6410103f,
	1
};
// result of CalcViewMatrix(vec3(0,0,5), lookMatrix);
static const float kLookMatrix[16] = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,-5,1};
// result of CalcOrthoMatrix(20.0f, 20.0f, 0.1f, 50.0f, shadowProjMatrix);
static const float kShadowProjMatrix[16] = {
	0.1f, 0, 0, 0,
	0, 0.1f, 0, 0,
	0, 0, -0.0400801599f, 0,
	-0.05f, -0.05f, -1.00400794f, 1
};

static const char* kText = "IT'S RAINING CUBES. ascentress shana tomask nearaz";
static int kTextLen = 51;

void main_entrypoint(void)
{
	QueryPerformanceFrequency(&s_TimerFrequency);

	AnimInit();
	SetupScene();

	PhysicsInit();

	DWORD args = WS_POPUP | WS_VISIBLE;
	// setup window & OpenGL
#if FINALBUILD
	ChangeDisplaySettingsA(&devMode, CDS_FULLSCREEN);
	ShowCursor(FALSE);
	args |= WS_MAXIMIZE;
#endif

	HDC hDC = GetDC(CreateWindowA("static", 0, args, 0, 0, kResolutionX, kResolutionY, 0, 0, 0, 0));

	SetPixelFormat(hDC, ChoosePixelFormat(hDC, &pfd), &pfd);
	HFONT font = CreateFont(64, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, 0, 0, 0, 0, "Impact");
	SelectObject(hDC, font);
	wglMakeCurrent(hDC, wglCreateContext(hDC));
	wglUseFontBitmaps(hDC, 0, 128, 1);
	
	gl.Initialize();
	
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);

	RenderCreateResources();

	bool playing;

	AudioInit();

	double startTime = GetTime();
	float prevTime = 0;

	do
	{
#if FINALBUILD
		SetCursorPos(kResolutionX + 8192, kResolutionY + 8192);
#endif
		PeekMessage(0, 0, 0, 0, PM_REMOVE);

		float t = (float)(GetTime() - startTime);

#if !FINALBUILD
		// Space key pauses / unpauses physics simulation
		if (GetAsyncKeyState(VK_SPACE) & 1)
			gSimulatePhysics = !gSimulatePhysics;
		if (gSimulatePhysics)
#endif
		{
			// Simulate physics (this needs to advance at constant tick rate)
			const int kMaxIters = 1;
			int iter = 0;
			while (prevTime < t)
			{
				prevTime += kPhysicsTimeStep;
				SimulateStuff(prevTime);
				++iter;
				if (iter > kMaxIters)
				{
					prevTime = t;
					break;
				}
			}
		}

#if !FINALBUILD
		if (gSimulatePhysics)
		{
#endif
		playing = AudioPlay(t);
		AnimRun(t);
#if !FINALBUILD
		}
#endif

#if !FINALBUILD
		// If we're paused, just make sure time does not _really_ advance
		if (!gSimulatePhysics)
		{
			float delta = t - prevTime;
			startTime += delta;
			prevTime = t;
		}

		if (GetAsyncKeyState(VK_CONTROL) & 1)
		{
			AnimFloorBounce(t, -1);
		}

		// Left Arrow press rewinds time by 1 second
		if (GetAsyncKeyState(VK_LEFT) & 1)
		{
			if (t > 1)
			{
				float newTime = (int)(t - 1);
				float delta = t - newTime;
				startTime += delta;
				prevTime -= delta;
				PhysicsSeekToTime(newTime);
			}
		}
		// Right Arrow press advances time by 1 second
		if (GetAsyncKeyState(VK_RIGHT) & 1)
		{
			float dur = 0;
			while (dur < 1)
			{
				prevTime += kPhysicsTimeStep;
				startTime -= kPhysicsTimeStep;
				SimulateStuff(prevTime);
				dur += kPhysicsTimeStep;
			}
		}
		// Home rewinds to beginning
		if (GetAsyncKeyState(VK_HOME) & 1)
		{
			float newTime = 0;
			float delta = t - newTime;
			startTime += delta;
			prevTime -= delta;
			PhysicsSeekToTime(newTime);
		}
#endif
		GLenum mrts[] = { GL_COLOR_ATTACHMENT0, GL_COLOR_ATTACHMENT1 };

		// Render shadowmap
		GL_CALL(gl.bindFramebuffer(GL_FRAMEBUFFER, gRenderShadowFBO));
		GL_CALL(gl.drawBuffers(1, mrts));
		GL_CALL(glViewport(0, 0, kShadowMapSize, kShadowMapSize));
		glClear(GL_DEPTH_BUFFER_BIT);
		GL_CALL(glViewport(1, 1, kShadowMapSize-2, kShadowMapSize-2));
		GL_CALL(glPolygonOffset(2.0f, 3.0f));
		GL_CALL(glEnable(GL_POLYGON_OFFSET_FILL));
		glEnable(GL_DEPTH_TEST);

		gl.useProgram(gShaderGbuffer.program);
		gl.uniformMatrix4fv(gShaderGbuffer.mP, 1, false, kShadowProjMatrix);
		gl.uniformMatrix4fv(gShaderGbuffer.mV, 1, false, kShadowLookMatrix);
		PhysicsRender();
		GL_CALL(glPolygonOffset(0, 0));


		// Render into g-buffer
		GL_CALL(gl.bindFramebuffer(GL_FRAMEBUFFER, gRenderGbufferFBO));
		GL_CALL(gl.drawBuffers(2, mrts));
		GL_CALL(glViewport(0, 0, kResolutionX, kResolutionY));
		glClearColor(1, 1, 1, 0);
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

		gl.useProgram(gShaderGbuffer.program);
		gl.uniformMatrix4fv(gShaderGbuffer.mP, 1, false, kProjMatrix);
		gl.uniformMatrix4fv(gShaderGbuffer.mV, 1, false, kLookMatrix);
		PhysicsRender();

		// Blur the G-buffer lol?
		GL_CALL(gl.drawBuffers(1, mrts));
		BlurTexture(kGLTexAlbedo, kGLTexBlurTempColor, 2, false, false);
		BlurTexture(kGLTexNormals, kGLTexBlurTempColor, 2, true, false);
		BlurTexture(kGLTexDepth, kGLTexBlurTempDepth, 5, false, true);

		// Post-processing into screen
		GL_CALL(gl.bindFramebuffer(GL_FRAMEBUFFER, 0));
		GL_CALL(glViewport(0, 0, kResolutionX, kResolutionY));
		glClearColor(0, 0, 0, 0);
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

		gl.useProgram(gShaderPostfx.program);
		for (int i = 0; i < 4; ++i)
			BindGLTexture(i, kGLTexAlbedo+i);
		gl.uniformMatrix4fv(gShaderPostfx.mP, 1, false, kProjMatrix);
		gl.uniformMatrix4fv(gShaderPostfx.mV, 1, false, kLookMatrix);
		gl.uniformMatrix4fv(gShaderPostfx.mPS, 1, false, kShadowProjMatrix);
		gl.uniformMatrix4fv(gShaderPostfx.mVS, 1, false, kShadowLookMatrix);
		GL_CALL(gl.uniform4f(gShaderPostfx.of, t, 0, 0, 0));
		glDrawArrays(GL_TRIANGLES, 0, 3);

		// draw text
		int bar = audioState.bar;
		if (bar >= 35)
		{
			gl.useProgram(0);
			GL_CALL(glColor4f(1,1,1,1));
			GL_CALL(glListBase(1));
			GL_CALL(glRasterPos3i(-1, -1, -1));
			GL_CALL(glCallLists(kTextLen, GL_UNSIGNED_BYTE, kText));
		}

		SwapBuffers(hDC);
	} while (playing && !GetAsyncKeyState(VK_ESCAPE));

	ExitProcess(0);
}
