#pragma once

#include <windows.h>
#include <GL/gl.h>
#include "glext.h"

// Debug Log extensions are not in our version of glext.h, so define manually
typedef void (APIENTRY* GLDEBUGPROC)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar* message, const void* userParam);
#define GL_DEBUG_TYPE_ERROR               0x824C
#define GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR 0x824D
#define GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR  0x824E
#define GL_DEBUG_TYPE_PORTABILITY         0x824F
#define GL_DEBUG_TYPE_PERFORMANCE         0x8250
#define GL_DEBUG_TYPE_OTHER               0x8251
#define GL_DEBUG_OUTPUT                   0x92E0
typedef void (APIENTRYP PFNGLDEBUGMESSAGECALLBACKPROC) (GLDEBUGPROC callback, const void* userParam);



struct GLFunctions
{
	void Initialize();

#define DO_GL_FUNC(prot,member,name) prot member;
#include "glfunctionslist.h"
#undef DO_GL_FUNC
};

extern GLFunctions gl;

#if !FINALBUILD
void GLCheckError();
#define GL_CALL(x) do { x; GLCheckError(); } while(0)
#else
#define GL_CALL(x) x
#endif
