#include "windows.h"
#include "mmsystem.h"
#include "mmreg.h"
#if _DEBUG
#include <iostream>
#endif

// define this if you have a multicore cpu and can spare ~10 bytes for realtime playback
// undef for sound precalc
#define USE_SOUND_THREAD

////////////////////////////////////////////////
// sound
////////////////////////////////////////////////

// some song information
#include "4klang.h"
#include "audio.h"

// MAX_SAMPLES gives you the number of samples for the whole song. we always produce stereo samples, so times 2 for the buffer
SAMPLE_TYPE	lpSoundBuffer[MAX_SAMPLES*2];  
HWAVEOUT	hWaveOut;

/////////////////////////////////////////////////////////////////////////////////
// initialized data
/////////////////////////////////////////////////////////////////////////////////

#pragma data_seg(".wavefmt")
WAVEFORMATEX WaveFMT =
{
#ifdef FLOAT_32BIT	
	WAVE_FORMAT_IEEE_FLOAT,
#else
	WAVE_FORMAT_PCM,
#endif		
    2, // channels
    SAMPLE_RATE, // samples per sec
    SAMPLE_RATE*sizeof(SAMPLE_TYPE)*2, // bytes per sec
    sizeof(SAMPLE_TYPE)*2, // block alignment;
    sizeof(SAMPLE_TYPE)*8, // bits per sample
    0 // extension not needed
};

#pragma data_seg(".wavehdr")
WAVEHDR WaveHDR = 
{
	(LPSTR)lpSoundBuffer, 
	MAX_SAMPLES*sizeof(SAMPLE_TYPE)*2,			// MAX_SAMPLES*sizeof(float)*2(stereo)
	0, 
	0, 
	0, 
	0, 
	0, 
	0
};

MMTIME MMTime = 
{ 
	TIME_SAMPLES,
	0
};

/////////////////////////////////////////////////////////////////////////////////
// Initialization
/////////////////////////////////////////////////////////////////////////////////

AudioState audioState;

#define HIT 1
#define BUSYSNARE 4
#define BUSYHAT 3
#define QUIET 4
#define BASS 5


#pragma code_seg(".initsnd")
void  AudioInit()
{
#ifdef USE_SOUND_THREAD
	// thx to xTr1m/blu-flame for providing a smarter and smaller way to create the thread :)
	CreateThread(0, 0, (LPTHREAD_START_ROUTINE)_4klang_render, lpSoundBuffer, 0, 0);
#else
	_4klang_render(lpSoundBuffer);
#endif
	waveOutOpen			( &hWaveOut, WAVE_MAPPER, &WaveFMT, NULL, 0, CALLBACK_NULL );
	waveOutPrepareHeader( hWaveOut, &WaveHDR, sizeof(WaveHDR) );
	waveOutWrite		( hWaveOut, &WaveHDR, sizeof(WaveHDR) );

	audioState.bar = -1;
	audioState.beat = -1;
}

int GetNote(int instrument)
{
	return (&_4klang_note_buffer)[((MMTime.u.sample >> 8) << 5) + 2 * instrument];
}

bool AudioPlay(float t)
{
	static float firstBeatTime;

	audioState.onBar = false;
	audioState.onBeat = false;
	audioState.onHit = false;

	// get sample position for timing
	waveOutGetPosition(hWaveOut, &MMTime, sizeof(MMTIME));

#if _DEBUG
	static float barTime = 0;
	static float beatTime = 0;
#endif

	if (t / (60 / BPM) > audioState.beat) {
		audioState.beat++;
		audioState.onBeat = true;
	}
	if (t / ((60 / BPM) * 4) > audioState.bar) {
		audioState.bar++;
		audioState.onBar = true;
	}

#if _DEBUG
	for (int i = 0; i < MAX_INSTRUMENTS; i++) {
		std::cerr << GetNote(i) << " ";
	}
	std::cerr << std::endl;
#endif

	if (audioState.bar < 17) {
		int note = GetNote(HIT);
		audioState.onHit = note != audioState.previous[HIT] && note > 0;
		audioState.previous[HIT] = note;
	} else if (audioState.bar >= 17 && audioState.bar < 25) {
		if (audioState.onBar) audioState.onHit = true;
		//int note = GetNote(QUIET);
		//audioState.onHit = note != audioState.previous[QUIET] && note > 0;
		//audioState.previous[QUIET] = note;
	} else if (audioState.bar >= 25 && audioState.bar < 30) {
		int note = GetNote(HIT);
		audioState.onHit = note != audioState.previous[HIT] && note > 0;
		audioState.previous[HIT] = note;
	} else if (audioState.bar >= 30) {
		if (audioState.onBeat) audioState.onHit = true;
		//int note = GetNote(QUIET);
		//audioState.onHit = note != audioState.previous[QUIET] && note > 0;
		//audioState.previous[QUIET] = note;
	}

#if _DEBUG
	if (audioState.onBar) {
		std::cerr << " Bar " << audioState.bar << " time " << t << " c " << t / ((60 / BPM) * 4) << std::endl;
	}

	//if (audioState.onBeat) {
	//	std::cerr << " Beat " << audioState.beat << "time " << t << " c " << t / (60 / BPM) << std::endl;
	//}
#endif


	return MMTime.u.sample < MAX_SAMPLES;
}