#version 150
in vec2 uv;
uniform sampler2D tA; // albedo
uniform sampler2D tN; // normals
uniform sampler2D tD; // depth
uniform sampler2DShadow tS; // shadowmap
uniform mat4 mP; // projection
uniform mat4 mV; // view
uniform mat4 mPS; // shadow projection
uniform mat4 mVS; // shadow view
uniform vec4 of;

/*
// "kinda proper GGX"
vec2 ggxfv(float dotLH, float ro)
{
	float alpha = ro*ro;

	// F
	float F_a, F_b;
	float dotLH5 = pow(1.0f-dotLH,5);
	F_a = 1.0f;
	F_b = dotLH5;

	// V
	float vis;
	float k = alpha/2.0f;
	float k2 = k*k;
	float invK2 = 1.0f-k2;
	vis = 1.0 / (dotLH*dotLH*invK2 + k2);

	return vec2(F_a*vis,F_b*vis);
}

float ggxd(float dotNH, float ro)
{
	float alpha = ro*ro;
	float alphaSqr = alpha*alpha;
	float pi = 3.14159f;
	float denom = dotNH * dotNH *(alphaSqr-1.0) + 1.0f;
	float D = alphaSqr/(pi * denom * denom);
	return D;
}

float ggx(vec3 N, vec3 V, vec3 L, float ro, float F0)
{
	vec3 H = normalize(V+L);

	float dotNL = clamp(dot(N,L), 0, 1);
	float dotLH = clamp(dot(L,H), 0, 1);
	float dotNH = clamp(dot(N,H), 0, 1);

	float D = ggxd(dotNH, ro);
	vec2 FV_helper = ggxfv(dotLH, ro);
	float FV = F0*FV_helper.x + (1.0f-F0)*FV_helper.y;
	float specular = dotNL * D * FV;

	return specular;
}
*/

// hey we need space, so... just Blinn-Phong!
float blinnphong(vec3 N, vec3 V, vec3 L)
{
	vec3 H = normalize(V+L);
	float dotNH = clamp(dot(N,H), 0, 1);
	return pow(dotNH, 16);
}

void main()
{
	// sample G-buffer
	float rawDepth = texture(tD, uv).r;
	vec3 albedo = texture(tA, uv).xyz;
	vec3 normal = texture(tN, uv).xyz;

	vec3 viewdir = vec3(0,0,1);
	vec3 ldir = vec3(mVS[0][2], mVS[1][2], mVS[2][2]);
	vec4 col = vec4(0);
	//float spec = ggx(normal, viewdir, ldir, 0.5, 0.8);
	float spec = blinnphong(normal, viewdir, ldir);
	float nl = dot(normal, ldir) * 0.5 + 0.5;
	col.rgb = nl * (albedo + spec * vec3(1.0,0.9,0.6));

	// shadowmap
	vec4 projPos = vec4(uv*2-1, rawDepth*2-1, 1);
	vec4 viewSpacePos = inverse(mP) * projPos;
	vec4 worldSpacePos = inverse(mV) * viewSpacePos;
	vec4 shadowSpacePos = mPS * mVS * worldSpacePos;
	shadowSpacePos.xyz /= shadowSpacePos.w;
	shadowSpacePos.xyz = shadowSpacePos.xyz * 0.5 + 0.5;
	float shadow = texture(tS, vec3(shadowSpacePos.xy, shadowSpacePos.z-0.0)) * 0.4 + 0.6;
	col = col * shadow;

	// vignette
	vec2 u = uv;
	u *= 1.-uv;

	// one bar is 60/BPM*4, BPM=128 so bar=1.875sec
	// start fadeout at bar 35 so: 67.5sec
	float a = max(1-smoothstep(0, 0.4, of.x), smoothstep(65.625,67.5, of.x));
	float pw = mix(.25, 30, a);
	float vig = pow(u.x*u.y*15.,pw);

	// fog
	col += pow(rawDepth,64);

	gl_FragColor = col * vig;
}
