#version 130
uniform mat4 mP; // projection
uniform mat4 mV; // view
out vec3 C;
out vec3 N;
// https://iquilezles.org/www/articles/palettes/palettes.htm
vec3 ColorPalette1(float t)
{
	vec3 a = vec3(0.5, 0.5, 0.5);
	vec3 b = vec3(0.5, 0.5, 0.5);
	vec3 c = vec3(1.0, 1.0, 1.0);
	vec3 d = vec3(0.0, 0.33, 0.67);
	return a + b * cos(6.2832 * (c * t + d));
}
void main()
{	
	gl_Position = mP * mV * gl_Vertex;
	C = ColorPalette1(gl_Color.w);
	N = gl_Color.xyz;
}
