#ifndef __DEVICEINTERFACEI_H__
#define __DEVICEINTERFACEI_H__

#include "PajaTypes.h"

namespace PajaSystem {

	//! Device interface.
	/*!	Device interface is the base class interface for all devices the effects in
		Demopaja system can use.

		Work in progress. This interface will change in the future when
		the complete driver system is implemented.
	*/
	class DeviceInterfaceI
	{
	public:
		//! Default constructor.
		DeviceInterfaceI();
		//! Default destructor.
		virtual ~DeviceInterfaceI();

		//! Returns the type if the interface.
		/*!	This type i the same type that is used to query the interface.
		*/
		virtual PajaTypes::uint32	get_type() const = 0;
	};

}; // namespace

#endif // __DEVICEINTERFACEI_H__