//
// Demopaja player
//
// This application demostrates how to play the files created with Demopaja,
// and how to compile the plugins inside the executable.
//

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include "res/resource.h"
#include "DemopajaPlayerC.h"
#include "FileIO.h"

// Effects
#include "..\ImagePlugin\ImagePlugin.h"
#include "..\EnginePlugin\EnginePlugin.h"

using namespace FileIO;


// Globals.
bool		g_bFullscreen = false;


// Init dialog proc.
BOOL CALLBACK
InitDlgProc( HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	switch( uMsg ) {

	case WM_INITDIALOG:
		{
			// set fullscreen as checked
			::CheckDlgButton( hwndDlg, IDC_CHECK, BST_CHECKED );
			return TRUE;
		}
		break;

	case WM_COMMAND:
		{
			WORD	wNotifyCode = HIWORD(wParam);	// notification code 
			WORD	wID = LOWORD(wParam);			// item, control, or accelerator identifier 
			HWND	hwndCtl = (HWND)lParam;			// handle of control 

			if( wNotifyCode == BN_CLICKED ) {
				if( wID == IDOK ) {
					if( IsDlgButtonChecked( hwndDlg, IDC_CHECK ) == BST_CHECKED )
						g_bFullscreen = true;
					else
						g_bFullscreen = false;

					EndDialog( hwndDlg, IDOK );
				}
				else if( wID == IDCANCEL )
					EndDialog( hwndDlg, IDCANCEL );
			}
		}

	default:
		return FALSE;
		break;
	}
}
 



int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{

	// Show init dialog.
	if( DialogBox( hInstance, MAKEINTRESOURCE( IDD_INIT ), NULL, InitDlgProc ) != IDOK ) {
		return 0;
	}

	DemopajaPlayerC	rPlayer;

	// Load plugins.
	rPlayer.load_plugins( "plugins" );

	// Register internal effects
	rPlayer.register_plugin( &g_rImageDesc );
	rPlayer.register_plugin( &g_rPCXImportDesc );
	rPlayer.register_plugin( &g_rEngineDesc );
	rPlayer.register_plugin( &g_rASEImportDesc );

	// Load demo.
	if( rPlayer.load_demo( "demo.dmo" ) != IO_OK ) {
		MessageBox( NULL, "Loading demo failed.", "Error!", MB_ICONSTOP | MB_OK );
		return -1;
	}

	//Run demo.
	return rPlayer.run( hInstance, g_bFullscreen );
}
