

Demo.prototype.addEffectStarfield = function (startTime, durationTime, amountOfParticles, texture, areaSize, particleSize) {


  const recalcThreshold = 0.1;

  let stars = new Array(amountOfParticles);
  const size = areaSize;
  for (let i = 0; i < stars.length; i++) {
    let z1 = Math.random()
    stars[i] = {
      "x1": Math.random()*size*2-size,
      "y1": Math.random()*size*2-size,
      "z1": z1,
      "z2": z1+1.0
    };
  }

  this.loader.addAnimation({
    "start":startTime, "duration":durationTime,
    "image": texture,
    textureProperties: [{},{minFilter: 'NearestMipmapNearestFilter', magFilter: 'LinearFilter'}],
    "perspective": "3d",
    "billboard": true,
    "additive": true,
    "scale":[{"uniform3d":.1}],
    "angle":[{"degreesZ":()=>20*getSceneTimeFromStart(),"degreesY":()=>.05*getSceneTimeFromStart(),"degreesX":()=>.03*getSceneTimeFromStart()}],
    "instancer": {
      "count": stars.length,
      "runInstanceFunction": (properties) => {

        const i = properties.index;
        const count = properties.count;
        const time = properties.time;
        let object = properties.object;
        let color = properties.color;

        const scale = particleSize;
        object.scale.x = scale;
        object.scale.y = scale;
        object.scale.z = scale;   

        const percent = (getSceneTimeFromStart()*.5)%1.0;
        object.position.z = (Utils.mix(stars[i].z1, stars[i].z2, percent)%1.0)*size*2-size;;
        object.position.x = stars[i].x1;
        object.position.y = stars[i].y1;
        //object.position.z = stars[i].z1*size*2-size;

        }
      }
    
  });
}