#if 0
The MIT License (MIT)

Copyright (c) 2014 inmensabolademanteca@gmail.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
#endif

; ----------------------------------------------------------------------------
; CIDLESA's Altair arcade (1981) port to the ZX Spectrum.
;
; Interrupt. Sound and music.
; ----------------------------------------------------------------------------

;C 261.63
;C# 277.18
;D 293.66
;D# 311.13
;E 329.63
;F 349.23
;F# 369.99
;G 392.00
;G# 415.30
;A 440.00
;A# 466.16
;B 493.88

C4	.equ 1642
CS4	.equ 1548
D4	.equ 1460
DS4	.equ 1376
E4	.equ 1297
F4	.equ 1223
FS4	.equ 1152
G4	.equ 1086
GS4	.equ 1023
A4	.equ 964
AS4	.equ 908
B4	.equ 856

song_on	.db 0
songp	.dw song2_h
songt0	.db 8
songt	.db 8

song2_h	.db 8
song2_d	.dw E4, E4, E4/2, E4/2, 1, 1, 1, 1, 1,
	.dw 0, song2_d

songb_h	.db 4
songb_d .dw E4/4, E4/2, E4/3, E4/4, E4/3, E4/2
	.dw B4, C4*2, D4/2, G4, G4/3, G4/2, A4/3
	.dw E4, B4/3, FS4, FS4/3, FS4/2, C4, C4/3
	.dw 0, songb_d

songb2_h	.db 13
songb2_d	.dw C4, C4/2, C4/3, 1, 0, songb2_d

SHOT_SND_START	.equ 100
SHOT_SND_DELTA	.equ 25
shot_snd	.dw 0
shot_snd_ob	.dw 0

snd_on	.db 0
snd_fun	.dw 0

interrupt
	di
	push af
	push bc
	push de
	push hl
	push ix

; If no effect, go to music.

	ld a,(snd_on)
	or a
	jr z,music

; Execute sound.

	ld hl,(snd_fun)
	call jphl

music

; Check if music on.

	ld a,(song_on)
	or a
	jr z,interrupt_end

; Song speed.

	ld hl,songt
	dec (hl)
	jr nz,interrupt_end

; Reset speed counter.

	ld a,(songt0)
	ld (hl),a

play

; Get note.

	ld hl,(songp)
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (songp),hl

; If 1 is a silence.

	ld a,e
	cp 1
	jr z,chk_silence

; If 0, next comes an address to resume.

	or d
	jr z,dacapo

play_note

; If sound effect, it has priority.

	ld a,(snd_on)
	or a
	jr nz,interrupt_end

; Play note.

	ex de,hl
	ld de,4
	call beep
	jr interrupt_end

chk_silence
	cp d
	jr z,play_note
	jr interrupt_end

dacapo
	ld e,(hl)
	inc hl
	ld d,(hl)
	ld hl,songp
	ld (songp),de
	jr play

interrupt_end
	pop ix
	pop hl
	pop de
	pop bc
	pop af
	ei
	reti

; ----------
; 'stop_snd'
; ----------

stop_snd
	xor a
	ld (snd_on),a
	ret

; ----------------
; 'start_shot_snd'
; ----------------
;
; In	IX shot object.

start_shot_snd
	ld (shot_snd_ob),ix
	ld hl,SHOT_SND_START
	ld (shot_snd),hl
	ld a,1
	ld (snd_on),a
	ld hl,shot_snd_f
	ld (snd_fun),hl
	ret

; ------------
; 'shot_snd_f'
; ------------

shot_snd_f

; Set duration; if sound too long, set minimum duration.

	ld hl,(shot_snd)
	push hl
	ld de,1
	ld a,2
	cp h
	jr nc,shot_snd_beep
	dec de

shot_snd_beep
	call beep
	pop hl

	ld bc,SHOT_SND_DELTA
	add hl,bc
	ld (shot_snd),hl
	ret

; ---------------
; 'start_die_snd'
; ---------------

die_snd	.dw 0

start_die_snd
	ld hl,1
	ld (die_snd),hl
	ld hl,die_snd_f
	ld (snd_fun),hl
	ld a,1
	ld (snd_on),a
	ret

die_snd_f
	ld hl,(die_snd)
	ld a,5
	cp h
	jr nc,die_snd_f_play
	call stop_snd
	ret
die_snd_f_play
	push hl
	ld de,1
	call beep
	pop hl
	ld bc,25
	add hl,bc
	ld (die_snd),hl
	add hl,bc
	ld de,1
	call beep
	ret

; ------------
; 'start_song'
; ------------
;
; In	HL song header + data.

start_song
	ld a,(hl)
	ld (songt0),a
	inc hl
	ld (songp),hl
	ld a,1
	ld (song_on),a
	ld (songt),a
	ret

stop_song
	xor a
	ld (song_on),a
	ret

stop_all_snd
	call stop_snd
	call stop_song
	ret

start_songb
	push af
	push hl
	ld hl,songb_h
	call start_song
	pop hl
	pop af
	ret

start_songb2
	push af
	push hl
	ld hl,songb2_h
	call start_song
	pop hl
	pop af
	ret

; ------
; 'beep'
; ------
; 	This is the rom BEEPER routine, but I don't like it to enable
; interrupts at end...

beep	push ix
	ld a,l
	srl l
	srl l
	cpl
	and $03
	ld c,a
	ld b,0
	ld ix,beep1
	add ix,bc
	ld a,($5c48)
	and $38
	rrca
	rrca
	rrca
	or $08
beep1	nop
	nop
	nop
	inc b
	inc c
beep5	dec c
	jr nz,beep5
	ld c,$3f
	dec b
	jp nz,beep5
	xor $10
	out ($fe),a
	ld b,h
	ld c,a
	bit 4,a
	jr nz,beep6
	ld a,d
	or e
	jr z,beep7
	ld a,c
	ld c,l
	dec de
	jp (ix)
beep6	ld c,l
	inc c
	jp (ix)
beep7	pop ix
	ret

