
// --- Ring Tunnel.
//  Copyright (c) 2000. Remage / Fresh!mindworkz.

Object Ringt;

#define RT1 64
#define RT2 32

float 
  RTX[8] = { 8.0f, 7.8f, 7.2f, 7.0f, 7.0f, 7.2f, 7.8f, 8.0f },
  RTY[8] = { -1.0f, -1.2f, -1.2f, -1.0f, 1.0f, 1.2f, 1.2f, 1.0f };

int RTS[1024], RTT[1024];

void Ringt_Init( void )
  {
    int I, J, K;

    Ringt.NumVects = RT1*RT2*8;
    if (( Ringt.Vects = (Vect*) malloc( Ringt.NumVects * sizeof( Vect ))) == NULL )
      PostQuitMessage( 0 );
    Ringt.NumFaces = RT1*RT2*8;
    if (( Ringt.Faces = (Face*) malloc( Ringt.NumFaces * sizeof( Face ))) == NULL )
      PostQuitMessage( 0 );

    V = 0;
    F = 0;
    for ( J = 0; J < RT2; J++ )
      for ( I = 0; I < RT1; I++ )
        for ( K = 0; K < 8; K++ )
          {
            Vertex( &Ringt.Vects[ V++ ], RTX[K] * Fsin( I*2*Pi / RT1 ), RTX[K] * Fcos( I*2*Pi / RT1 ), 4 * ( J-15.5f ) + RTY[K] );
            
            Ringt.Faces[ F ].Type = 4;
            Ringt.Faces[ F ].A = J*8*RT1 + I*8 + K;
            Ringt.Faces[ F ].B = J*8*RT1 + I*8 + ((K+1)&7);
            Ringt.Faces[ F ].C = J*8*RT1 + ((I+1)&(RT1-1))*8 + ((K+1)&7);
            Ringt.Faces[ F ].D = J*8*RT1 + ((I+1)&(RT1-1))*8 + K;
            Ringt.Faces[ F ].pA = &Ringt.Vects[ J*8*RT1 + I*8 + K ];
            Ringt.Faces[ F ].pB = &Ringt.Vects[ J*8*RT1 + I*8 + ((K+1)&7) ];
            Ringt.Faces[ F ].pC = &Ringt.Vects[ J*8*RT1 + ((I+1)&(RT1-1))*8 + ((K+1)&7) ];
            Ringt.Faces[ F ].pD = &Ringt.Vects[ J*8*RT1 + ((I+1)&(RT1-1))*8 + K ];
            Ringt.Faces[ F ].ColR = 0.275f * ( 1.0f + 0.2f * Fsin( K*Pi/4 + 0.13f ));
            Ringt.Faces[ F ].ColG = 0.253f * ( 1.0f + 0.2f * Fsin( K*Pi/4 + 0.13f ));
            Ringt.Faces[ F ].ColB = 0.361f * ( 1.0f + 0.2f * Fsin( K*Pi/4 + 0.13f ));
            Ringt.Faces[ F ].ColA = 2/5* ( J - RT2/2 ) / RT2;
            if ( Ringt.Faces[ F ].ColA > 1.0f ) Ringt.Faces[ F ].ColA = 1.0f;
            Ringt.Faces[ F ].ColA = 1.0f - Ringt.Faces[ F ].ColA;
            F++;
           }
    for ( I = 0; I < 1024; I++ )
      { 
        RTS[I] = Rand() & 63;
        RTT[I] = ( RTS[I] + 8 + ( Rand()&31 )) & 63;
       }
   }

void Ringt_Draw( float Timer )
  {
    int I, J, K, S, T, i;

    Camp.X = 4.5f*Fcos( Timer*0.000348f ); // 0.00029f
    Camp.Y = 4.5f*Fsin( Timer*0.00132f ); // 0.0011f
    Camp.Z = 3.0f*Fsin( Timer*0.001128f ); // 0.00094f

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluPerspective( 90.0f, 640.0f / 360.0f, 1.0f, 100.0f ); 

    gluLookAt( Camp.X, Camp.Y, Camp.Z, 2.0f * Fsin( Timer*0.005f ), 2.0f * Fcos( Timer*0.0037f ), 4.0f*Fsin( Timer*0.0031f ), 0.0f, 1.0f, 0.0f );

    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

    for ( J = 0; J < RT2; J++ )
      {
        S = RTS[ J + Trunc( Timer/60.0f ) ];
        T = RTT[ J + Trunc( Timer/60.0f ) ];
        if ( S>T ) T += 64;

        for ( I = S; I < T; I++ )
          {
            for ( K = 0; K < 8; K++ )
              {
                i = J*RT1*8 + (I&(RT1-1))*8 +K;

                  TDX = Ringt.Faces[ i ].pA->X - Camp.X;
                  TDY = Ringt.Faces[ i ].pA->Y - Camp.Y;
                  TDZ = Ringt.Faces[ i ].pA->Z - Camp.Z - 4.0f * Frac( Timer/60.0f );
                  TCDist = Fsqrt( TDX*TDX + TDY*TDY + TDZ*TDZ ) * 0.044f;
                  if ( TCDist > 1.0f ) TCDist = 1.0f;
                Ringt.Faces[ i ].Shade = Ringt.Faces[ i ].ColA * ( 1.0f - TCDist );

                glColor4f( 
                  BackR + (Ringt.Faces[ i ].ColR-BackR) * Ringt.Faces[ i ].Shade * GlobalShade, 
                  BackG + (Ringt.Faces[ i ].ColG-BackG) * Ringt.Faces[ i ].Shade * GlobalShade,
                  BackB + (Ringt.Faces[ i ].ColB-BackB) * Ringt.Faces[ i ].Shade * GlobalShade, Ringt.Faces[ i ].ColA );
                glBegin( GL_QUADS ); 
                  glVertex3f( Ringt.Faces[ i ].pA->X, Ringt.Faces[ i ].pA->Y, Ringt.Faces[ i ].pA->Z - 4.0f * Frac( Timer/60.0f ));
                  glVertex3f( Ringt.Faces[ i ].pB->X, Ringt.Faces[ i ].pB->Y, Ringt.Faces[ i ].pB->Z - 4.0f * Frac( Timer/60.0f ));
                  glVertex3f( Ringt.Faces[ i ].pC->X, Ringt.Faces[ i ].pC->Y, Ringt.Faces[ i ].pC->Z - 4.0f * Frac( Timer/60.0f ));
                  glVertex3f( Ringt.Faces[ i ].pD->X, Ringt.Faces[ i ].pD->Y, Ringt.Faces[ i ].pD->Z - 4.0f * Frac( Timer/60.0f ));
                glEnd();
               }
           }

        i = J*RT1*8 + (S&(RT1-1))*8;

        glColor4f( 
          BackR + (Ringt.Faces[ i ].ColR-BackR) * Ringt.Faces[ i ].Shade * GlobalShade, 
          BackG + (Ringt.Faces[ i ].ColG-BackG) * Ringt.Faces[ i ].Shade * GlobalShade,
          BackB + (Ringt.Faces[ i ].ColB-BackB) * Ringt.Faces[ i ].Shade * GlobalShade, Ringt.Faces[ i ].ColA );
        glBegin( GL_QUADS ); 
          glVertex3f( Ringt.Vects[ i+0 ].X, Ringt.Vects[ i+0 ].Y, Ringt.Vects[ i+0 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+1 ].X, Ringt.Vects[ i+1 ].Y, Ringt.Vects[ i+1 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+2 ].X, Ringt.Vects[ i+2 ].Y, Ringt.Vects[ i+2 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+3 ].X, Ringt.Vects[ i+3 ].Y, Ringt.Vects[ i+3 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+3 ].X, Ringt.Vects[ i+3 ].Y, Ringt.Vects[ i+3 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+4 ].X, Ringt.Vects[ i+4 ].Y, Ringt.Vects[ i+4 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+7 ].X, Ringt.Vects[ i+7 ].Y, Ringt.Vects[ i+7 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+0 ].X, Ringt.Vects[ i+0 ].Y, Ringt.Vects[ i+0 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+4 ].X, Ringt.Vects[ i+4 ].Y, Ringt.Vects[ i+4 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+5 ].X, Ringt.Vects[ i+5 ].Y, Ringt.Vects[ i+5 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+6 ].X, Ringt.Vects[ i+6 ].Y, Ringt.Vects[ i+6 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+7 ].X, Ringt.Vects[ i+7 ].Y, Ringt.Vects[ i+7 ].Z - 4.0f * Frac( Timer/60.0f ));
        glEnd();

        i = J*RT1*8 + (T&(RT1-1))*8;

        glColor4f( 
          BackR + (Ringt.Faces[ i-8 ].ColR-BackR) * Ringt.Faces[ i-8 ].Shade * GlobalShade, 
          BackG + (Ringt.Faces[ i-8 ].ColG-BackG) * Ringt.Faces[ i-8 ].Shade * GlobalShade,
          BackB + (Ringt.Faces[ i-8 ].ColB-BackB) * Ringt.Faces[ i-8 ].Shade * GlobalShade, Ringt.Faces[ i-8 ].ColA );
        glBegin( GL_QUADS ); 
          glVertex3f( Ringt.Vects[ i+0 ].X, Ringt.Vects[ i+0 ].Y, Ringt.Vects[ i+0 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+1 ].X, Ringt.Vects[ i+1 ].Y, Ringt.Vects[ i+1 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+2 ].X, Ringt.Vects[ i+2 ].Y, Ringt.Vects[ i+2 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+3 ].X, Ringt.Vects[ i+3 ].Y, Ringt.Vects[ i+3 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+3 ].X, Ringt.Vects[ i+3 ].Y, Ringt.Vects[ i+3 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+4 ].X, Ringt.Vects[ i+4 ].Y, Ringt.Vects[ i+4 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+7 ].X, Ringt.Vects[ i+7 ].Y, Ringt.Vects[ i+7 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+0 ].X, Ringt.Vects[ i+0 ].Y, Ringt.Vects[ i+0 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+4 ].X, Ringt.Vects[ i+4 ].Y, Ringt.Vects[ i+4 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+5 ].X, Ringt.Vects[ i+5 ].Y, Ringt.Vects[ i+5 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+6 ].X, Ringt.Vects[ i+6 ].Y, Ringt.Vects[ i+6 ].Z - 4.0f * Frac( Timer/60.0f ));
          glVertex3f( Ringt.Vects[ i+7 ].X, Ringt.Vects[ i+7 ].Y, Ringt.Vects[ i+7 ].Z - 4.0f * Frac( Timer/60.0f ));
        glEnd();

       }
   }