
#include <Windows.h>
#include <D3DX8.h>

#include "Main.h"
#include "Fmath.h"

extern float Fpow( float Value, float Exp );

#include "Synth.h"

// ------------------------------------------------------------------------------------------------

SYNTH_BUFFER *Buf1, *Buf2;

//  --- "Hihat01b.wav" ( Length = 0.4f ).

SYNTH_CONTROL Hihat1_FreqCtrl1 = { SYNTH_CTRL_FLOAT, { 10000.0f }};
SYNTH_CONTROL Hihat1_AmplCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.015f, 1.0f, 0.045f, 1.0f, 0.06f, 0.0f, 0.4f, 0.0f }};
SYNTH_CONTROL Hihat1_DistCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL Hihat1_PanCtrl1 = { SYNTH_CTRL_FLOAT, { 0.5f }};

SYNTH_CONTROL Hihat1_CutoffCtrl1 = { SYNTH_CTRL_FLOAT, { 3500.0f }};
SYNTH_CONTROL Hihat1_ResoCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL Hihat1_DryWetCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Hihat1_CutoffCtrl2 = { SYNTH_CTRL_FLOAT, { 18500.0f }}; // 19000
SYNTH_CONTROL Hihat1_ResoCtrl2 = { SYNTH_CTRL_FLOAT, { 0.4f }}; // 0.1f
SYNTH_CONTROL Hihat1_DryWetCtrl2 = { SYNTH_CTRL_FLOAT, { 0.75f }}; // 0.6f

SYNTH_CONTROL Hihat1_RoomSizeCtrl3 = { SYNTH_CTRL_FLOAT, { 0.1f }};
SYNTH_CONTROL Hihat1_WidthCtrl3 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Hihat1_DampCtrl3 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL Hihat1_FeedBackCtrl3 = { SYNTH_CTRL_FLOAT, { 0.01f }};
SYNTH_CONTROL Hihat1_DryWetCtrl3 = { SYNTH_CTRL_FLOAT, { 0.3f }};

// --- "Reson4.wav" ( Length = 2.0f ).

SYNTH_CONTROL Reson4_FreqCtrl1 = { SYNTH_CTRL_FLOAT, { 110.0f }};
SYNTH_CONTROL Reson4_AmplCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL Reson4_PanCtrl1 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.01f, 2.0f }};
SYNTH_CONTROL Reson4_DistCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Reson4_FreqCtrl2 = { SYNTH_CTRL_FLOAT, { 110.4f }};
SYNTH_CONTROL Reson4_AmplCtrl2 = { SYNTH_CTRL_FLOAT, { 0.4f }};
SYNTH_CONTROL Reson4_PanCtrl2 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.01f, 2.0f }};
SYNTH_CONTROL Reson4_DistCtrl2 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Reson4_DelayCtrl5 = { SYNTH_CTRL_LFO_SINE, { 0.020f, 0.001f, 1.2f }};
SYNTH_CONTROL Reson4_FeedBackCtrl5 = { SYNTH_CTRL_FLOAT, { 0.1f }};
SYNTH_CONTROL Reson4_DryWetCtrl5 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Reson4_CutoffCtrl6 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1000.0f, 2.0f, 100.0f }};
SYNTH_CONTROL Reson4_ResoCtrl6 = { SYNTH_CTRL_FLOAT, { 0.7f }};
SYNTH_CONTROL Reson4_DryWetCtrl6 = { SYNTH_CTRL_FLOAT, { 0.7f }};

SYNTH_CONTROL Reson4_DistCtrl7 = { SYNTH_CTRL_FLOAT, { 9.2f }};
SYNTH_CONTROL Reson4_DryWetCtrl7 = { SYNTH_CTRL_FLOAT, { 0.8f }};

// --- "Snare03c.wav" ( Length = 1.176f ).

SYNTH_CONTROL Snare3_FreqCtrl1 = { SYNTH_CTRL_ENV_LOG, { 110.0f, 220.0f, 0.000588f, 0.026588f, 2.0f }};
SYNTH_CONTROL Snare3_AmplCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.000588f, 0.0f, 0.001176f, 1.0f, 0.101176f, 0.0f, 1.176f, 0.0f }};
SYNTH_CONTROL Snare3_DistCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL Snare3_PanCtrl1 = { SYNTH_CTRL_FLOAT, { 0.5f }};

SYNTH_CONTROL Snare3_CutoffCtrl1 = { SYNTH_CTRL_ENV_LOG, { 11730.0f, 20000.0f, 0.000588f, 0.016588f, 2.0f }};
SYNTH_CONTROL Snare3_ResoCtrl1 = { SYNTH_CTRL_FLOAT, { 0.6f }};
SYNTH_CONTROL Snare3_DryWetCtrl1 = { SYNTH_CTRL_FLOAT, { 0.7f }};

SYNTH_CONTROL Snare3_CutoffCtrl2 = { SYNTH_CTRL_FLOAT, { 8000.0f }};
SYNTH_CONTROL Snare3_ResoCtrl2 = { SYNTH_CTRL_FLOAT, { 5.0f }};
SYNTH_CONTROL Snare3_DryWetCtrl2 = { SYNTH_CTRL_FLOAT, { 0.6f }};

SYNTH_CONTROL Snare3_RoomSizeCtrl1 = { SYNTH_CTRL_FLOAT, { 0.1f }};
SYNTH_CONTROL Snare3_WidthCtrl1 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Snare3_DampCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL Snare3_FeedBackCtrl1 = { SYNTH_CTRL_FLOAT, { 0.01f }};
SYNTH_CONTROL Snare3_DryWetCtrl3 = { SYNTH_CTRL_FLOAT, { 0.4f }};

// --- "Snare05c.wav" ( Length = 1.176f ).

SYNTH_CONTROL Snare5_FreqCtrl1 = { SYNTH_CTRL_ENV_LOG, { 110.0f, 220.0f, 0.000588f, 0.026588f, 2.0f }};
SYNTH_CONTROL Snare5_AmplCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.000588f, 0.0f, 0.001176f, 0.5f, 0.101176f, 0.0f, 1.176f, 0.0f }};
SYNTH_CONTROL Snare5_AmplCtrl2 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.000588f, 0.0f, 0.001176f, 0.4f, 0.101176f, 0.0f, 1.176f, 0.0f }};
SYNTH_CONTROL Snare5_DistCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL Snare5_PanCtrl1 = { SYNTH_CTRL_FLOAT, { 0.5f }};

SYNTH_CONTROL Snare5_CutoffCtrl1 = { SYNTH_CTRL_ENV_LOG, { 6730.0f, 9000.0f, 0.000588f, 0.016588f, 2.0f }};
SYNTH_CONTROL Snare5_ResoCtrl1 = { SYNTH_CTRL_FLOAT, { 0.6f }};
SYNTH_CONTROL Snare5_DryWetCtrl1 = { SYNTH_CTRL_FLOAT, { 0.7f }};

SYNTH_CONTROL Snare5_CutoffCtrl2 = { SYNTH_CTRL_FLOAT, { 8000.0f }};
SYNTH_CONTROL Snare5_ResoCtrl2 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Snare5_DryWetCtrl2 = { SYNTH_CTRL_FLOAT, { 0.5f }};

SYNTH_CONTROL Snare5_RoomSizeCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.6f, 0.100588f, 0.1f, 0.279588f, 0.0f, 1.176f, 0.0f }};
SYNTH_CONTROL Snare5_WidthCtrl1 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Snare5_DampCtrl1 = { SYNTH_CTRL_FLOAT, { 1.7f }};
SYNTH_CONTROL Snare5_FeedBackCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.6f, 0.100588f, 0.1f, 0.279588f, 0.0f, 1.176f, 0.0f }};
SYNTH_CONTROL Snare5_DryWetCtrl3 = { SYNTH_CTRL_FLOAT, { 0.4f }};

// --- "Bdrum01b.wav" ( Length = 1.47f ).

SYNTH_CONTROL Bdrum1_FreqCtrl1 = { SYNTH_CTRL_ENV_LOG, { 5200.0f, 5.625f, 0.0f, 0.2352f, 0.009f }};
SYNTH_CONTROL Bdrum1_DistCtrl1 = { SYNTH_CTRL_FLOAT, { 0.99f }};
SYNTH_CONTROL Bdrum1_AmplCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.000588f, 1.5f, 0.0588f, 1.0f, 0.2352f, 1.0f, 0.7056f, 0.0f, 1.47f, 0.0f }};
SYNTH_CONTROL Bdrum1_PanCtrl1 = { SYNTH_CTRL_FLOAT, { 0.5f }};

SYNTH_CONTROL Bdrum1_FreqCtrl2 = { SYNTH_CTRL_ENV_LOG, { 1080.0f, 60.0f, 0.0f, 0.1176f, 0.0126f }};
SYNTH_CONTROL Bdrum1_DistCtrl2 = { SYNTH_CTRL_FLOAT, { 0.2f }};
SYNTH_CONTROL Bdrum1_AmplCtrl2 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.0f, 0.0f, 0.000588f, 0.05f, 0.04704f, 0.01f, 0.0588f, 0.0f, 1.47f, 0.0f }};

SYNTH_CONTROL Bdrum1_CutoffCtrl1 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Bdrum1_ResoCtrl1 = { SYNTH_CTRL_FLOAT, { 0.01f }};
SYNTH_CONTROL Bdrum1_DryWetCtrl1 = { SYNTH_CTRL_FLOAT, { 0.0f }};

SYNTH_CONTROL Bdrum1_RoomSizeCtrl3 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.1f, 1.40f, 0.1f, 1.47f, 0.0f }};
SYNTH_CONTROL Bdrum1_WidthCtrl3 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Bdrum1_DampCtrl3 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL Bdrum1_FeedBackCtrl3 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.01f, 1.40f, 0.01f, 1.47f, 0.0f }};
SYNTH_CONTROL Bdrum1_DryWetCtrl3 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.4f, 1.40f, 0.4f, 1.47f, 0.0f }};

// --- "String03.wav" ( Length = 8.0f ).

SYNTH_CONTROL String3_FreqCtrl1 = { SYNTH_CTRL_LFO_SINE, { 440.0f, 0.6f, 0.4f }};
SYNTH_CONTROL String3_FreqCtrl1Det = { SYNTH_CTRL_LFO_SINE, { 442.0f, -0.6f, 0.7f }};
SYNTH_CONTROL String3_AmplCtrl1 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 0.0f, 0.0f, 0.0f, 0.16f, 0.7f, 2.4f, 0.4f, 4.0f, 0.5f, 4.8f, 0.0f, 6.4f, 0.0f, 8.0f, 0.0f, 8.0f, 0.0f }};
SYNTH_CONTROL String3_PanCtrl1 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.04f, 2.0f }};

SYNTH_CONTROL String3_FreqCtrl2 = { SYNTH_CTRL_LFO_SINE, { 880.0f, 1.2f, 0.3f }};
SYNTH_CONTROL String3_AmplCtrl2 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 0.0f, 0.0f, 0.0f, 0.16f, 0.3f, 2.4f, 0.5f, 4.0f, 0.2f, 4.8f, 0.0f, 6.4f, 0.0f, 8.0f, 0.0f, 8.0f, 0.0f }};
SYNTH_CONTROL String3_PanCtrl2 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.05f, 1.9f }};

SYNTH_CONTROL String3_FreqCtrl3 = { SYNTH_CTRL_LFO_SINE, { 1320.0f, 3.8f, 0.41f }};
SYNTH_CONTROL String3_AmplCtrl3 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 0.0f, 0.0f, 0.0f, 0.16f, 0.3f, 2.4f, 0.28f, 4.0f, 0.04f, 4.8f, 0.0f, 6.4f, 0.0f, 8.0f, 0.0f, 8.0f, 0.0f }};
SYNTH_CONTROL String3_PanCtrl3 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.05f, 0.9f }};

SYNTH_CONTROL String3_AmplCtrl4 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.04f, 0.1f, 0.8f, 0.1f, 2.0f, 0.04f, 2.8f, 0.0f, 8.0f, 0.0f }};

SYNTH_CONTROL String3_CutoffCtrl1 = { SYNTH_CTRL_LFO_SINE, { 3420.0f, 2240.0f, 0.7f }};
SYNTH_CONTROL String3_ResoCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.5f, 8.0f, 0.3f }};
SYNTH_CONTROL String3_DryWetCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};

SYNTH_CONTROL String3_CutoffCtrl2 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 1300.0f, 0.0f, 1300.0f, 8.0f, 60.0f, 8.0f, 60.0f }};
SYNTH_CONTROL String3_ResoCtrl2 = { SYNTH_CTRL_FLOAT, { 0.5f }};
SYNTH_CONTROL String3_DryWetCtrl2 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL String3_DistCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1.9f, 8.0f, 0.7f }};

SYNTH_CONTROL String3_RoomSizeCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL String3_WidthCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL String3_DampCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL String3_FeedBackCtrl1 = { SYNTH_CTRL_FLOAT, { 0.7f }};
SYNTH_CONTROL String3_DryWetCtrl3 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL String3_DelayCtrl4 = { SYNTH_CTRL_LFO_SINE, { 0.020f, 0.007f, 0.7f }};
SYNTH_CONTROL String3_FeedBackCtrl4 = { SYNTH_CTRL_FLOAT, { 0.6f }};
SYNTH_CONTROL String3_DryWetCtrl4 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// --- "Reson2.wav" ( Length = 2.0f ).

SYNTH_CONTROL Reson2_FreqCtrl1 = { SYNTH_CTRL_FLOAT, { 110.0f }};
SYNTH_CONTROL Reson2_AmplCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL Reson2_PanCtrl1 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.01f, 2.0f }};
SYNTH_CONTROL Reson2_DistCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Reson2_FreqCtrl2 = { SYNTH_CTRL_FLOAT, { 110.4f }};
SYNTH_CONTROL Reson2_AmplCtrl2 = { SYNTH_CTRL_FLOAT, { 0.4f }};
SYNTH_CONTROL Reson2_PanCtrl2 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.01f, 1.7f }};
SYNTH_CONTROL Reson2_DistCtrl2 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Reson2_FreqCtrl3 = { SYNTH_CTRL_FLOAT, { 55.0f }};
SYNTH_CONTROL Reson2_AmplCtrl3 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL Reson2_PanCtrl3 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.01f, 1.6f }};
SYNTH_CONTROL Reson2_DistCtrl3 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Reson2_FreqCtrl4 = { SYNTH_CTRL_FLOAT, { 55.2f }};
SYNTH_CONTROL Reson2_AmplCtrl4 = { SYNTH_CTRL_FLOAT, { 0.4f }};
SYNTH_CONTROL Reson2_PanCtrl4 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.01f, 1.4f }};
SYNTH_CONTROL Reson2_DistCtrl4 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Reson2_DelayCtrl5 = { SYNTH_CTRL_LFO_SINE, { 0.020f, 0.001f, 1.2f }};
SYNTH_CONTROL Reson2_FeedBackCtrl5 = { SYNTH_CTRL_FLOAT, { 0.1f }};
SYNTH_CONTROL Reson2_DryWetCtrl5 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Reson2_CutoffCtrl6 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 8000.0f, 2.0f, 1200.0f }};
SYNTH_CONTROL Reson2_ResoCtrl6 = { SYNTH_CTRL_FLOAT, { 0.7f }};
SYNTH_CONTROL Reson2_DryWetCtrl6 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Reson2_DistCtrl7 = { SYNTH_CTRL_FLOAT, { 2.2f }};
SYNTH_CONTROL Reson2_DryWetCtrl7 = { SYNTH_CTRL_FLOAT, { 0.8f }};

// --- "String5.wav" ( Length = 8.0f ).

SYNTH_CONTROL String5_FreqCtrl1 = { SYNTH_CTRL_LFO_SINE, { 880.0f, 0.1f, 0.4f }};
SYNTH_CONTROL String5_FreqCtrl1Det = { SYNTH_CTRL_LFO_SINE, { 880.3f, -0.1f, 0.7f }};
SYNTH_CONTROL String5_DistCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1.9f, 8.0f, 0.9f }};
SYNTH_CONTROL String5_DistCtrl1Det = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1.7f, 8.0f, 0.7f }};
SYNTH_CONTROL String5_AmplCtrl1 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 0.0f, 0.0f, 0.0f, 0.16f, 0.7f, 2.4f, 0.4f, 4.0f, 0.5f, 4.8f, 0.0f, 6.4f, 0.0f, 8.0f, 0.0f, 8.0f, 0.0f }};
SYNTH_CONTROL String5_PanCtrl1 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.04f, 2.0f }};

SYNTH_CONTROL String5_FreqCtrl2 = { SYNTH_CTRL_LFO_SINE, { 1760.0f, 0.2f, 0.3f }};
SYNTH_CONTROL String5_DistCtrl2 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1.2f, 8.0f, 0.3f }};
SYNTH_CONTROL String5_AmplCtrl2 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 0.0f, 0.0f, 0.0f, 0.16f, 0.3f, 2.4f, 0.5f, 4.0f, 0.2f, 4.8f, 0.0f, 6.4f, 0.0f, 8.0f, 0.0f, 8.0f, 0.0f }};
SYNTH_CONTROL String5_PanCtrl2 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.05f, 1.9f }};

SYNTH_CONTROL String5_FreqCtrl3 = { SYNTH_CTRL_LFO_SINE, { 2640.0f, 0.3f, 0.41f }};
SYNTH_CONTROL String5_DistCtrl3 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1.1f, 8.0f, 0.8f }};
SYNTH_CONTROL String5_AmplCtrl3 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 0.0f, 0.0f, 0.0f, 0.16f, 0.3f, 2.4f, 0.28f, 4.0f, 0.04f, 4.8f, 0.0f, 6.4f, 0.0f, 8.0f, 0.0f, 8.0f, 0.0f }};
SYNTH_CONTROL String5_PanCtrl3 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.05f, 0.9f }};

SYNTH_CONTROL String5_AmplCtrl4 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.04f, 0.1f, 0.8f, 0.1f, 2.0f, 0.04f, 2.8f, 0.0f, 8.0f, 0.0f }};

SYNTH_CONTROL String5_CutoffCtrl1 = { SYNTH_CTRL_LFO_SINE, { 6420.0f, 4240.0f, 0.7f }};
SYNTH_CONTROL String5_ResoCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.3f, 8.0f, 0.5f }};
SYNTH_CONTROL String5_DryWetCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};

SYNTH_CONTROL String5_CutoffCtrl2 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 12600.0f, 0.0f, 12600.0f, 8.0f, 120.0f, 8.0f, 120.0f }};
SYNTH_CONTROL String5_ResoCtrl2 = { SYNTH_CTRL_FLOAT, { 0.3f }};
SYNTH_CONTROL String5_DryWetCtrl2 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL String5_RoomSizeCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL String5_WidthCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL String5_DampCtrl1 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL String5_FeedBackCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL String5_DryWetCtrl3 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL String5_DelayCtrl4 = { SYNTH_CTRL_LFO_SINE, { 0.120f, 0.02f, 0.5f }};
SYNTH_CONTROL String5_FeedBackCtrl4 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL String5_DryWetCtrl4 = { SYNTH_CTRL_FLOAT, { 1.0f }};

//  --- "Hihat03b.wav" ( Length = 0.4f ).

SYNTH_CONTROL Hihat3_FreqCtrl1 = { SYNTH_CTRL_FLOAT, { 10000.0f }};
SYNTH_CONTROL Hihat3_AmplCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.015f, 1.0f, 0.06f, 0.7f, 0.12f, 0.0f, 0.4f, 0.0f }};
SYNTH_CONTROL Hihat3_DistCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL Hihat3_PanCtrl1 = { SYNTH_CTRL_FLOAT, { 0.5f }};

SYNTH_CONTROL Hihat3_CutoffCtrl1 = { SYNTH_CTRL_FLOAT, { 3500.0f }};
SYNTH_CONTROL Hihat3_ResoCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL Hihat3_DryWetCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Hihat3_CutoffCtrl2 = { SYNTH_CTRL_FLOAT, { 18500.0f }};
SYNTH_CONTROL Hihat3_ResoCtrl2 = { SYNTH_CTRL_FLOAT, { 0.4f }};
SYNTH_CONTROL Hihat3_DryWetCtrl2 = { SYNTH_CTRL_FLOAT, { 0.75f }};

SYNTH_CONTROL Hihat3_RoomSizeCtrl1 = { SYNTH_CTRL_FLOAT, { 0.7f }};
SYNTH_CONTROL Hihat3_WidthCtrl1 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Hihat3_DampCtrl1 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Hihat3_FeedBackCtrl1 = { SYNTH_CTRL_FLOAT, { 0.1f }};
SYNTH_CONTROL Hihat3_DryWetCtrl3 = { SYNTH_CTRL_FLOAT, { 0.6f }};

// --- "Bass02.wav" ( Length = 2.0f ).

SYNTH_CONTROL Bass2_FreqCtrl1 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 110.0f, 0.0f, 110.0f, 0.3f, 110.0f, 0.4f, 55.0f, 0.7f, 55.0f, 0.9f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f }};
SYNTH_CONTROL Bass2_AmplCtrl1 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 1.0f, 0.0f, 1.0f, 0.7f, 1.0f, 0.9f, 0.4f, 2.0f, 0.0f, 2.0f, 0.0f }};
SYNTH_CONTROL Bass2_PanCtrl1 = { SYNTH_CTRL_FLOAT, { 0.5f }};
SYNTH_CONTROL Bass2_DistCtrl1 = { SYNTH_CTRL_FLOAT, { 0.96f }};

SYNTH_CONTROL Bass2_FreqCtrl2 = { SYNTH_CTRL_FLOAT, { 110.0f }};
SYNTH_CONTROL Bass2_AmplCtrl2 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 1.0f, 0.0f, 1.0f, 0.1f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f }};
SYNTH_CONTROL Bass2_PanCtrl2 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.04f, 1.7f }};
SYNTH_CONTROL Bass2_DistCtrl2 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// SYNTH_CONTROL Bass2_FreqCtrl3 = { SYNTH_CTRL_FLOAT, { 55.0f }};
// SYNTH_CONTROL Bass2_AmplCtrl3 = { SYNTH_CTRL_FLOAT, { 0.9f }};
// SYNTH_CONTROL Bass2_PanCtrl3 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.04f, 1.6f }};
// SYNTH_CONTROL Bass2_DistCtrl3 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// SYNTH_CONTROL Bass2_FreqCtrl4 = { SYNTH_CTRL_FLOAT, { 55.2f }};
// SYNTH_CONTROL Bass2_AmplCtrl4 = { SYNTH_CTRL_FLOAT, { 0.4f }};
// SYNTH_CONTROL Bass2_PanCtrl4 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.04f, 1.4f }};
// SYNTH_CONTROL Bass2_DistCtrl4 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// SYNTH_CONTROL Bass2_DelayCtrl5 = { SYNTH_CTRL_LFO_SINE, { 0.020f, 0.001f, 1.2f }};
// SYNTH_CONTROL Bass2_FeedBackCtrl5 = { SYNTH_CTRL_FLOAT, { 0.1f }};
// SYNTH_CONTROL Bass2_DryWetCtrl5 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Bass2_CutoffCtrl6 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 200.0f, 2.0f, 10.0f }};
SYNTH_CONTROL Bass2_ResoCtrl6 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Bass2_DryWetCtrl6 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// SYNTH_CONTROL Bass2_DistCtrl7 = { SYNTH_CTRL_FLOAT, { 2.2f }};
// SYNTH_CONTROL Bass2_DryWetCtrl7 = { SYNTH_CTRL_FLOAT, { 0.8f }};

SYNTH_CONTROL Bass2_RoomSizeCtrl8 = { SYNTH_CTRL_FLOAT, { 0.3f }};
SYNTH_CONTROL Bass2_WidthCtrl8 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Bass2_DampCtrl8 = { SYNTH_CTRL_FLOAT, { 0.8f }};
SYNTH_CONTROL Bass2_FeedBackCtrl8 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL Bass2_DryWetCtrl8 = { SYNTH_CTRL_FLOAT, { 0.6f }};

// --- "Bass01.wav" ( Length = 2.0f ).

SYNTH_CONTROL Bass1_FreqCtrl1 = { SYNTH_CTRL_FLOAT, { 55.0f }};
SYNTH_CONTROL Bass1_AmplCtrl1 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 1.0f, 0.0f, 1.0f, 0.3f, 1.0f, 0.31f, 0.1f, 0.32f, 0.03f, 2.0f, 0.0f, 2.0f, 0.0f }};
SYNTH_CONTROL Bass1_PanCtrl1 = { SYNTH_CTRL_FLOAT, { 0.5f }};
SYNTH_CONTROL Bass1_DistCtrl1 = { SYNTH_CTRL_FLOAT, { 0.97f }};

SYNTH_CONTROL Bass1_FreqCtrl2 = { SYNTH_CTRL_FLOAT, { 110.0f }};
SYNTH_CONTROL Bass1_AmplCtrl2 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 1.0f, 0.0f, 1.0f, 0.1f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f }};
SYNTH_CONTROL Bass1_PanCtrl2 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.04f, 1.7f }};
SYNTH_CONTROL Bass1_DistCtrl2 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// SYNTH_CONTROL Bass1_FreqCtrl3 = { SYNTH_CTRL_FLOAT, { 55.0f }};
// SYNTH_CONTROL Bass1_AmplCtrl3 = { SYNTH_CTRL_FLOAT, { 0.9f }};
// SYNTH_CONTROL Bass1_PanCtrl3 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.04f, 1.6f }};
// SYNTH_CONTROL Bass1_DistCtrl3 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// SYNTH_CONTROL Bass1_FreqCtrl4 = { SYNTH_CTRL_FLOAT, { 55.2f }};
// SYNTH_CONTROL Bass1_AmplCtrl4 = { SYNTH_CTRL_FLOAT, { 0.4f }};
// SYNTH_CONTROL Bass1_PanCtrl4 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.04f, 1.4f }};
// SYNTH_CONTROL Bass1_DistCtrl4 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// SYNTH_CONTROL Bass1_DelayCtrl5 = { SYNTH_CTRL_LFO_SINE, { 0.020f, 0.001f, 1.2f }};
// SYNTH_CONTROL Bass1_FeedBackCtrl5 = { SYNTH_CTRL_FLOAT, { 0.1f }};
// SYNTH_CONTROL Bass1_DryWetCtrl5 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL Bass1_CutoffCtrl6 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 200.0f, 2.0f, 10.0f }};
SYNTH_CONTROL Bass1_ResoCtrl6 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Bass1_DryWetCtrl6 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// SYNTH_CONTROL Bass1_DistCtrl7 = { SYNTH_CTRL_FLOAT, { 2.2f }};
// SYNTH_CONTROL Bass1_DryWetCtrl7 = { SYNTH_CTRL_FLOAT, { 0.8f }};

SYNTH_CONTROL Bass1_RoomSizeCtrl8 = { SYNTH_CTRL_FLOAT, { 0.1f }};
SYNTH_CONTROL Bass1_WidthCtrl8 = { SYNTH_CTRL_FLOAT, { 0.0f }};
SYNTH_CONTROL Bass1_DampCtrl8 = { SYNTH_CTRL_FLOAT, { 0.8f }};
SYNTH_CONTROL Bass1_FeedBackCtrl8 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL Bass1_DryWetCtrl8 = { SYNTH_CTRL_FLOAT, { 0.6f }};

// --- "String4.wav"

SYNTH_CONTROL String4_FreqCtrl1 = { SYNTH_CTRL_LFO_SINE, { 880.0f, 0.6f, 0.4f }};
SYNTH_CONTROL String4_FreqCtrl1Det = { SYNTH_CTRL_LFO_SINE, { 882.0f, -0.6f, 0.7f }};
SYNTH_CONTROL String4_DistCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1.9f, 8.0f, 0.9f }};
SYNTH_CONTROL String4_DistCtrl1Det = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1.7f, 8.0f, 0.7f }};
SYNTH_CONTROL String4_AmplCtrl1 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 0.0f, 0.0f, 0.0f, 0.16f, 0.7f, 2.4f, 0.4f, 4.0f, 0.5f, 4.8f, 0.0f, 6.4f, 0.0f, 8.0f, 0.0f, 8.0f, 0.0f }};
SYNTH_CONTROL String4_PanCtrl1 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.04f, 2.0f }};

SYNTH_CONTROL String4_FreqCtrl2 = { SYNTH_CTRL_LFO_SINE, { 1760.0f, 1.2f, 0.3f }};
SYNTH_CONTROL String4_DistCtrl2 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1.2f, 8.0f, 0.3f }};
SYNTH_CONTROL String4_AmplCtrl2 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 0.0f, 0.0f, 0.0f, 0.16f, 0.3f, 2.4f, 0.5f, 4.0f, 0.2f, 4.8f, 0.0f, 6.4f, 0.0f, 8.0f, 0.0f, 8.0f, 0.0f }};
SYNTH_CONTROL String4_PanCtrl2 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.05f, 1.9f }};

SYNTH_CONTROL String4_FreqCtrl3 = { SYNTH_CTRL_LFO_SINE, { 2640.0f, 3.8f, 0.41f }};
SYNTH_CONTROL String4_DistCtrl3 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 1.1f, 8.0f, 0.8f }};
SYNTH_CONTROL String4_AmplCtrl3 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 0.0f, 0.0f, 0.0f, 0.16f, 0.3f, 2.4f, 0.28f, 4.0f, 0.04f, 4.8f, 0.0f, 6.4f, 0.0f, 8.0f, 0.0f, 8.0f, 0.0f }};
SYNTH_CONTROL String4_PanCtrl3 = { SYNTH_CTRL_LFO_SINE, { 0.5f, 0.05f, 0.9f }};

SYNTH_CONTROL String4_AmplCtrl4 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.0f, 0.04f, 0.1f, 0.8f, 0.1f, 2.0f, 0.04f, 2.8f, 0.0f, 8.0f, 0.0f }};

SYNTH_CONTROL String4_CutoffCtrl1 = { SYNTH_CTRL_LFO_SINE, { 6420.0f, 4240.0f, 0.7f }};
SYNTH_CONTROL String4_ResoCtrl1 = { SYNTH_CTRL_ENV_LINEAR, { 0.0f, 0.3f, 8.0f, 0.5f }};
SYNTH_CONTROL String4_DryWetCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};

SYNTH_CONTROL String4_CutoffCtrl2 = { SYNTH_CTRL_ENV_SPLINE, { 0.0f, 2600.0f, 0.0f, 2600.0f, 8.0f, 120.0f, 8.0f, 120.0f }};
SYNTH_CONTROL String4_ResoCtrl2 = { SYNTH_CTRL_FLOAT, { 0.8f }};
SYNTH_CONTROL String4_DryWetCtrl2 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL String4_RoomSizeCtrl1 = { SYNTH_CTRL_FLOAT, { 0.9f }};
SYNTH_CONTROL String4_WidthCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL String4_DampCtrl1 = { SYNTH_CTRL_FLOAT, { 1.0f }};
SYNTH_CONTROL String4_FeedBackCtrl1 = { SYNTH_CTRL_FLOAT, { 0.7f }};
SYNTH_CONTROL String4_DryWetCtrl3 = { SYNTH_CTRL_FLOAT, { 1.0f }};

SYNTH_CONTROL String4_DelayCtrl4 = { SYNTH_CTRL_LFO_SINE, { 0.020f, 0.007f, 0.7f }};
SYNTH_CONTROL String4_FeedBackCtrl4 = { SYNTH_CTRL_FLOAT, { 0.6f }};
SYNTH_CONTROL String4_DryWetCtrl4 = { SYNTH_CTRL_FLOAT, { 1.0f }};

// ------------------------------------------------------------------------------------------------

void Synth_BufferConvert( SYNTH_BUFFER *Buf, short *Dest, unsigned int Len, int Size )
  {
    if ( Buf->Length != Len ) MessageBox( 0, "Sample length mismatch.", "Synth Error", MB_ICONERROR|MB_OK );
    for ( unsigned int I = 0; I < Len; I++ )
      Dest[ I ] = Fround( 32600 * Buf->Ptr[ I*2+Size ] );
   }

// ------------------------------------------------------------------------------------------------

void Samples_Synthesize( char *Module )
  {
    // --- "Hihat01b.wav"
    Buf1 = Synth_BufferInitialize( 0.4f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_TRIANGLE, 1, 0.1f, &Hihat1_FreqCtrl1, &Hihat1_DistCtrl1, &Hihat1_AmplCtrl1, &Hihat1_PanCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_HIGH12, &Hihat1_CutoffCtrl1, &Hihat1_ResoCtrl1, &Hihat1_DryWetCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_BAND12, &Hihat1_CutoffCtrl2, &Hihat1_ResoCtrl2, &Hihat1_DryWetCtrl2 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_BAND12, &Hihat1_CutoffCtrl2, &Hihat1_ResoCtrl2, &Hihat1_DryWetCtrl2 );
    Synth_Reverb( Buf1, &Hihat1_RoomSizeCtrl3, &Hihat1_WidthCtrl3, &Hihat1_DampCtrl3, &Hihat1_FeedBackCtrl3, &Hihat1_DryWetCtrl3 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x000094A2 ), 17640, 0 );
    Synth_BufferCleanup( Buf1 );
  
    // --- "Reson4.wav"
    Buf1 = Synth_BufferInitialize( 2.0f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &Reson4_FreqCtrl1, &Reson4_DistCtrl1, &Reson4_AmplCtrl1, &Reson4_PanCtrl1 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &Reson4_FreqCtrl2, &Reson4_DistCtrl2, &Reson4_AmplCtrl2, &Reson4_PanCtrl2 );
    Synth_ChorusFlange( Buf1, &Reson4_DelayCtrl5, &Reson4_FeedBackCtrl5, &Reson4_DryWetCtrl5 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_MOOG1_LOW24, &Reson4_CutoffCtrl6, &Reson4_ResoCtrl6, &Reson4_DryWetCtrl6 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_BAND12, &Reson4_CutoffCtrl6, &Reson4_ResoCtrl6, &Reson4_DryWetCtrl6 );
    Synth_DistortWave( Buf1, &Reson4_DistCtrl7, &Reson4_DryWetCtrl7 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x00011E74 ), 88200, 0 );
    Synth_BufferCleanup( Buf1 );
  
    // --- "Snare03c.wav"
    Buf1 = Synth_BufferInitialize( 1.176f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_TRIANGLE, 1, 0.02f, &Snare3_FreqCtrl1, &Snare3_DistCtrl1, &Snare3_AmplCtrl1, &Snare3_PanCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_LOW12, &Snare3_CutoffCtrl1, &Snare3_ResoCtrl1, &Snare3_DryWetCtrl1 );
    Synth_Reverb( Buf1, &Snare3_RoomSizeCtrl1, &Snare3_WidthCtrl1, &Snare3_DampCtrl1, &Snare3_FeedBackCtrl1, &Snare3_DryWetCtrl3 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_HIGH12, &Snare3_CutoffCtrl2, &Snare3_ResoCtrl2, &Snare3_DryWetCtrl2 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x0003CF86 ), 51862, 0 );
    Synth_BufferCleanup( Buf1 );

    // --- "Snare05c.wav"
    Buf1 = Synth_BufferInitialize( 1.176f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_TRIANGLE, 1, 0.02f, &Snare5_FreqCtrl1, &Snare5_DistCtrl1, &Snare5_AmplCtrl1, &Snare5_PanCtrl1 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_TRIANGLE, 3, 0.7f, &Snare5_FreqCtrl1, &Snare5_DistCtrl1, &Snare5_AmplCtrl1, &Snare5_PanCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_LOW12, &Snare5_CutoffCtrl1, &Snare5_ResoCtrl1, &Snare5_DryWetCtrl1 );
    Synth_Reverb( Buf1, &Snare5_RoomSizeCtrl1, &Snare5_WidthCtrl1, &Snare5_DampCtrl1, &Snare5_FeedBackCtrl1, &Snare5_DryWetCtrl3 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_HIGH12, &Snare5_CutoffCtrl2, &Snare5_ResoCtrl2, &Snare5_DryWetCtrl2 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x000564B4 ), 51862, 0 );
    Synth_BufferCleanup( Buf1 );

    // --- "Bdrum01c.wav", "Bdrum0..d.wav"
    Buf1 = Synth_BufferInitialize( 1.47f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_TRIANGLE, 1, 0.004f, &Bdrum1_FreqCtrl2, &Bdrum1_DistCtrl1, &Bdrum1_AmplCtrl2, &Bdrum1_PanCtrl1 );
    Synth_DistortWave( Buf1, &Bdrum1_DistCtrl1, &Bdrum1_DistCtrl1 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SINE, 1, 0.0001f, &Bdrum1_FreqCtrl1, &Bdrum1_DistCtrl1, &Bdrum1_AmplCtrl1, &Bdrum1_PanCtrl1 );
    for ( int X=0; X<8; X++ )
      {
        Buf2 = Synth_BufferCopy( Buf1 );
        Bdrum1_DryWetCtrl1.Values[0] = 1.0f - (float) X / 8.0f;
        Bdrum1_CutoffCtrl1.Values[0] = 1000.0f * Fpow( (float) (X+1) / 8.0f, 1.5f );
        Synth_FilterWave( Buf2, SYNTH_FILTER_MOOG1_LOW24, &Bdrum1_CutoffCtrl1, &Bdrum1_ResoCtrl1, &Bdrum1_DryWetCtrl1 );
        Synth_Reverb( Buf2, &Bdrum1_RoomSizeCtrl3, &Bdrum1_WidthCtrl3, &Bdrum1_DampCtrl3, &Bdrum1_FeedBackCtrl3, &Bdrum1_DryWetCtrl3 );
        Synth_Normalize( Buf2 );
        Synth_BufferConvert( Buf2, (short*) ( (int) Module + 0x0051C5A4 + X * 0x0001FA78 ), 64827, 0 );
        Synth_BufferCleanup( Buf2 );
       }
    Synth_Reverb( Buf1, &Bdrum1_RoomSizeCtrl3, &Bdrum1_WidthCtrl3, &Bdrum1_DampCtrl3, &Bdrum1_FeedBackCtrl3, &Bdrum1_DryWetCtrl3 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x0006F9E2 ), 64827, 0 );
    Synth_BufferCleanup( Buf1 );

    // --- "String3.wav"
    Buf1 = Synth_BufferInitialize( 8.0f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_PULSE, 0, 0.0f, &String3_FreqCtrl1, &String3_DistCtrl1, &String3_AmplCtrl1, &String3_PanCtrl1 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_PULSE, 0, 0.0f, &String3_FreqCtrl1Det, &String3_DistCtrl1, &String3_AmplCtrl1, &String3_PanCtrl2 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_TRIANGLE, 0, 0.0f, &String3_FreqCtrl2, &String3_DistCtrl1, &String3_AmplCtrl2, &String3_PanCtrl2 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_TRIANGLE, 0, 0.0f, &String3_FreqCtrl3, &String3_DistCtrl1, &String3_AmplCtrl3, &String3_PanCtrl3 );
    Synth_DistortWave( Buf1, &String3_DistCtrl1, &String3_DryWetCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_NOTCH12, &String3_CutoffCtrl1, &String3_ResoCtrl1, &String3_DryWetCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_MOOG1_LOW24, &String3_CutoffCtrl2, &String3_ResoCtrl2, &String3_DryWetCtrl2 );
    Synth_ChorusFlange( Buf1, &String3_DelayCtrl4, &String3_FeedBackCtrl4, &String3_DryWetCtrl4 );
    Synth_Reverb( Buf1, &String3_RoomSizeCtrl1, &String3_WidthCtrl1, &String3_DampCtrl1, &String3_FeedBackCtrl1, &String3_DryWetCtrl3 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x00088F10 ), 352800, 0 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x00135352 ), 352800, 1 );
    Synth_BufferCleanup( Buf1 );

    // --- "Reson2.wav"
    Buf1 = Synth_BufferInitialize( 2.0f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &Reson2_FreqCtrl1, &Reson2_DistCtrl1, &Reson2_AmplCtrl1, &Reson2_PanCtrl1 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &Reson2_FreqCtrl2, &Reson2_DistCtrl2, &Reson2_AmplCtrl2, &Reson2_PanCtrl2 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &Reson2_FreqCtrl3, &Reson2_DistCtrl3, &Reson2_AmplCtrl3, &Reson2_PanCtrl3 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &Reson2_FreqCtrl4, &Reson2_DistCtrl4, &Reson2_AmplCtrl4, &Reson2_PanCtrl4 );
    Synth_ChorusFlange( Buf1, &Reson2_DelayCtrl5, &Reson2_FeedBackCtrl5, &Reson2_DryWetCtrl5 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_MOOG1_LOW24, &Reson2_CutoffCtrl6, &Reson2_ResoCtrl6, &Reson2_DryWetCtrl6 );
    Synth_DistortWave( Buf1, &Reson2_DistCtrl7, &Reson2_DryWetCtrl7 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x001E1794 ), 88200, 0 );
    Synth_BufferCleanup( Buf1 );

    // --- "String5.wav"
    Buf1 = Synth_BufferInitialize( 8.0f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &String5_FreqCtrl1, &String5_DistCtrl1, &String5_AmplCtrl1, &String5_PanCtrl1 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &String5_FreqCtrl1Det, &String5_DistCtrl1Det, &String5_AmplCtrl1, &String5_PanCtrl2 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_PULSE, 0, 0.0f, &String5_FreqCtrl2, &String5_DistCtrl2, &String5_AmplCtrl2, &String5_PanCtrl2 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_TRIANGLE, 0, 0.0f, &String5_FreqCtrl3, &String5_DistCtrl3, &String5_AmplCtrl3, &String5_PanCtrl3 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_LOW12, &String5_CutoffCtrl2, &String5_ResoCtrl2, &String5_DryWetCtrl2 );
    Synth_Reverb( Buf1, &String5_RoomSizeCtrl1, &String5_WidthCtrl1, &String5_DampCtrl1, &String5_FeedBackCtrl1, &String5_DryWetCtrl3 );
    Synth_ChorusFlange( Buf1, &String5_DelayCtrl4, &String5_FeedBackCtrl4, &String5_DryWetCtrl4 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x0020C8A6 ), 352800, 0 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x002B8CE8 ), 352800, 1 );
    Synth_BufferCleanup( Buf1 );

    // --- "Hihat03b.wav"
    Buf1 = Synth_BufferInitialize( 0.4f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SINE, 1, 0.7f, &Hihat3_FreqCtrl1, &Hihat3_DistCtrl1, &Hihat3_AmplCtrl1, &Hihat3_PanCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_HIGH12, &Hihat3_CutoffCtrl1, &Hihat3_ResoCtrl1, &Hihat3_DryWetCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_BAND12, &Hihat3_CutoffCtrl2, &Hihat3_ResoCtrl2, &Hihat3_DryWetCtrl2 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_BAND12, &Hihat3_CutoffCtrl2, &Hihat3_ResoCtrl2, &Hihat3_DryWetCtrl2 );
    Synth_Reverb( Buf1, &Hihat3_RoomSizeCtrl1, &Hihat3_WidthCtrl1, &Hihat3_DampCtrl1, &Hihat3_FeedBackCtrl1, &Hihat3_DryWetCtrl3 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x0036512A ), 17640, 0 );
    Synth_BufferCleanup( Buf1 );

    // --- "Bass02.wav"
    Buf1 = Synth_BufferInitialize( 2.0f );  
    Synth_GenerateWave( Buf1, SYNTH_WAVE_PULSE, 0, 0.0f, &Bass2_FreqCtrl2, &Bass2_DistCtrl2, &Bass2_AmplCtrl2, &Bass2_PanCtrl2 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_MOOG1_LOW24, &Bass2_CutoffCtrl6, &Bass2_ResoCtrl6, &Bass2_DryWetCtrl6 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SINE, 0, 0.0f, &Bass2_FreqCtrl1, &Bass2_DistCtrl1, &Bass2_AmplCtrl1, &Bass2_PanCtrl1 );
    Synth_DistortWave( Buf1, &Bass2_DistCtrl1, &Bass2_DistCtrl1 );
    Synth_Reverb( Buf1, &Bass2_RoomSizeCtrl8, &Bass2_WidthCtrl8, &Bass2_DampCtrl8, &Bass2_FeedBackCtrl8, &Bass2_DryWetCtrl8 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x0036DAFC ), 88200, 0 );
    Synth_BufferCleanup( Buf1 );

    // --- "Bass01.wav"
    Buf1 = Synth_BufferInitialize( 2.0f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_PULSE, 0, 0.0f, &Bass1_FreqCtrl2, &Bass1_DistCtrl2, &Bass1_AmplCtrl2, &Bass1_PanCtrl2 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_MOOG1_LOW24, &Bass1_CutoffCtrl6, &Bass1_ResoCtrl6, &Bass1_DryWetCtrl6 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SINE, 0, 0.0f, &Bass1_FreqCtrl1, &Bass1_DistCtrl1, &Bass1_AmplCtrl1, &Bass1_PanCtrl1 );
    Synth_DistortWave( Buf1, &Bass1_DistCtrl1, &Bass1_DistCtrl1 );
    Synth_Reverb( Buf1, &Bass1_RoomSizeCtrl8, &Bass1_WidthCtrl8, &Bass1_DampCtrl8, &Bass1_FeedBackCtrl8, &Bass1_DryWetCtrl8 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x00398C0E ), 88200, 0 );
    Synth_BufferCleanup( Buf1 );

    // --- "String4.wav"
    Buf1 = Synth_BufferInitialize( 8.0f );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &String4_FreqCtrl1, &String4_DistCtrl1, &String4_AmplCtrl1, &String4_PanCtrl1 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_SAW, 0, 0.0f, &String4_FreqCtrl1Det, &String4_DistCtrl1Det, &String4_AmplCtrl1, &String4_PanCtrl2 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_PULSE, 0, 0.0f, &String4_FreqCtrl2, &String4_DistCtrl2, &String4_AmplCtrl2, &String4_PanCtrl2 );
    Synth_GenerateWave( Buf1, SYNTH_WAVE_TRIANGLE, 0, 0.0f, &String4_FreqCtrl3, &String4_DistCtrl3, &String4_AmplCtrl3, &String4_PanCtrl3 );
    Synth_DistortWave( Buf1, &String4_DistCtrl1, &String4_DryWetCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_STATE_NOTCH12, &String4_CutoffCtrl1, &String4_ResoCtrl1, &String4_DryWetCtrl1 );
    Synth_FilterWave( Buf1, SYNTH_FILTER_MOOG1_LOW24, &String4_CutoffCtrl2, &String4_ResoCtrl2, &String4_DryWetCtrl2 );
    Synth_ChorusFlange( Buf1, &String4_DelayCtrl4, &String4_FeedBackCtrl4, &String4_DryWetCtrl4 );
    Synth_Reverb( Buf1, &String4_RoomSizeCtrl1, &String4_WidthCtrl1, &String4_DampCtrl1, &String4_FeedBackCtrl1, &String4_DryWetCtrl3 );
    Synth_Normalize( Buf1 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x003C3D20 ), 352800, 0 );
    Synth_BufferConvert( Buf1, (short*) ( (int) Module + 0x00470162 ), 352800, 1 );
    Synth_BufferCleanup( Buf1 );
   }