
#include <StdIO.h>
#include <Windows.h>
#include <D3D8.h>
#include "D3DU8.h"

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "Rand.h"

#define D3DFVF_BLENDCONE_VERTEX1 (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1|D3DFVF_TEXCOORDSIZE2(0))
typedef struct _BLENDCONE_VERTEX1
  {
    D3DVECTOR Vertex;
    DWORD Diffuse;
    float TexU1, TexV1;
   } BLENDCONE_VERTEX1;

LPDIRECT3DVERTEXBUFFER8 BlendCone_VertexBuffer1 = NULL;
BLENDCONE_VERTEX1 *BlendCone_LockedVertexBuffer1;

extern LPDIRECT3DTEXTURE8 SphereBack_Texture1;

// ------------------------------------------------------------------------------------------------

int BlendCone_Initialize( void )
  {
    if ( Direct3DDevice->CreateVertexBuffer( 3 * 32 * 256 * sizeof( BLENDCONE_VERTEX1 ), 0, D3DFVF_BLENDCONE_VERTEX1,
      D3DPOOL_DEFAULT, &BlendCone_VertexBuffer1 ) != D3D_OK ) return 0;

    return 1;
   }

// ------------------------------------------------------------------------------------------------

void BlendCone_Cleanup( void )
  {
    if ( BlendCone_VertexBuffer1 ) BlendCone_VertexBuffer1->Release();
   }

// ------------------------------------------------------------------------------------------------

void BlendCone_Render( float Time )
  { 
    int I, J;
    float Light, Time2 = ( Time - 19.0f * 64.0f ) / 128.0f;

    if ( Time <= 19.0f * 64.0f ) Light = 0.0f;
    if (( Time > 19.0f * 64.0f ) && ( Time <= 19.5f * 64.0f )) Light = ( Time - 19.0f * 64.0f ) / 32.0f;
    if (( Time > 19.5f * 64.0f ) && ( Time <= 20.5f * 64.0f )) Light = 1.0f;
    if (( Time > 20.5f * 64.0f ) && ( Time <= 21.0f * 64.0f )) Light = ( 21.0f * 64.0f - Time ) / 32.0f;
    if ( Time > 21.0f * 64.0f ) Light = 0.0f;
    
    if ( BlendCone_VertexBuffer1->Lock( 0, 3 * 32 * 256 * sizeof( BLENDCONE_VERTEX1 ), (BYTE**) &BlendCone_LockedVertexBuffer1, 0 ) != D3D_OK ) return;

    for ( I=0; I<32*256; I++ )
      {
        BlendCone_LockedVertexBuffer1[ I ].Vertex.x = (( 2.0f + 1.2f * Fcos(( I * 2 + 3 * Time ) * 0.02f )) * ( 0.5f + ( I&1 ))) * Fsin( (float) I * Fmath_2Pi / 32.0f );
        BlendCone_LockedVertexBuffer1[ I ].Vertex.y = (float) ( I + 8.0f * Fcos(( I + 7 * Time ) * 0.01f ) - 512 - 256.0f * Time2 ) / 128.0f;
        BlendCone_LockedVertexBuffer1[ I ].Vertex.z = (( 2.0f + 1.2f * Fcos(( I * 2 + 3 * Time ) * 0.02f )) * ( 0.5f + ( I&1 ))) * Fcos( (float) I * Fmath_2Pi / 32.0f );
        BlendCone_LockedVertexBuffer1[ I ].Diffuse = 
          TxGen_ColorBlend( 0x000000, TxGen_ColorBlend( 0x28604E, 0x304670, 128 + Fround( 120.0f * Fsin(( I+Time ) * 0.005 ))), Fround( 255.0f * Light ));
        BlendCone_LockedVertexBuffer1[ I ].TexU1 = (float) I / 32.0f;
        BlendCone_LockedVertexBuffer1[ I ].TexV1 = (float) (I&1) / 32.0f;
       }

    BlendCone_VertexBuffer1->Unlock();
     
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DUMatrixIdentity );
    
    D3DUMatrixRotationX( &D3DMatrix_World0, -Fmath_Pi / 11.0f );
    D3DUMatrixTranslation( &D3DMatrix_Temp, 0.1f, 0.0f, 0.0f );
    D3DUMatrixMultiply( &D3DMatrix_World0, &D3DMatrix_World0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );

    // --- Setup View Matrix.
    D3DUVec3Create( &D3DVector_CameraPosition, 6.0f, 0.0f, 0.0f );
    D3DUVec3Create( &D3DVector_CameraTarget, 0.0f, 0.4f, 0.0f );
    D3DUVec3Create( &D3DVector_Up, 0.0f, -1.0f, 0.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    // --- Setup Projection Matrix.
    D3DUMatrixPerspectiveFovLH( &D3DMatrix_Projection, D3DU_PI * 0.45f, 1.778f, 0.1f, 100.0f );
    Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );
    
    Direct3DDevice->SetVertexShader( D3DFVF_BLENDCONE_VERTEX1 );

    Direct3DDevice->SetTexture( 0, SphereBack_Texture1 );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );
    

    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0xFFFFFF );
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    Direct3DDevice->LightEnable( 0, FALSE );

    // --- Blending.
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );

    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );

    Direct3DDevice->SetStreamSource( 0, BlendCone_VertexBuffer1, sizeof( BLENDCONE_VERTEX1 ));
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 128*32-2 );
     
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
   }