
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include "bitmaps.h"
#include "blitter.h"
#include "circles.h"
#include "plasmafx.h"
#include "globals.h"
#include "midas.h"
#include "part1.h"

#include "mini1.h"
#include "mini2.h"
#include "mini3.h"
#include "mini4.h"
#include "mini5.h"
#include "mini6.h"
#include "mini7.h"
#include "mini8.h"
#include "publico1.h"
#include "cartel3.h"
#include "banner5.h"
#include "p9.h"

#define FX1xm 10
#define FX1ym 10

byte p1_pt1[256], p1_pt2[256];
int p1_td[256];

void EFX1(TBitmap8bpp *source, TBitmap8bpp *dest, TBitmap8bpp *plas) {
	byte *src;
	byte *dst = dest->datos;
	byte *pls = plas->datos;
	for (int y = 0; y < dest->alto; y++) {
                src = source->datos + source->tablay[y + FX1ym] + FX1xm;
		for (int x = 0; x < dest->ancho; x++)
                        *dst++ = *((src++) + p1_td[*pls++]);
	}
}


void Part1_Setup() {
        GeneratePlasmaTable(p1_pt1, 0, 0, 0);
        GeneratePlasmaTable(p1_pt1, 1, 192, 1);
        GeneratePlasmaTable(p1_pt1, 4, 64, 2);
        GeneratePlasmaTable(p1_pt1, 8, 123, 2);
        GeneratePlasmaTable(p1_pt2, 0, 0, 0);
        GeneratePlasmaTable(p1_pt2, 6, 128, 2);
        GeneratePlasmaTable(p1_pt2, 7, 200, 1);
	for (int i = 0; i < 256; i++)
                p1_td[i] = (int)((FX1ym - 1) * sin(i * 3.14159265 / 128.0)) * ScreenWidth +
                        (int)((FX1xm - 1) * cos(i * 3.14159265 / 128.0));
}


void luchador_Part1() {
        TBitmap8bpp *minis[8];
        TBitmap8bpp *tempbm = new TBitmap8bpp(100, 76);
        TBitmap8bpp *fondo = new TBitmap8bpp(P9_ANCHO, P9_ALTO, P9, P9_PAL);
        TBitmap8bpp *deform = new TBitmap8bpp(fondo->ancho - FX1xm * 2, fondo->alto - FX1ym * 2);
	TBitmap8bpp *plasma = new TBitmap8bpp(deform->ancho, deform->alto);
        TBitmap8bpp *publico = new TBitmap8bpp(PUBLICO1_ANCHO, PUBLICO1_ALTO, PUBLICO1, PUBLICO1_PAL);
        TBitmap8bpp *cartel = new TBitmap8bpp(CARTEL3_ANCHO, CARTEL3_ALTO, CARTEL3, CARTEL3_PAL);
        TBitmap8bpp *banner = new TBitmap8bpp(BANNER5_ANCHO, BANNER5_ALTO, BANNER5, BANNER5_PAL);
        minis[0] = new TBitmap8bpp(MINI1_ANCHO, MINI1_ALTO, MINI1, MINI1_PAL);
        minis[1] = new TBitmap8bpp(MINI2_ANCHO, MINI2_ALTO, MINI2, MINI2_PAL);
        minis[2] = new TBitmap8bpp(MINI3_ANCHO, MINI3_ALTO, MINI3, MINI3_PAL);
        minis[3] = new TBitmap8bpp(MINI4_ANCHO, MINI4_ALTO, MINI4, MINI4_PAL);
        minis[4] = new TBitmap8bpp(MINI5_ANCHO, MINI5_ALTO, MINI5, MINI5_PAL);
        minis[5] = new TBitmap8bpp(MINI6_ANCHO, MINI6_ALTO, MINI6, MINI6_PAL);
        minis[6] = new TBitmap8bpp(MINI7_ANCHO, MINI7_ALTO, MINI7, MINI7_PAL);
        minis[7] = new TBitmap8bpp(MINI8_ANCHO, MINI8_ALTO, MINI8, MINI8_PAL);
        memcpy(deform->paleta, fondo->paleta, 256 * sizeof(unsigned));

	byte t1, t2, t3, t4;
        double a, b;
        int m, lastpos = m_position;
        m_timer = 0;
        while (m_position < 4) {
                vscr->Borra(0);

                GeneratePlasma(plasma, p1_pt1, p1_pt2, t1, t2, t3, t4);
                EFX1(fondo, deform, plasma);
                deform->BlitTo(vscr, FX1xm, FX1ym);

                a = sin(m_timer / 100.0);
                b = cos(m_timer / 133.0);
                m = (((m_position - lastpos) << 2) + (m_row >> 4)) & 7;
                minis[m]->BlitTo8bpp(tempbm, 0, -12);
                DrawCircleFX(tempbm, vscr, 0x000000, 2);
                minis[m]->TransBlitTo(vscr, 110 - dtoi(40.0 * a), 70 + dtoi(30.0 * b), 0);

                if (m_timer < 100)
                        publico->TransBlitTo(vscr, 0, 240 - dtoi(m_timer * 0.96), 31);
                else if (m_timer < 300)
                        publico->TransBlitTo(vscr, 0, 144, 31);
                else if (m_timer < 400)
                        publico->TransBlitTo(vscr, 0, 144 + dtoi((m_timer - 300) * 0.96), 31);
                else if (m_timer < 500)
                        cartel->TransBlitTo(vscr, dtoi((m_timer - 400) * 1.74) - 174, 0, 14);
                else if (m_timer < 600)
                        cartel->TransBlitTo(vscr, 0, 0, 14);
                else if (m_timer < 800)
                        cartel->TransBlitTo(vscr, dtoi((m_timer - 600) * 1.6), 0, 14);

                if (m_timer < 100)
                        banner->TransBlitTo(vscr, 74, dtoi(m_timer * 0.68) - 68, 255);
                else if (m_timer < 600)
                        banner->TransBlitTo(vscr, 74, 0, 255);
                else if (m_timer < 800)
                        banner->TransBlitTo(vscr, 74 - dtoi((m_timer - 600) * 1.6), 0, 255);

                t1 += 1; t2 -= 2; t3 -= 1; t4 += 2;

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        delete fondo;
        delete publico;
        delete cartel;
        delete banner;
        free(deform->datos); delete deform;
        free(plasma->datos); delete plasma;
        free(tempbm->datos); delete tempbm;
        for (int i = 0; i < 8; i++) delete minis[i];

}

