//      midas.cpp

#include <stdlib.h>
#include "midas.h"

unsigned m_position, m_pattern, m_row, m_timer, m_elapsedtime;
MIDASmodulePlayHandle playhandle;
int m_rowflag;
MIDASmodule module;

void MIDAS_CALL MidasTimerCallback(void) { m_timer++; m_elapsedtime++; }

void LoadModule(char *filename) {
        MIDASstartup();
        MIDASdetectSoundCard();
        MIDASconfig();
        MIDASinit();
        m_timer = 0;
        MIDASsetTimerCallbacks(TimerFreq * 1000, FALSE, &MidasTimerCallback, NULL, NULL);
        module = MIDASloadModule(filename);
}


void FreeModule() {
        MIDASremoveTimerCallbacks();
        MIDASstopModule(playhandle);
        MIDASfreeModule(module);
        MIDASclose();
}


void PlayModule() {
        playhandle = MIDASplayModule(module, TRUE);
        GetMusicStatus();
}


void GetMusicStatus() {
	static MIDASplayStatus status;
	MIDASgetPlayStatus(playhandle, &status);
        m_position = status.position;
        m_pattern = status.pattern;
        if (m_row == status.row) m_rowflag = 0;
        else {  m_rowflag = 1; m_row = status.row; }
}


void SetPosition(int p) {
        MIDASsetPosition(playhandle, p);
}


double GetElapsedTime() {
        return m_elapsedtime / (double)TimerFreq;
}

