.MEMORYMAP
DEFAULTSLOT 0
SLOTSIZE $10000
SLOT 0 $0000
.ENDME

.ROMBANKMAP
BANKSTOTAL 1
BANKSIZE $10000
BANKS 1
.ENDRO

.BANK 0

;****************************************************************************
;*****
;*****
;*****  1K Gymnopedies - Entry to Minigame Competition 2006
;*****
;*****  aleksi.eeben@gmail.com
;*****  http://www.cncd.fi/aeeben
;*****
;*****
;****************************************************************************


;-----  game constants

.DEFINE MAXSPAWNRATE    $50             ; fastest spawn rate
.DEFINE SPAWNRATEUP     $04             ; spawn rate increase speed
.DEFINE ATTACKWAVE      $15             ; size of first attack wave

;-      sound fx frequency

.DEFINE SNDFQ_SPWN      $f4             ; enemy spawn
.DEFINE SNDFQ_BUMP      $c0             ; enemy bump/turn around
.DEFINE SNDFQ_ROCK      $ea             ; hit rock 
.DEFINE SNDFQ_FIRE      $d0             ; fire
.DEFINE SNDFQ_EHIT      $f8             ; enemy explosion
.DEFINE SNDFQ_EXPL      $ff             ; explosion

;-      sound fx freq sweep

.DEFINE SNDSW_SPWN      $02
.DEFINE SNDSW_BUMP      $e0
.DEFINE SNDSW_FIRE      $fc
.DEFINE SNDSW_EXPL      $ff ; was $fe


;-----  zeropage variables

.DEFINE tmp     $00
.DEFINE cnt     $01
.DEFINE scr     $02
.DEFINE scrh    $03
.DEFINE color   $04
.DEFINE colorh  $05
.DEFINE run     $06
.DEFINE shipx   $07
.DEFINE score0  $08
.DEFINE score1  $09
.DEFINE spawn   $0a
.DEFINE sprate  $0b
.DEFINE wavesiz $0c
.DEFINE dead    $0d


;-----  load address

.SECTION "BANKHEADER"
        .DW     $1001
.ENDS


.ORG $1001
.SECTION "main" FORCE

;-----  basic line

        .DB     $0b,$08,$01,$00,$9e,$34,$31,$30,$39,$00,$00,$00


;-----  entry

entry:
        sei
        lda     #$7f
        sta     $9122                   ; set joy3 input


;-      start new game

newgame:
        ldx     #$00

_inilp
        lda     #$00
        sta     $1d95,x                 ; clear screen
        sta     $1e95,x
        sta     $0f10,x                 ; init space
        sta     $1400,x                 ; init softsprites area
        sta     $00,x                   ; init zeropage variables
        sta     $9795,x                 ; bottom line color

        lda.w   panel-$fb,x             ; panel fake zero & lives
        sta     $1f99-$fb,x
        lda     #$40                    ; bottom line char
        sta     $1f9d,x

        txa                             ; shift ship & enemy chars
        and     #$6f
        tay
        lda     $1360,y                 ; right half
        sta     tmp
        lda     $1350,y                 ; left half

        lsr                             ; shift right by 4 pixels
        ror     tmp
        lsr
        ror     tmp
        lsr
        ror     tmp
        lsr
        ror     tmp

        sta     $1450,y                 ; shifted sprite
        lda     tmp
        sta     $1460,y

        txa                             ; copy numbers from char rom
        asl                             ; double height
        tay
        lda     $80f8,x                 ; first copy wrong characters
        sta     $14f1,y                 ; then numbers starting at $8180
        sta     $14f2,y

        lda.w   vicsetup-$f8,x          ; vic-i chip setup
        sta     $900e-$f8,x

        txa                             ; drop and bullet chars
        and     #$07
        tay
        lda     $13b0,y                 ; drop
        sta     $14d0,y
        sta     $14e8,y

        lda     $13b8,y                 ; bullet
        sta     $1438,y
        sta     $1440,y
        lsr
        lsr
        lsr
        lsr
        sta     $1418,y
        sta     $1420,y
        
        inx
        bne     _inilp

        lda     #ATTACKWAVE
        sta     wavesiz


;-      new ship

newship:
        ldy     #$00
        lda     #$1d                    ; draw invisible wall to right
        sta     scrh
        lda     #$ff
        sta     scr
        ldx     #$02

_drwalp
        lda     #$40
        sta     (scr),y
        tya
        clc
        adc     #27
        tay
        bcc     _drwalp
        inc     scrh
        dex
        bne     _drwalp

        lda     #$18
        sta     shipx


;-----  main loop

mainloop:

;-      spawn enemies

        dec     spawn                   ; spawn timer countdown
        lda     spawn
        cmp     wavesiz
        bcs     _nospawn
        and     #$07                    ; attack wave rate
        bne     _nospawn

        cmp     $1e01                   ; don't spawn if no space
        bne     _nospawn

        tay                             ; a = 0
        sta     scr
        lda     #$1e
        sta     scrh
        lda     #$39
        jsr     drawmonster

        lda     #SNDFQ_SPWN             ; spawn sound
        sta     $900a

        lda     spawn                   ; no speed up if not last of wave
        bne     _nospawn
        lda     sprate                  ; reset spawn time
        cmp     #MAXSPAWNRATE           ; speed up spawn rate unless max
        beq     _spawnmax
        sec
        sbc     #SPAWNRATEUP
        sta     sprate
        inc     wavesiz                 ; bigger waves every 8th wave
_spawnmax
        sta     spawn
_nospawn

;-      check joystick

        lda     $9111                   ; check joystick left
        sta     tmp
        and     #$10
        bne     _notleft

        lda     shipx                   ; left limit
        beq     _notleft

        dec     shipx                   ; move player ship left
_notleft
        lda     shipx
        cmp     #$31
        beq     _notright

        lda     $9120                   ; check joystick right
        and     #$80
        bne     _notright

        inc     shipx                   ; move player ship right

_notright
        lda     tmp                     ; check joystick fire
        and     #$20
        bne     _nofire

        lda     run                     ; slow down autofire
        and     #$03
        bne     _nofire

        ldx     #$41
        lda     shipx
        lsr
        tay
        bcc     _firech
        ldx     #$43
        iny
_firech
        lda     $1f5f,y                 ; can't fire if blocked
        bne     _nofire
        txa
        sta     $1f5f,y                 ; fire char
        lda     #$06                    
        sta     $975f,y                 ; fire color

        lda     #SNDFQ_FIRE             ; fire sound
        sta     $900c
_nofire


;-      draw score

        jsr     writescore


;-      draw player ship

        ldx     #$35
        lda     shipx
        lsr
        bcc     _dslb                                        
        ldx     #$45
_dslb
        tay

        lda     $1f7a,y
        ora     $1f7b,y
        beq     _nocrash

        lda     #SNDFQ_EXPL             ; explosion
        sta     $900d
        inc     dead

_nocrash
        txa
        sta     $1f7a,y
        eor     #$03
        sta     $1f7b,y
        lda     #$01
        sta     $977a,y
        sta     $977b,y


;-      sync to screen refresh, do raster bars

framesync
        ldx     #$8d
_rastlp
        lda.w   rastercolor-$8d,x
_rwait
        cpx     $9004
        bne     _rwait
        sta     $900f
        inx
        cpx     #$96
        bne     _rastlp


;-      process sounds

        ldx     #$03
_sndlp
        lda     $900a,x                 ; $00-$7f = oscillator off
        bpl     _sndoff
        clc
        adc.w   soundtab,x              ; slide frequency
        sta     $900a,x
_sndoff
        dex
        bpl     _sndlp


;-      check game over loop

        lda     dead                    ; game over loop
        beq     _playon

        jmp     deadloop

_playon
        sta     $1f7a,y                 ; wipe player ship
        sta     $1f7b,y


;-      move screen

        inc     run
        lda     run
        and     #$02
        lsr
        adc     #$e4                    ; loop $e4, $e4, $e5, $e5
        sta     scr
        lda     #$1d
        sta     scrh

        lda     #202
        sta     cnt

moveloop:
        ldy     #28
        lda     (scr),y
        bne     _mschar
nextchar:
        lda     scr
        clc
        adc     #$02
        sta     scr
        bcc     _mlnc
        inc     scrh
_mlnc
        dec     cnt
        bne     moveloop

        jmp     mainloop

_mschar
        tax
        lda.w   movetab-$35,x
        sta.w   jmp_+1
jmp_
        jsr     move_bullet0
        jmp     nextchar


;-----  bullet hit

bullethit:
        and     #$0f
        cmp     #$0c                    ; check rock hit
        bcs     _hitrock
        cmp     #$07                    ; check enemy hit
        beq     _hitenemy
        cmp     #$09                    ; check enemy hit
        bne     move_ok                 ; rts there
        ;

;-      hit enemy

_hitenemy
        lda     #$3e
        sta     (scr),y
        jsr     colorloc
        lda     #$07
        sta     (color),y
        iny
        lda     #$00
        sta     (scr),y
        lda     #SNDFQ_EHIT
        sta     $900d
        lda     #$05
_hitc
        jmp     addscore


;-      hit rock

_hitrock
        lda     (scr),y
        cmp     #$40
        bcs     move_ok                 ; don't change drops
        clc
        adc     #$ff
        cmp     #$3b
        bne     _hitr
        lda     #$4e
_hitr
        sta     (scr),y
        lda     #SNDFQ_ROCK
        sta     $900b
        lda     #$01
        bne     _hitc

.ENDS


.ORG $1200
.SECTION "movement" FORCE

;-----  movement code, entry points must be located on the same memory page

move_bullet0:
        lda     (scr),y                 ; move bullet
        clc
        adc     #$01
        sta     (scr),y
move_ok:
        rts

move_bullet4:
        lda     (scr),y                 ; get bullet char
        clc
        adc     #$ff
        tax
        lda     #$00                    ; clear bullet
        sta     (scr),y

        ldy     #1                      ; check space above
        lda     (scr),y
        bne     bullethit
        txa
        sta     (scr),y

        jsr     colorloc                ; get color mem location

        lda     #$06
        sta     (color),y
        rts


;-      move drop down by 4 pixels

move_drop0:
        lda     #$4e
        sta     (scr),y
        rts


;-      move drop down by 4 pixels at char boundary, check collisions

move_drop4:
        lda     #$00                    ; clear drop
        sta     (scr),y

        ldy     #28+27                  ; check space below
        cmp     (scr),y
        bne     _mdrop

        lda     #$4d                    ; draw drop
        sta     (scr),y

        jsr     colorloc                ; get color mem location

        lda     #$04                    ; drop color
        sta     (color),y
_mdrop
        rts


;-      move enemy 4 pixels left at char boundary, check collisions

move_enemyl0:
        dey                             ; enemy move 4 pixels left, next char

        lda     (scr),y                 ; check collision to left
        beq     _melok                  ; move if free

        ldy     #28+27                  ; not free, check space below
        lda     (scr),y
        bne     _melta
        iny
        lda     (scr),y
        bne     _melta

        lda     #$39                    ; move down one line
        bne     enemydown

_melta
        ldy     #28                     ; enemy turn around
        lda     #$39
        bne     drawmonster

_melok
        lda     #$47                    ; draw monster left
        jsr     drawmonster

        lda     #$00                    ; wipe monster tail
        ldy     #29
        sta     (scr),y
        rts


;-      move enemy 4 pixels left

move_enemyl4:
        lda     #$37                    ; enemy move 4 pixels left
        bne     drawmonster


;-      move enemy 4 pixels right

move_enemyr0:
        lda     #$49                    ; enemy move 4 pixels right
        bne     drawmonster


;-      move enemy 4 pixels right at char boundary, check collisions

move_enemyr4:
        ldy     #30

        lda     (scr),y                 ; check collision
        beq     _merok

        ldy     #28+27                  ; not free, check space below
        lda     (scr),y
        bne     _merta
        iny
        lda     (scr),y
        bne     _merta

        lda     #$47                    ; move down one line
        bne     enemydown

_merta
        ldy     #28                     ; enemy turn around
        lda     #$47
        bne     drawmonster

_merok
        ldy     #29                     ; draw monster left
        lda     #$39
        jsr     drawmonster

        lda     #$00                    ; wipe monster tail
        ldy     #28
        sta     (scr),y
        rts


;-      move enemy down

enemydown:
        pha
        ldy     #28
        lda     #$00                    ; clear at current location
        sta     (scr),y
        iny
        sta     (scr),y

        lda     #SNDFQ_BUMP             ; bump sound
        sta     $900b

        ldy     #28+27                  ; move down
        pla
        ;

;-      draw monster

drawmonster:
        sta     (scr),y                 ; monster char
        iny
        clc
        adc     #$01
        sta     (scr),y

        jsr     colorloc                ; get color mem location

        lda     #$05                    ; monster color
        sta     (color),y
        dey
        sta     (color),y

        rts


;-----  write 5 digit score

writescore:
        ldy     #$03                    ; write score
        lda     score0
        jsr     _writebcd               ; write low 2 digits
        lda     score1
        ;
_writebcd
        pha
        and     #$0f
        jsr     _bcdigit
        pla
        lsr
        lsr
        lsr
        lsr
_bcdigit
        ora     #$50
        sta     $1f95,y
        dey
        rts


;-----  add score

addscore:
        sed
        clc
        adc     score0
        sta     score0
        lda     #$00
        adc     score1
        sta     score1
        cld
;        rts


;-----  get color mem location

colorloc:
        lda     scr
        sta     color
        lda     scrh
        eor     #$88
        sta     colorh
        rts




;-----  dead loop

deadloop:
        lda     $900d                   ; wait for explosion to stop
        bmi    _noreset
        lda     $9111
        and     #$20
        bne     _noreset

        sta     dead                    ; no longer dead

        ldx     $1f9d                   ; check if last ship
        cpx     #$50
        beq     _gameover

        dec     $1f9d                   ; decrease lives

        ldx     #217
_clrded
        sta     $1f95-217,x
        dex
        bne     _clrded

        jmp     newship
_gameover
        jmp     newgame

_noreset
        adc     $9124
        sta     $977a,y
        sta     $977b,y
        lda     #$39                    ; ship explosion
        sta     $1f7a,y
        lda     #$48
        sta     $1f7b,y
        jmp     framesync


;-----  misc. data

;-      move rules table

movetab:
        .DB     move_ok&255             ; $35
        .DB     move_ok&255
        .DB     move_enemyl0&255
        .DB     move_ok&255
        .DB     move_enemyr0&255
        .DB     move_ok&255
        .DB     move_ok&255
        .DB     move_ok&255

        .DB     move_ok&255             ; $3d
        .DB     move_ok&255
        .DB     move_ok&255
        .DB     move_ok&255             ; $40 wrapspace
        .DB     move_bullet0&255        ; $41
        .DB     move_bullet4&255
        .DB     move_bullet0&255
        .DB     move_bullet4&255

        .DB     move_ok&255             ; $45
        .DB     move_ok&255
        .DB     move_enemyl4&255
        .DB     move_ok&255
        .DB     move_enemyr4&255
        .DB     move_ok&255
        .DB     move_ok&255
        .DB     move_ok&255

        .DB     move_drop0&255          ; $4d drop
        .DB     move_drop4&255


;-      sound table (frequency slide speed for each voice)

soundtab:
        .DB     SNDSW_SPWN
        .DB     SNDSW_BUMP
        .DB     SNDSW_FIRE
        .DB     SNDSW_EXPL


;-      score display raster colors

rastercolor:
        .DB     $60,$e0,$30,$10,$10,$70,$a0,$20,$08


.ENDS


.ORG $1350
.SECTION "gfx" FORCE

;-----  graphics

.INCBIN "gfx.bin"


;-      vic-i chip setup

vicsetup:
        .DB     $0f,$08,$08,$15,$9b,$21,$00,$fc


;-      panel

panel:
        .DB     $50,$40,$45,$46,$52     ; fake zero, space, lives, ship


;-      signature

        .DB     "ae"

.ENDS
