#ifndef SPRITE_H
#define SPRITE_H

#include "main.h"

//for attribute0
#define SPRITE_ROTSCALE		BIT08
#define SPRITE_SD				BIT09
#define SPRITE_MODE_ALPHA	BIT10
#define SPRITE_MODE_WINDOW	BIT11
#define SPRITE_MOSAIC		BIT12
#define SPRITE_256COLOR		BIT13
#define SPRITE_SHAPE_H		BIT14
#define SPRITE_SHAPE_V		BIT15

//for attribute1
#define SPRITE_HFLIP			BIT12
#define SPRITE_VFLIP			BIT13
#define SPRITE_SIZE_16		BIT14
#define SPRITE_SIZE_32		BIT15
#define SPRITE_SIZE_64		(BIT14 | BIT15)
#define SPRITE_ROTDATA(n)	((n) & 7 << 9)

//for attribute2
#define SPRITE_PRIORITY(n)	((n) << 10)
#define SPRITE_PALETTE(n)	((n) << 12)

#define SPRITE_MOVING		BIT02
#define SPRITE_CANOB			BIT03
#define SPRITE_ISOB			BIT04
#define SPRITE_ALIVE			BIT07
#define SPRITE_DIR_D			0
#define SPRITE_DIR_L			1
#define SPRITE_DIR_U			2
#define SPRITE_DIR_R			3
#define SPRITE_FP				2

#define SpriteAttr0(yPos, flags) ((yPos) | (flags))
#define SpriteAttr1(xPos, rotData, flags) ((xPos) | ((rotData) << 9) | (flags))
#define SpriteAttr2(name, priority, pal) ((name) | ((priority) << 10) | ((pal) << 11))

typedef struct tagOamEntry
{
	u16 attribute0;
	u16 attribute1;
	u16 attribute2;
	u16 attribute3;
} OamEntry, *pOamEntry;

#endif
