#include "rotris.h"

.GLOBAL setSpiralPal
.GLOBAL drawSpiral
	
drawSpiral:
	stmfd sp!,{r0-r12,lr}
	mov r9,#4096
	sub r9,r9,#1
	mov r8,#3072
	mov r4,#0
	mov r11,#EX_WRAM
	ldr r12,=cosTable
_armloop:
	mov r10,r4,lsr #1
	add r10,r10,#128
	mov r5,r4,lsl #9  @ r5 = p1
	mov r6,#0         @ r6 = p2
	mov r7,#1328
_iloop:
	@cmp r7,#928  @ This speeds up the plotting
	@blt _calc
	@tst r7,#1
	@bne _cont
_calc:
	add r0,r8,r5,lsr #4
	and r0,r0,r9
	ldr r0,[r12,r0,lsl #2]
	smull r3,r0,r6,r0	
	
	cmp r0,#-120
	blt _cont
	cmp r0,#120
	bge _cont
	
	add r2,r0,#120

	and r0,r5,r9,lsl #4
	ldr r0,[r12,r0,lsr #2]
	
	smull r3,r0,r6,r0
	
	add r3,r0,#128
	add r2,r2,r3,lsl #8
	strb r10,[r11,r2]
	
_cont:	
	add r5,r5,#115
	add r6,r6,#7168+64
	subs r7,r7,#1
	bne _iloop
	add r4,r4,#1
	cmp r4,#128
	blt _armloop
	
	@ Copy from EX_WRAM to VRAM
	
	mov r3,#1024-600
	mov r5,#VRAM
	add r4,r5,r3,lsl #6
	mov r6,#SPIRAL_SB
	add r6,r5,r6,lsl #11
	
	@ r0=y, r1=x, r2=i, r3=j, r4=p, r5=q, r6=r
	
	mov r0,#0	
_yloop:
	mov r1,#0
_xloop:
	strh r3,[r6],#2
	add r3,r3,#1
	mov r5,#EX_WRAM
	add r7,r0,#6
	add r5,r5,r7,lsl #11
	add r5,r5,r1,lsl #3
	
	mov r9,#8
_jloop:
	ldr r7,[r5]
	ldr r8,[r5,#4]
	str r7,[r4],#4
	str r8,[r4],#4
	add r5,r5,#256
	subs r9,r9,#1
	bne _jloop
	
	add r1,r1,#1
	cmp r1,#30
	blt _xloop
	add r6,r6,#4
	add r0,r0,#1
	cmp r0,#20
	blt _yloop
	
	ldmfd sp!,{r0-r12,lr}
	bx lr
