#include "rotris.h"

.GLOBAL songUpdate
.GLOBAL songStart
.GLOBAL songStop

songUpdate:
	stmfd sp!,{r0-r12,lr}
	ldr r10,=song
	ldmia r10,{r2-r7}
	cmp r2,#0
	beq _songUpdateDone
	ldr r0,=lines
	ldr r0,[r0]
	add r0,r4,r0,lsr #1 @ BPM = BPM + lines cleared/2
	sub r7,r7,r0  @ song.tickcnt-=song.bpm
_newTick:	
	cmp r7,#0
	bgt _songUpdateDone   @ while (song.tickcnt<=0)
	add r7,r7,#149        @ song.tickcnt+=149;
	add r6,r6,#1
	cmp r6,r5
	blt _adjustVolEnv     @ if (++song.tick>=song.speed)
	mov r6,#0             @ song.tick=0;
	stmia r10,{r2-r7}
	add r11,r10,#SONG_CH
	@ r11->current channel
_processChannel:
	ldr r0,[r11,#CH_CNT]
	subs r0,r0,#1
	str r0,[r11,#CH_CNT]
	bgt _nextChannel

	ldmia r11,{r4-r9}
	
_search:
	cmp r6,#0
	bne _readdata    @ while (!ch->pos)
	ldrb r0,[r5],#1  @ j=*ch->patpos++;
	cmp r0,#64
	bge _checknext	 @ if (j<64)
@ Lookup start of pattern - slow but short	
	add r6,r2,#1
_nextLookup:
	add r6,r6,#1
	ldrb r1,[r6,#-2]
	cmp r1,#255
	bne _nextLookup
	ldrb r1,[r6,#-1]
	cmp r1,r0
	bne _nextLookup	   @ ch->pos=patLookup(j);
	b _search
_checknext:
	cmp r0,#128      @ else if (j<128)
	sublt r7,r0,#64  @ ch->cursmp=j-64;
	blt _search
	cmp r0,#144      @ else if (j<144)
	sublt r0,r0,#128  
	strlt r0,[r10,#SONG_SPEED] @ song.speed=j-128;
	@blt _search
	@cmp r0,#255
	@moveq r5,r4
	movge r5,r4     @ else ch->patpos=ch->patstart;
	@cmp r0,#253
	@bne _search
	@b _nextChannelSave
	b _search
	
_readdata:
	@ Read pattern data
	mov r0,r8  @ vol=ch->defvol;
	mov r9,#0  @ ch->volenv=0;
_readloop:
	ldrb r1,[r6],#1 @ j=*ch->pos++
	and r12,r1,#63  @ note=j&63
	subs r12,r12,#48 @ note-=48;
	mov r1,r1,lsr #6
	blt _readdone   @ if (note>=0)	
	@cmp r1,#1
	@addle r12,r12,#1
	@movle r0,r12,lsl #2  @ vol=(note+1)<<2;  (r1<2)
	@moveq r8,r0       @ ch->defvol=vol    (r1==1)
	cmp r1,#2	
	moveq r9,r12      @ ch->volenv=note;  (r1==2)
	@cmp r1,#3
	@moveq r7,r12      @ ch->cursmp=note;  (r1==3)
	movne r7,r12      @ ch->cursmp=note;  (r1==3)
	b _readloop
_readdone:
	stmfd sp!,{r0-r11}
	
	ldr r4,[r10,#SONG_NOCH]
	sub r4,r4,r3
	add r2,r12,#48
	mov r3,r0
	ldr r0,=smp
	add r1,r0,r7,lsl #4
	mov r0,r4
	
	cmp r2,#1
	@beq _stopnote
	blne playSample
	@b _calcdur
_stopnote:
	@bl wavStop
_calcdur:	

	ldmfd sp!,{r0-r11}
	
	add r0,r10,#SONG_NOTELEN
	ldr r0,[r0,r1,lsl #2]
	cmp r1,#3
	bne _adeflen
	ldrb r0,[r6],#1
_adeflen:
	str r0,[r11,#CH_CNT]
	
	ldrb r0,[r6]
	cmp r0,#255 @ if (*ch->pos==255)
	moveq r6,#0 @ ch->pos=0;

_nextChannelSave:	
	stmia r11,{r4-r9}
_nextChannel:	
	add r11,r11,#CH_SIZEOF
	subs r3,r3,#1
	bne _processChannel
	
	ldmia r10,{r2-r7}
	
_adjustVolEnv:
	ldr r0,=mix_ch
	add r11,r10,#SONG_CH
	mov r8,r3
_volEnvLoop:
	ldr r1,[r11,#CH_VOLENV]
	ldr r9,[r0]
	subs r9,r9,r1   @ mix_ch[i].vol-=song.ch[i].volenv;
	movlt r9,#0     @ if (mix_ch[i].vol<0) mix_ch[i].vol=0;
	str r9,[r0]	
	add r0,r0,#MIX_SIZEOF
	add r11,r11,#CH_SIZEOF
	subs r8,r8,#1
	bne _volEnvLoop

	b _newTick

_songUpdateDone:
	stmia r10,{r2-r7}
	ldmfd sp!,{r0-r12,lr}
	bx lr

@ r0->song data
songStart:
	ldrb r5,[r0],#1  @ song.speed=*(data++);
	ldrb r4,[r0],#1  @ song.bpm=*(data++);
	mov r6,r4        @ song.tick=song.bpm;
	sub r7,r5,#1     @ song.tickcnt=song.speed-1;
	ldrb r8,[r0],#1  @ song.notelen[0]=*(data++);
	ldrb r9,[r0],#1  @ song.notelen[1]=*(data++);
	ldrb r10,[r0],#1 @ song.notelen[2]=*(data++);
	ldrb r3,[r0],#1  @ song.noch=*(data++);
	ldr r1,=song
	stmia r1!,{r2-r10}
_songInitChannel:
	mov r4,r0
	mov r5,r0
	mov r6,#0
	mov r7,#0
	mov r8,#0x40
	mov r9,#0
	mov r10,#0
_chsearch:
	ldrb r2,[r0],#1
	cmp r2,#255
	bne _chsearch
	stmia r1!,{r4-r10}
	subs r3,r3,#1
	bne _songInitChannel

	ldr r1,=song
	str r0,[r1]
	b wavSetup

@songStop:
@	stmfd sp!,{lr}
@	mov r0,#-1
@	bl wavStop
@	mov r0,#0
@	ldr r1,=song
@	str r0,[r1]
@	ldmfd sp!,{lr}
@	bx lr

	.LTORG

	.BSS

song:
	.space SONG_SIZEOF

	.END
