/* this code is based on darkfader's mylib (www.darkfader.net) */

//////////////////////////////////////////////////////////////////////////////
// stdio.c                                                                  //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// includes                                                                 //
//////////////////////////////////////////////////////////////////////////////
#include "gba.h"
#include "bitmapfont.h"
//////////////////////////////////////////////////////////////////////////////
// variables                                                                //
//////////////////////////////////////////////////////////////////////////////
u8 wherex=0, wherey=0;


//////////////////////////////////////////////////////////////////////////////
// Putpixel                                                                  //
//////////////////////////////////////////////////////////////////////////////
void PutPixel(int x,int y,int col)
{
	*((volatile unsigned short*)(0x06000000 + (y*480) + (x<<1))) = col;
}

//////////////////////////////////////////////////////////////////////////////
// PutChar                                                                  //
//////////////////////////////////////////////////////////////////////////////
void PutChar(char c)
{
	u32 i,j,data;

	if (fontset[(u32)c]==NULL)	return;

	for (i=0;i<8;i++)
	{
		data = fontset[(u32)c][i];	

		for (j=0;j<8;j++)
			if (data&(0x80>>j))	
				PutPixel(wherex+j,wherey+i,0x7fff);
			else 	PutPixel(wherex+j,wherey+i,0);
	}
	wherex+=8;
	if (wherex >= 240)	{	wherex=0; wherey+=8;	}
}

//////////////////////////////////////////////////////////////////////////////
// PrintDec                                                                 //
//////////////////////////////////////////////////////////////////////////////
bool PrintDec(s16 n, u8 digits, u8 level, char nul)
{
	wherex=wherey=4;
	bool nz;
	if ((level == 0) && (n < 0)) { PutChar('-'); n=-n; digits--; }
	if (--digits) nz = PrintDec(n/10, digits, level+1, nul); else nz = 0;
	if (level == 0) nz = 1;
	if (n %= 10) nz = 1;
	if (nz) PutChar((char)('0'+n)); else PutChar(nul);
	return nz;
}
