#include "gba.h"
#include "worm.h"

/* extern variables */

extern u32 blockx,blocky;

/* create the worm motion */

IN_IWRAM void move_worm(worm_t *w)
{
	int i;
	static int gap = 0;

	if (gap<7)
	{
		gap++;
	}
	else 
	{
		gap=0;
		for (i=w->numParts;i>=1;i--)
		{
			w->x[i] = w->x[i-1];	w->dx[i] = w->dx[i-1];
			w->y[i] = w->y[i-1];	w->dy[i] = w->dy[i-1];
		}
	}
	w->x[0]+=w->dx[0];
	w->y[0]+=w->dy[0];
}

/* check the worm to see if it has hit itself 
   this is the main slowdown when the worm gets longer */

IN_IWRAM bool wormHitItself(worm_t *w)
{	
	u32 i;
	for (i=4;i<w->numParts;i++)
	{
		if ((w->x[i]) >= (w->x[0]+8)) continue;
		if ((w->y[i]) >= (w->y[0]+8)) continue;
		if (((w->x[i]+8)) <= (w->x[0])) continue;
		if (((w->y[i]+8)) <= (w->y[0])) continue;

		return true;
	}
	return false;
}

/* see if the worm has hit the edge of the screen */

IN_IWRAM bool wormHitEdge(worm_t *w)
{	
	if (w->x[0] > 232) return true;	
	if (w->x[0] < 0	 ) return true;
	if (w->y[0] > 152) return true;	
	if (w->y[0] < 0	 ) return true;
	return false;
}

/* get user input */

IN_IWRAM void getWormInput(worm_t *worm)
{
		if (KEY_DOWN_PRESSED)		
		{ 
			worm->dx[0] = 0; 
			worm->dy[0] = 1;
		}
		else if (KEY_UP_PRESSED)	
		{ 
			worm->dx[0] = 0;
			worm->dy[0] = -1; 
		}
		else if (KEY_LEFT_PRESSED)	
		{ 
			worm->dx[0] = -1;
			worm->dy[0] = 0; 
		}
		else if (KEY_RIGHT_PRESSED)	
		{ 
			worm->dx[0] = 1; 
			worm->dy[0] = 0;
		}
}

/* see if the worm has eaten the block */

IN_IWRAM bool hit_the_block(worm_t *worm)
{
	if (worm->x[0] > (blockx+8))	return false;
	if ((worm->x[0]+8) < (blockx)) return false;
	if (worm->y[0] > (blocky+8))	return false;
	if ((worm->y[0]+8) < (blocky)) return false;
	return true;
}

/* grows the worm when it has eaten */

IN_IWRAM bool checkMapAndGrow(worm_t *worm)
{
		if (hit_the_block(worm))
		{
			if (worm->numParts < 125)
			{
				worm->x[worm->numParts] = (worm->x[worm->numParts-1] +
										  ((-worm->dx[worm->numParts-1])<<3));
				worm->y[worm->numParts] = (worm->y[worm->numParts-1] +
										  ((-worm->dy[worm->numParts-1])<<3));
				worm->dx[worm->numParts] = worm->dx[worm->numParts-1];
				worm->dy[worm->numParts] = worm->dy[worm->numParts-1];
				worm->numParts++;
			}
			return true;
		}
		
	return false;
}

/* render the block to the screen */

IN_IWRAM void draw_the_block()
{
	int a,b;
	u16* vram = (u16*)0x06000000 + blockx+(blocky*240);
		
	for (b=0;b<8;b++)
	{
		for(a=0;a<8;a++)
		{
			vram[a+(b*240)] = RGB(0,0,31);//0x7fff;			
		}
	}
}

/* remove the block from the screen (when eaten) */

IN_IWRAM void remove_the_block()
{
	int a,b;
	u16* vram = (u16*)0x06000000 + blockx+(blocky*240);
		
	for (b=0;b<8;b++)
	{
		for(a=0;a<8;a++)
		{
			vram[a+(b*240)] = 0x0000;			
		}
	}
}
