format zx81
;labelusenumeric
;LISTOFF

	// hardware options to be set and change defaults in ZX81DEF.INC
	MEMAVL	   =	   MEM_16K	   // can be MEM_1K, MEM_2K, MEM_4K, MEM_8K, MEM_16K, MEM_32K, MEM_48K
					   // default value is MEM_16K
	STARTMODE  EQU	   SLOW_MODE	   // SLOW or FAST
	DFILETYPE  EQU	   COLLAPSED	   // COLLAPSED or EXPANDED or AUTO
;        STARTUPMSG EQU    'ADAMS TEST'     // any message will be shown on screen after loading, max. 32 chars

	include 'SINCL-ZX\ZX81.INC'	   // definitions of constants
;LISTON
AUTORUN:
	RAND USR #ENABLE_HIRES
	REM _hide _asm
scr_x_res	equ	32	;resolution in bytes
scr_y_res	equ	240	;nr of lines per field (because of interlace)
scr_start	equ	picture;$8000+256   ;start address of screen-buffer
PAL		equ	312
NTSC		equ	262
tv_std		equ	PAL
vsync_lines	equ	3
top_blank_lines equ	(tv_std - scr_y_res - vsync_lines)/2
bottom_blank_lines	equ	tv_std - scr_y_res - vsync_lines - top_blank_lines
frame_counter	equ	$4034;scr_start
field		db	0

ENABLE_HIRES:
	LD	IX,WRX16I	;simple start of the hires mode
	RET

	align 32
picture:
	file 'lena.bmp':146

lbuf:	ld	a,h
	ld	i,a
	ld	a,l
	ld	r,a		;load hfile address lsb
	repeat 32
	    nop
	end repeat
	ret	nz

WRX16I:
gen_vsync0:
	repeat 33
	    nop
	end repeat		;syncronize the VSYNC-start
	in	a,($fe) 	;VSYNC on, also HSYNC off
vsync_delay0:
	repeat 130
	    nop
	end repeat		;130 NOPS=2.5 lines
prepare_top_border0:
	ld	a,top_blank_lines
	neg
	inc	a
	ex	af,af'
	ld	ix,gen_hires0
	out	($fe),a 	;NMI-generator on
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines

gen_vsync1:
	repeat 6
	    nop
	end repeat		;syncronize the VSYNC-start
	in	a,($fe) 	;VSYNC on, also HSYNC off
vsync_delay1:
	repeat 130
	    nop
	end repeat		;130 NOPS=2.5 lines
prepare_top_border1:
	ld	a,top_blank_lines
	neg
	inc	a
	ex	af,af'
	ld	ix,gen_hires1
	out	($fe),a 	;NMI-generator on
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines

gen_hires0:
	nop
	nop
	ld	b,7
hr_delay0:
	djnz	hr_delay0	;delay to synchronize picture-start
	dec	b		;reset Z-flag
	ld	hl,scr_start	;start of hires-screen
	ld	de,scr_x_res*2
	ld	b,scr_y_res
hr10:
	call	lbuf+$8000	;start generating the hires-screen
	add	hl,de		;point to next hires-line
	dec	b
	jp	nz,hr10 	;repeat until last line is done
prepare_bottom_border0:
	ld	ix,gen_vsync1
field_set0:
	ld	a,bottom_blank_lines
	neg
	inc	a
	ex	af,af'
	out	($fe),a 	;NMI-generator on
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines

gen_hires1:
	nop
	nop
	ld	b,7
hr_delay1:
	djnz	hr_delay1	;delay to synchronize picture-start
	dec	b		;reset Z-flag
	ld	hl,scr_start+scr_x_res	  ;start of hires-screen
	ld	de,scr_x_res*2
	ld	b,scr_y_res
hr11:
	call	lbuf+$8000	;start generating the hires-screen
	add	hl,de		;point to next hires-line
	dec	b
	jp	nz,hr11 	;repeat until last line is done
frame_counter_update1:
	ld	hl,(frame_counter)
	inc	hl
	ld	(frame_counter),hl
prepare_bottom_border1:
	ld	ix,gen_vsync0
field_set1:
	ld	a,bottom_blank_lines
	neg
	inc	a
	ex	af,af'
	out	($fe),a 	;NMI-generator on
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret			;return to do some useful work, and generate bottom blank lines
	END _asm

	include 'SINCL-ZX\ZX81POST.INC' 	 ; include D_FILE and needed memory areas

assert ($-MEMST)<MEMAVL
// end of program