#include <math.h>

void iqsft12( float *y, const short *x )
{
    for( int i=0; i<128; i++ )
    {
        const float wi = float(i) * (2.0f*3.1415926535897932384626433832795f/4096.0f);
        #if 0
        const float sii = sinf( wi );
        const float coi = cosf( wi );
        #else
        float sii, coi;
        _asm fld dword ptr [wi]
        _asm fsincos
        _asm fstp dword ptr [coi]
        _asm fstp dword ptr [sii]
        #endif

        float co = 1.0f;
        float si = 0.0f;
        float acco = 0.0f;
        float acsi = 0.0f;
        for( int j=0; j<4096; j++ )
        {
            const float f = (float)(x[2*j+0]+x[2*j+1]);
            const float oco = co;
            acco += co*f; co = co*coi -  si*sii;
            acsi += si*f; si = si*coi + oco*sii;
        }
        y[i] = sqrtf(acco*acco+acsi*acsi)*(0.05f/32767.0f);
    }
}
