/*! Hammer.JS - v1.0.0rc1 - 2013-02-06
 * http://eightmedia.github.com/hammer.js
 *
 * Copyright (c) 2013 Jorik Tangelder <j.tangelder@gmail.com>;
 * Licensed under the MIT license */

(function(e){"use strict";function t(){if(!n.READY){n.event.determineEventTypes();for(var e in n.gestures)n.gestures.hasOwnProperty(e)&&n.gesture.register(n.gestures[e]);n.event.onTouch(document,n.EVENT_MOVE,n.gesture.detect),n.event.onTouch(document,n.EVENT_END,n.gesture.endDetect),n.READY=!0}}var n=function(e,t){return new n.Instance(e,t||{})};n.defaults={stop_browser_behavior:{userSelect:"none",touchCallout:"none",touchAction:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}},n.HAS_POINTEREVENTS=navigator.msPointerEnabled,n.HAS_TOUCHEVENTS="ontouchstart"in e,n.EVENT_TYPES={},n.DIRECTION_DOWN="down",n.DIRECTION_LEFT="left",n.DIRECTION_UP="up",n.DIRECTION_RIGHT="right",n.EVENT_START="start",n.EVENT_MOVE="move",n.EVENT_END="end",n.plugins={},n.READY=!1,n.Instance=function(e,r){var i=this;return t(),this.element=e,this.options=n.utils.extend(n.utils.extend({},n.defaults),r||{}),this.options.stop_browser_behavior&&n.utils.stopDefaultBrowserBehavior(this),n.event.onTouch(e,n.EVENT_START,function(e){return n.gesture.startDetect(i,e)}),this},n.Instance.prototype={on:function(e,t){e=e.split(" ");for(var n=0;e.length>n;n++)this.element.addEventListener(e[n],t,!1)},off:function(e,t){e=e.split(" ");for(var n=0;e.length>n;n++)this.element.removeEventListener(e[n],t,!1)},trigger:function(e,t){var n=document.createEvent("Event");return n.initEvent(e,!0,!0),n.gesture=t,this.element.dispatchEvent(n)}};var r={},i=!1;n.event={bindDom:function(e,t,n){t=t.split(" ");for(var r=0;t.length>r;r++)e.addEventListener(t[r],n,!1)},onTouch:function(e,t,s){function a(i){n.HAS_POINTEREVENTS&&n.PointerEvent.updatePointer(t,i),t===n.EVENT_END?i=r:r=i,s.call(n.gesture,o.collectEventData(e,t,i))}var o=this;n.HAS_TOUCHEVENTS||n.HAS_POINTEREVENTS?this.bindDom(e,n.EVENT_TYPES[t],a):this.bindDom(e,n.EVENT_TYPES[t],function(e){1===e.which&&(i=!0,a.apply(this,arguments)),"mouseup"==e.type&&(i=!1)})},determineEventTypes:function(){var e;e=n.HAS_POINTEREVENTS?["MSPointerDown","MSPointerMove","MSPointerUp MSPointerCancel"]:n.HAS_TOUCHEVENTS?["touchstart","touchmove","touchend touchcancel"]:["mousedown","mousemove","mouseup"],n.EVENT_TYPES[n.EVENT_START]=e[0],n.EVENT_TYPES[n.EVENT_MOVE]=e[1],n.EVENT_TYPES[n.EVENT_END]=e[2]},getTouchList:function(e){return n.HAS_POINTEREVENTS?n.PointerEvent.getPointers():n.HAS_TOUCHEVENTS?e.touches:[{identifier:1,pageX:e.pageX,pageY:e.pageY,target:e.target}]},collectEventData:function(e,t,r){var i=this.getTouchList(r,t);return{center:n.utils.getCenter(i),time:(new Date).getTime(),target:r.target,touches:i,eventType:t,srcEvent:r,preventDefault:function(){return this.srcEvent.preventDefault()}}}};var s=Math.PI;n.utils={extend:function(e,t,n){n=n||0;for(var r in t)t.hasOwnProperty(r)&&(e[r]=n&&"object"==typeof t[r]?this.extend({},t[r],n-1):t[r]);return e},getCenter:function(e){for(var t=[],n=[],r=0,i=e.length;i>r;r++)t.push(e[r].pageX),n.push(e[r].pageY);return{pageX:(Math.min.apply(Math,t)+Math.max.apply(Math,t))/2,pageY:(Math.min.apply(Math,n)+Math.max.apply(Math,n))/2}},getSimpleDistance:function(e,t){return Math.abs(t-e)},getAngle:function(e,t){var n=t.pageY-e.pageY,r=t.pageX-e.pageX;return 180*Math.atan2(n,r)/s},getDirection:function(e,t){var r=Math.abs(e.pageX-t.pageX),i=Math.abs(e.pageY-t.pageY);return r>=i?e.pageX-t.pageX>0?n.DIRECTION_LEFT:n.DIRECTION_RIGHT:e.pageY-t.pageY>0?n.DIRECTION_UP:n.DIRECTION_DOWN},getDistance:function(e,t){var n=t.pageX-e.pageX,r=t.pageY-e.pageY;return Math.sqrt(n*n+r*r)},getScale:function(e,t){return e.length>=2&&t.length>=2?this.getDistance(t[0],t[1])/this.getDistance(e[0],e[1]):1},getRotation:function(e,t){return e.length>=2&&t.length>=2?this.getAngle(t[1],t[0])-this.getAngle(e[1],e[0]):0},stopDefaultBrowserBehavior:function(e){var t,n=["webkit","khtml","moz","ms","o",""],r=e.options.stop_browser_behavior;if(r){for(var i=0;n.length>i;i++)for(var s in r)r.hasOwnProperty(s)&&(t=s,n[i]&&(t=n[i]+t.substring(0,1).toUpperCase()+t.substring(1)),e.element.style[t]=r[s]);"none"==r.userSelect&&(e.element.onselectstart=function(){return!1})}}},n.gesture={gestures:[],current:null,previous:null,startDetect:function(e,t){return this.current?undefined:(this.current={inst:e,startEvent:n.utils.extend({},t),lastEvent:!1,name:""},this.detect(t))},detect:function(e){if(this.current){for(var t=this.extendEventData(e),n=this.current.inst.options,r=0,i=this.gestures.length;i>r;r++){var s=this.gestures[r];if(n[s.name]!==!1&&s.handler.call(s,t,this.current.inst)===!1){this.stop();break}}this.current.lastEvent=t}},endDetect:function(e){this.detect(e),this.stop()},stop:function(){this.previous=n.utils.extend({},this.current),this.current=null},extendEventData:function(e){var t=this.current.startEvent;return t&&e.touches.length!=t.touches.length&&(t.touches=n.utils.extend({},e.touches,1)),n.utils.extend(e,{touchTime:e.time-t.time,angle:n.utils.getAngle(t.center,e.center),direction:n.utils.getDirection(t.center,e.center),distance:n.utils.getDistance(t.center,e.center),distanceX:n.utils.getSimpleDistance(t.center.pageX,e.center.pageX),distanceY:n.utils.getSimpleDistance(t.center.pageY,e.center.pageY),scale:n.utils.getScale(t.touches,e.touches),rotation:n.utils.getRotation(t.touches,e.touches),startEvent:t}),e},register:function(e){var t=e.defaults||{};return t[e.name]===undefined&&(t[e.name]=!0),n.utils.extend(n.defaults,t),e.index=e.index||1e3,this.gestures.push(e),this.gestures.sort(function(e,t){return e.index<t.index?-1:e.index>t.index?1:0}),this.gestures}},n.gestures=n.gestures||{},n.gestures.Hold={name:"hold",index:10,defaults:{hold_timeout:500,hold_threshold:2},timer:null,handler:function(e,t){switch(e.eventType){case n.EVENT_START:clearTimeout(this.timer),n.gesture.current.name=this.name,this.timer=setTimeout(function(){"hold"==n.gesture.current.name&&t.trigger("hold",e)},t.options.hold_timeout);break;case n.EVENT_MOVE:e.distance>t.options.hold_treshold&&clearTimeout(this.timer);break;case n.EVENT_END:clearTimeout(this.timer)}}},n.gestures.Tap={name:"tap",index:100,defaults:{tap_max_touchtime:250,tap_max_distance:10,doubletap_distance:20,doubletap_interval:300},handler:function(e,t){if(e.eventType==n.EVENT_END){var r=n.gesture.previous;if(e.touchTime>t.options.tap_max_touchtime||e.distance>t.options.tap_max_distance)return;n.gesture.current.name=r&&"tap"==r.name&&e.time-r.lastEvent.time<t.options.doubletap_interval&&e.distance<t.options.doubletap_distance?"doubletap":"tap",t.trigger(n.gesture.current.name,e)}}},n.gestures.Drag={name:"drag",index:50,defaults:{drag_min_distance:10,drag_max_touches:1,drag_block_horizontal:!1,drag_block_vertical:!1},handler:function(e,t){if(!(t.options.drag_max_touches>0&&e.touches.length>t.options.drag_max_touches)&&e.eventType==n.EVENT_MOVE){if(e.distance<t.options.drag_min_distance&&n.gesture.current.name!=this.name)return;n.gesture.current.name=this.name,t.trigger(this.name,e),t.trigger(this.name+e.direction,e),(t.options.drag_block_vertical&&(e.direction==n.DIRECTION_UP||e.direction==n.DIRECTION_DOWN)||t.options.drag_block_horizontal&&(e.direction==n.DIRECTION_LEFT||e.direction==n.DIRECTION_RIGHT))&&e.preventDefault()}}},n.gestures.Swipe={name:"swipe",index:51,defaults:{swipe_min_time:150,swipe_max_time:500,swipe_min_distance:30},handler:function(e,t){e.eventType==n.EVENT_END&&"drag"==n.gesture.current.name&&e.touchTime>t.options.swipe_min_time&&e.touchTime<t.options.swipe_max_time&&e.distance>t.options.swipe_min_distance&&(t.trigger(this.name,e),t.trigger(this.name+e.direction,e))}},n.gestures.Transform={name:"transform",index:45,defaults:{transform_min_scale:.01,transform_min_rotation:1,transform_always_block:!1},handler:function(e,t){if(t.options.transform_always_block&&2==e.touches.length&&e.preventDefault(),e.eventType==n.EVENT_MOVE&&2==e.touches.length){var r=Math.abs(1-e.scale),i=Math.abs(e.rotation);if(t.options.transform_min_scale>r&&t.options.transform_min_rotation>i)return;n.gesture.current.name=this.name,t.trigger(this.name,e),i>t.options.transform_min_rotation&&t.trigger("rotate",e),r>t.options.transform_min_scale&&(t.trigger("pinch",e),t.trigger("pinch"+(1>e.scale?"in":"out"),e))}}},n.gestures.Touch={name:"touch",index:-1/0,handler:function(e,t){e.eventType==n.EVENT_START&&t.trigger(this.name,e)}},n.gestures.Release={name:"release",index:1/0,handler:function(e,t){e.eventType==n.EVENT_END&&t.trigger(this.name,e)}},e.Hammer=n,"function"==typeof e.define&&e.define.amd&&e.define("hammer",[],function(){return n})})(window);